--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorThreshold = {}

---@class SensorIpmiCmds.GetSensorThresholdReq
---@field Number integer
local TGetSensorThresholdReq = {}
TGetSensorThresholdReq.__index = TGetSensorThresholdReq
TGetSensorThresholdReq.group = {}

local function TGetSensorThresholdReq_from_obj(obj)
    return setmetatable(obj, TGetSensorThresholdReq)
end

function TGetSensorThresholdReq.new(Number)
    return TGetSensorThresholdReq_from_obj({Number = Number})
end
---@param obj SensorIpmiCmds.GetSensorThresholdReq
function TGetSensorThresholdReq:init_from_obj(obj)
    self.Number = obj.Number
end

function TGetSensorThresholdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorThresholdReq.group)
end

TGetSensorThresholdReq.from_obj = TGetSensorThresholdReq_from_obj

TGetSensorThresholdReq.proto_property = {'Number'}

TGetSensorThresholdReq.default = {0}

TGetSensorThresholdReq.struct = {{name = 'Number', is_array = false, struct = nil}}

function TGetSensorThresholdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)

    TGetSensorThresholdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorThresholdReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorThresholdReq:unpack(_)
    return self.Number
end

GetSensorThreshold.GetSensorThresholdReq = TGetSensorThresholdReq

---@class SensorIpmiCmds.GetSensorThresholdRsp
---@field CompletionCode integer
---@field LNCFlag integer
---@field LCRFlag integer
---@field LNRFlag integer
---@field UNCFlag integer
---@field UCRFlag integer
---@field UNRFlag integer
---@field Reserved integer
---@field LNCValue integer
---@field LCRValue integer
---@field LNRValue integer
---@field UNCValue integer
---@field UCRValue integer
---@field UNRValue integer
local TGetSensorThresholdRsp = {}
TGetSensorThresholdRsp.__index = TGetSensorThresholdRsp
TGetSensorThresholdRsp.group = {}

local function TGetSensorThresholdRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorThresholdRsp)
end

function TGetSensorThresholdRsp.new(CompletionCode, LNCFlag, LCRFlag, LNRFlag, UNCFlag, UCRFlag, UNRFlag, Reserved,
    LNCValue, LCRValue, LNRValue, UNCValue, UCRValue, UNRValue)
    return TGetSensorThresholdRsp_from_obj({
        CompletionCode = CompletionCode,
        LNCFlag = LNCFlag,
        LCRFlag = LCRFlag,
        LNRFlag = LNRFlag,
        UNCFlag = UNCFlag,
        UCRFlag = UCRFlag,
        UNRFlag = UNRFlag,
        Reserved = Reserved,
        LNCValue = LNCValue,
        LCRValue = LCRValue,
        LNRValue = LNRValue,
        UNCValue = UNCValue,
        UCRValue = UCRValue,
        UNRValue = UNRValue
    })
end
---@param obj SensorIpmiCmds.GetSensorThresholdRsp
function TGetSensorThresholdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.LNCFlag = obj.LNCFlag
    self.LCRFlag = obj.LCRFlag
    self.LNRFlag = obj.LNRFlag
    self.UNCFlag = obj.UNCFlag
    self.UCRFlag = obj.UCRFlag
    self.UNRFlag = obj.UNRFlag
    self.Reserved = obj.Reserved
    self.LNCValue = obj.LNCValue
    self.LCRValue = obj.LCRValue
    self.LNRValue = obj.LNRValue
    self.UNCValue = obj.UNCValue
    self.UCRValue = obj.UCRValue
    self.UNRValue = obj.UNRValue
end

function TGetSensorThresholdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorThresholdRsp.group)
end

TGetSensorThresholdRsp.from_obj = TGetSensorThresholdRsp_from_obj

TGetSensorThresholdRsp.proto_property = {
    'CompletionCode', 'LNCFlag', 'LCRFlag', 'LNRFlag', 'UNCFlag', 'UCRFlag', 'UNRFlag', 'Reserved', 'LNCValue',
    'LCRValue', 'LNRValue', 'UNCValue', 'UCRValue', 'UNRValue'
}

TGetSensorThresholdRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetSensorThresholdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'LNCFlag', is_array = false, struct = nil},
    {name = 'LCRFlag', is_array = false, struct = nil}, {name = 'LNRFlag', is_array = false, struct = nil},
    {name = 'UNCFlag', is_array = false, struct = nil}, {name = 'UCRFlag', is_array = false, struct = nil},
    {name = 'UNRFlag', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'LNCValue', is_array = false, struct = nil}, {name = 'LCRValue', is_array = false, struct = nil},
    {name = 'LNRValue', is_array = false, struct = nil}, {name = 'UNCValue', is_array = false, struct = nil},
    {name = 'UCRValue', is_array = false, struct = nil}, {name = 'UNRValue', is_array = false, struct = nil}
}

function TGetSensorThresholdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNCFlag', self.LNCFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LCRFlag', self.LCRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNRFlag', self.LNRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNCFlag', self.UNCFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UCRFlag', self.UCRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNRFlag', self.UNRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNCValue', self.LNCValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LCRValue', self.LCRValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNRValue', self.LNRValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNCValue', self.UNCValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UCRValue', self.UCRValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNRValue', self.UNRValue, 'uint8', false, errs, need_convert)

    TGetSensorThresholdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorThresholdRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorThresholdRsp:unpack(_)
    return self.CompletionCode, self.LNCFlag, self.LCRFlag, self.LNRFlag, self.UNCFlag, self.UCRFlag, self.UNRFlag,
        self.Reserved, self.LNCValue, self.LCRValue, self.LNRValue, self.UNCValue, self.UCRValue, self.UNRValue
end

GetSensorThreshold.GetSensorThresholdRsp = TGetSensorThresholdRsp

return GetSensorThreshold
