--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorEventReceiver = {}

---@class SensorIpmiCmds.GetSensorEventReceiverReq
local TGetSensorEventReceiverReq = {}
TGetSensorEventReceiverReq.__index = TGetSensorEventReceiverReq
TGetSensorEventReceiverReq.group = {}

local function TGetSensorEventReceiverReq_from_obj(obj)
    return setmetatable(obj, TGetSensorEventReceiverReq)
end

function TGetSensorEventReceiverReq.new()
    return TGetSensorEventReceiverReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSensorEventReceiverReq
function TGetSensorEventReceiverReq:init_from_obj(obj)

end

function TGetSensorEventReceiverReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorEventReceiverReq.group)
end

TGetSensorEventReceiverReq.from_obj = TGetSensorEventReceiverReq_from_obj

TGetSensorEventReceiverReq.proto_property = {}

TGetSensorEventReceiverReq.default = {}

TGetSensorEventReceiverReq.struct = {}

function TGetSensorEventReceiverReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSensorEventReceiverReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorEventReceiverReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorEventReceiverReq:unpack(_)
end

GetSensorEventReceiver.GetSensorEventReceiverReq = TGetSensorEventReceiverReq

---@class SensorIpmiCmds.GetSensorEventReceiverRsp
---@field CompletionCode integer
---@field Addr integer
---@field Reserved integer
---@field Lun integer
local TGetSensorEventReceiverRsp = {}
TGetSensorEventReceiverRsp.__index = TGetSensorEventReceiverRsp
TGetSensorEventReceiverRsp.group = {}

local function TGetSensorEventReceiverRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorEventReceiverRsp)
end

function TGetSensorEventReceiverRsp.new(CompletionCode, Addr, Reserved, Lun)
    return TGetSensorEventReceiverRsp_from_obj({
        CompletionCode = CompletionCode,
        Addr = Addr,
        Reserved = Reserved,
        Lun = Lun
    })
end
---@param obj SensorIpmiCmds.GetSensorEventReceiverRsp
function TGetSensorEventReceiverRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Addr = obj.Addr
    self.Reserved = obj.Reserved
    self.Lun = obj.Lun
end

function TGetSensorEventReceiverRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorEventReceiverRsp.group)
end

TGetSensorEventReceiverRsp.from_obj = TGetSensorEventReceiverRsp_from_obj

TGetSensorEventReceiverRsp.proto_property = {'CompletionCode', 'Addr', 'Reserved', 'Lun'}

TGetSensorEventReceiverRsp.default = {0, 0, 0, 0}

TGetSensorEventReceiverRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Addr', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Lun', is_array = false, struct = nil}
}

function TGetSensorEventReceiverRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Addr', self.Addr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Lun', self.Lun, 'uint8', false, errs, need_convert)

    TGetSensorEventReceiverRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorEventReceiverRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorEventReceiverRsp:unpack(_)
    return self.CompletionCode, self.Addr, self.Reserved, self.Lun
end

GetSensorEventReceiver.GetSensorEventReceiverRsp = TGetSensorEventReceiverRsp

return GetSensorEventReceiver
