--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSelInfo = {}

---@class SensorIpmiCmds.GetSelInfoReq
local TGetSelInfoReq = {}
TGetSelInfoReq.__index = TGetSelInfoReq
TGetSelInfoReq.group = {}

local function TGetSelInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSelInfoReq)
end

function TGetSelInfoReq.new()
    return TGetSelInfoReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSelInfoReq
function TGetSelInfoReq:init_from_obj(obj)

end

function TGetSelInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelInfoReq.group)
end

TGetSelInfoReq.from_obj = TGetSelInfoReq_from_obj

TGetSelInfoReq.proto_property = {}

TGetSelInfoReq.default = {}

TGetSelInfoReq.struct = {}

function TGetSelInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSelInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSelInfoReq:unpack(_)
end

GetSelInfo.GetSelInfoReq = TGetSelInfoReq

---@class SensorIpmiCmds.GetSelInfoRsp
---@field CompletionCode integer
---@field SelVersion integer
---@field SelCountL integer
---@field SelCountH integer
---@field FreeL integer
---@field FreeH integer
---@field AddTime0 integer
---@field AddTime1 integer
---@field AddTime2 integer
---@field AddTime3 integer
---@field DelTime0 integer
---@field DelTime1 integer
---@field DelTime2 integer
---@field DelTime3 integer
---@field OperationSupport integer
local TGetSelInfoRsp = {}
TGetSelInfoRsp.__index = TGetSelInfoRsp
TGetSelInfoRsp.group = {}

local function TGetSelInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSelInfoRsp)
end

function TGetSelInfoRsp.new(CompletionCode, SelVersion, SelCountL, SelCountH, FreeL, FreeH, AddTime0, AddTime1,
    AddTime2, AddTime3, DelTime0, DelTime1, DelTime2, DelTime3, OperationSupport)
    return TGetSelInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        SelVersion = SelVersion,
        SelCountL = SelCountL,
        SelCountH = SelCountH,
        FreeL = FreeL,
        FreeH = FreeH,
        AddTime0 = AddTime0,
        AddTime1 = AddTime1,
        AddTime2 = AddTime2,
        AddTime3 = AddTime3,
        DelTime0 = DelTime0,
        DelTime1 = DelTime1,
        DelTime2 = DelTime2,
        DelTime3 = DelTime3,
        OperationSupport = OperationSupport
    })
end
---@param obj SensorIpmiCmds.GetSelInfoRsp
function TGetSelInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.SelVersion = obj.SelVersion
    self.SelCountL = obj.SelCountL
    self.SelCountH = obj.SelCountH
    self.FreeL = obj.FreeL
    self.FreeH = obj.FreeH
    self.AddTime0 = obj.AddTime0
    self.AddTime1 = obj.AddTime1
    self.AddTime2 = obj.AddTime2
    self.AddTime3 = obj.AddTime3
    self.DelTime0 = obj.DelTime0
    self.DelTime1 = obj.DelTime1
    self.DelTime2 = obj.DelTime2
    self.DelTime3 = obj.DelTime3
    self.OperationSupport = obj.OperationSupport
end

function TGetSelInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSelInfoRsp.group)
end

TGetSelInfoRsp.from_obj = TGetSelInfoRsp_from_obj

TGetSelInfoRsp.proto_property = {
    'CompletionCode', 'SelVersion', 'SelCountL', 'SelCountH', 'FreeL', 'FreeH', 'AddTime0', 'AddTime1', 'AddTime2',
    'AddTime3', 'DelTime0', 'DelTime1', 'DelTime2', 'DelTime3', 'OperationSupport'
}

TGetSelInfoRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetSelInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'SelVersion', is_array = false, struct = nil},
    {name = 'SelCountL', is_array = false, struct = nil}, {name = 'SelCountH', is_array = false, struct = nil},
    {name = 'FreeL', is_array = false, struct = nil}, {name = 'FreeH', is_array = false, struct = nil},
    {name = 'AddTime0', is_array = false, struct = nil}, {name = 'AddTime1', is_array = false, struct = nil},
    {name = 'AddTime2', is_array = false, struct = nil}, {name = 'AddTime3', is_array = false, struct = nil},
    {name = 'DelTime0', is_array = false, struct = nil}, {name = 'DelTime1', is_array = false, struct = nil},
    {name = 'DelTime2', is_array = false, struct = nil}, {name = 'DelTime3', is_array = false, struct = nil},
    {name = 'OperationSupport', is_array = false, struct = nil}
}

function TGetSelInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SelVersion', self.SelVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SelCountL', self.SelCountL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SelCountH', self.SelCountH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeL', self.FreeL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeH', self.FreeH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime0', self.AddTime0, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime1', self.AddTime1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime2', self.AddTime2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime3', self.AddTime3, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime0', self.DelTime0, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime1', self.DelTime1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime2', self.DelTime2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime3', self.DelTime3, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OperationSupport', self.OperationSupport, 'uint8', false, errs, need_convert)

    TGetSelInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSelInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSelInfoRsp:unpack(_)
    return self.CompletionCode, self.SelVersion, self.SelCountL, self.SelCountH, self.FreeL, self.FreeH, self.AddTime0,
        self.AddTime1, self.AddTime2, self.AddTime3, self.DelTime0, self.DelTime1, self.DelTime2, self.DelTime3,
        self.OperationSupport
end

GetSelInfo.GetSelInfoRsp = TGetSelInfoRsp

return GetSelInfo
