--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSDRReserveId = {}

---@class SensorIpmiCmds.GetSDRReserveIdReq
local TGetSDRReserveIdReq = {}
TGetSDRReserveIdReq.__index = TGetSDRReserveIdReq
TGetSDRReserveIdReq.group = {}

local function TGetSDRReserveIdReq_from_obj(obj)
    return setmetatable(obj, TGetSDRReserveIdReq)
end

function TGetSDRReserveIdReq.new()
    return TGetSDRReserveIdReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSDRReserveIdReq
function TGetSDRReserveIdReq:init_from_obj(obj)

end

function TGetSDRReserveIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRReserveIdReq.group)
end

TGetSDRReserveIdReq.from_obj = TGetSDRReserveIdReq_from_obj

TGetSDRReserveIdReq.proto_property = {}

TGetSDRReserveIdReq.default = {}

TGetSDRReserveIdReq.struct = {}

function TGetSDRReserveIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSDRReserveIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRReserveIdReq.proto_property, errs, need_convert)
    return self
end

function TGetSDRReserveIdReq:unpack(_)
end

GetSDRReserveId.GetSDRReserveIdReq = TGetSDRReserveIdReq

---@class SensorIpmiCmds.GetSDRReserveIdRsp
---@field CompletionCode integer
---@field ReserveIdL integer
---@field ReserveIdH integer
local TGetSDRReserveIdRsp = {}
TGetSDRReserveIdRsp.__index = TGetSDRReserveIdRsp
TGetSDRReserveIdRsp.group = {}

local function TGetSDRReserveIdRsp_from_obj(obj)
    return setmetatable(obj, TGetSDRReserveIdRsp)
end

function TGetSDRReserveIdRsp.new(CompletionCode, ReserveIdL, ReserveIdH)
    return TGetSDRReserveIdRsp_from_obj({
        CompletionCode = CompletionCode,
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH
    })
end
---@param obj SensorIpmiCmds.GetSDRReserveIdRsp
function TGetSDRReserveIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
end

function TGetSDRReserveIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRReserveIdRsp.group)
end

TGetSDRReserveIdRsp.from_obj = TGetSDRReserveIdRsp_from_obj

TGetSDRReserveIdRsp.proto_property = {'CompletionCode', 'ReserveIdL', 'ReserveIdH'}

TGetSDRReserveIdRsp.default = {0, 0, 0}

TGetSDRReserveIdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ReserveIdL', is_array = false, struct = nil},
    {name = 'ReserveIdH', is_array = false, struct = nil}
}

function TGetSDRReserveIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)

    TGetSDRReserveIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRReserveIdRsp.proto_property, errs, need_convert)
    return self
end

function TGetSDRReserveIdRsp:unpack(_)
    return self.CompletionCode, self.ReserveIdL, self.ReserveIdH
end

GetSDRReserveId.GetSDRReserveIdRsp = TGetSDRReserveIdRsp

return GetSDRReserveId
