--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSDRRepoInfo = {}

---@class SensorIpmiCmds.GetSDRRepoInfoReq
local TGetSDRRepoInfoReq = {}
TGetSDRRepoInfoReq.__index = TGetSDRRepoInfoReq
TGetSDRRepoInfoReq.group = {}

local function TGetSDRRepoInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSDRRepoInfoReq)
end

function TGetSDRRepoInfoReq.new()
    return TGetSDRRepoInfoReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSDRRepoInfoReq
function TGetSDRRepoInfoReq:init_from_obj(obj)

end

function TGetSDRRepoInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRRepoInfoReq.group)
end

TGetSDRRepoInfoReq.from_obj = TGetSDRRepoInfoReq_from_obj

TGetSDRRepoInfoReq.proto_property = {}

TGetSDRRepoInfoReq.default = {}

TGetSDRRepoInfoReq.struct = {}

function TGetSDRRepoInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSDRRepoInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRRepoInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSDRRepoInfoReq:unpack(_)
end

GetSDRRepoInfo.GetSDRRepoInfoReq = TGetSDRRepoInfoReq

---@class SensorIpmiCmds.GetSDRRepoInfoRsp
---@field CompletionCode integer
---@field SDRVersion integer
---@field RecordCountL integer
---@field RecordCountH integer
---@field FreeL integer
---@field FreeH integer
---@field AddTime0 integer
---@field AddTime1 integer
---@field AddTime2 integer
---@field AddTime3 integer
---@field DelTime0 integer
---@field DelTime1 integer
---@field DelTime2 integer
---@field DelTime3 integer
---@field OpSupport integer
local TGetSDRRepoInfoRsp = {}
TGetSDRRepoInfoRsp.__index = TGetSDRRepoInfoRsp
TGetSDRRepoInfoRsp.group = {}

local function TGetSDRRepoInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSDRRepoInfoRsp)
end

function TGetSDRRepoInfoRsp.new(CompletionCode, SDRVersion, RecordCountL, RecordCountH, FreeL, FreeH, AddTime0,
    AddTime1, AddTime2, AddTime3, DelTime0, DelTime1, DelTime2, DelTime3, OpSupport)
    return TGetSDRRepoInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        SDRVersion = SDRVersion,
        RecordCountL = RecordCountL,
        RecordCountH = RecordCountH,
        FreeL = FreeL,
        FreeH = FreeH,
        AddTime0 = AddTime0,
        AddTime1 = AddTime1,
        AddTime2 = AddTime2,
        AddTime3 = AddTime3,
        DelTime0 = DelTime0,
        DelTime1 = DelTime1,
        DelTime2 = DelTime2,
        DelTime3 = DelTime3,
        OpSupport = OpSupport
    })
end
---@param obj SensorIpmiCmds.GetSDRRepoInfoRsp
function TGetSDRRepoInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.SDRVersion = obj.SDRVersion
    self.RecordCountL = obj.RecordCountL
    self.RecordCountH = obj.RecordCountH
    self.FreeL = obj.FreeL
    self.FreeH = obj.FreeH
    self.AddTime0 = obj.AddTime0
    self.AddTime1 = obj.AddTime1
    self.AddTime2 = obj.AddTime2
    self.AddTime3 = obj.AddTime3
    self.DelTime0 = obj.DelTime0
    self.DelTime1 = obj.DelTime1
    self.DelTime2 = obj.DelTime2
    self.DelTime3 = obj.DelTime3
    self.OpSupport = obj.OpSupport
end

function TGetSDRRepoInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRRepoInfoRsp.group)
end

TGetSDRRepoInfoRsp.from_obj = TGetSDRRepoInfoRsp_from_obj

TGetSDRRepoInfoRsp.proto_property = {
    'CompletionCode', 'SDRVersion', 'RecordCountL', 'RecordCountH', 'FreeL', 'FreeH', 'AddTime0', 'AddTime1',
    'AddTime2', 'AddTime3', 'DelTime0', 'DelTime1', 'DelTime2', 'DelTime3', 'OpSupport'
}

TGetSDRRepoInfoRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetSDRRepoInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'SDRVersion', is_array = false, struct = nil},
    {name = 'RecordCountL', is_array = false, struct = nil}, {name = 'RecordCountH', is_array = false, struct = nil},
    {name = 'FreeL', is_array = false, struct = nil}, {name = 'FreeH', is_array = false, struct = nil},
    {name = 'AddTime0', is_array = false, struct = nil}, {name = 'AddTime1', is_array = false, struct = nil},
    {name = 'AddTime2', is_array = false, struct = nil}, {name = 'AddTime3', is_array = false, struct = nil},
    {name = 'DelTime0', is_array = false, struct = nil}, {name = 'DelTime1', is_array = false, struct = nil},
    {name = 'DelTime2', is_array = false, struct = nil}, {name = 'DelTime3', is_array = false, struct = nil},
    {name = 'OpSupport', is_array = false, struct = nil}
}

function TGetSDRRepoInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SDRVersion', self.SDRVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordCountL', self.RecordCountL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordCountH', self.RecordCountH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeL', self.FreeL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeH', self.FreeH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime0', self.AddTime0, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime1', self.AddTime1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime2', self.AddTime2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AddTime3', self.AddTime3, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime0', self.DelTime0, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime1', self.DelTime1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime2', self.DelTime2, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DelTime3', self.DelTime3, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OpSupport', self.OpSupport, 'uint8', false, errs, need_convert)

    TGetSDRRepoInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRRepoInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSDRRepoInfoRsp:unpack(_)
    return self.CompletionCode, self.SDRVersion, self.RecordCountL, self.RecordCountH, self.FreeL, self.FreeH,
        self.AddTime0, self.AddTime1, self.AddTime2, self.AddTime3, self.DelTime0, self.DelTime1, self.DelTime2,
        self.DelTime3, self.OpSupport
end

GetSDRRepoInfo.GetSDRRepoInfoRsp = TGetSDRRepoInfoRsp

return GetSDRRepoInfo
