--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPEFParameters = {}

---@class SensorIpmiCmds.GetPEFParametersReq
---@field Selector integer
---@field Revision integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetPEFParametersReq = {}
TGetPEFParametersReq.__index = TGetPEFParametersReq
TGetPEFParametersReq.group = {}

local function TGetPEFParametersReq_from_obj(obj)
    return setmetatable(obj, TGetPEFParametersReq)
end

function TGetPEFParametersReq.new(Selector, Revision, SetSelector, BlockSelector)
    return TGetPEFParametersReq_from_obj({
        Selector = Selector,
        Revision = Revision,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj SensorIpmiCmds.GetPEFParametersReq
function TGetPEFParametersReq:init_from_obj(obj)
    self.Selector = obj.Selector
    self.Revision = obj.Revision
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetPEFParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPEFParametersReq.group)
end

TGetPEFParametersReq.from_obj = TGetPEFParametersReq_from_obj

TGetPEFParametersReq.proto_property = {'Selector', 'Revision', 'SetSelector', 'BlockSelector'}

TGetPEFParametersReq.default = {0, 0, 0, 0}

TGetPEFParametersReq.struct = {
    {name = 'Selector', is_array = false, struct = nil}, {name = 'Revision', is_array = false, struct = nil},
    {name = 'SetSelector', is_array = false, struct = nil}, {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetPEFParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Selector', self.Selector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Revision', self.Revision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetPEFParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPEFParametersReq.proto_property, errs, need_convert)
    return self
end

function TGetPEFParametersReq:unpack(_)
    return self.Selector, self.Revision, self.SetSelector, self.BlockSelector
end

GetPEFParameters.GetPEFParametersReq = TGetPEFParametersReq

---@class SensorIpmiCmds.GetPEFParametersRsp
---@field CompletionCode integer
---@field Revision integer
---@field Datas string
local TGetPEFParametersRsp = {}
TGetPEFParametersRsp.__index = TGetPEFParametersRsp
TGetPEFParametersRsp.group = {}

local function TGetPEFParametersRsp_from_obj(obj)
    return setmetatable(obj, TGetPEFParametersRsp)
end

function TGetPEFParametersRsp.new(CompletionCode, Revision, Datas)
    return TGetPEFParametersRsp_from_obj({CompletionCode = CompletionCode, Revision = Revision, Datas = Datas})
end
---@param obj SensorIpmiCmds.GetPEFParametersRsp
function TGetPEFParametersRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Revision = obj.Revision
    self.Datas = obj.Datas
end

function TGetPEFParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPEFParametersRsp.group)
end

TGetPEFParametersRsp.from_obj = TGetPEFParametersRsp_from_obj

TGetPEFParametersRsp.proto_property = {'CompletionCode', 'Revision', 'Datas'}

TGetPEFParametersRsp.default = {0, 0, ''}

TGetPEFParametersRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Revision', is_array = false, struct = nil},
    {name = 'Datas', is_array = false, struct = nil}
}

function TGetPEFParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Revision', self.Revision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TGetPEFParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPEFParametersRsp.proto_property, errs, need_convert)
    return self
end

function TGetPEFParametersRsp:unpack(_)
    return self.CompletionCode, self.Revision, self.Datas
end

GetPEFParameters.GetPEFParametersRsp = TGetPEFParametersRsp

return GetPEFParameters
