--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPEFCapabilities = {}

---@class SensorIpmiCmds.GetPEFCapabilitiesReq
local TGetPEFCapabilitiesReq = {}
TGetPEFCapabilitiesReq.__index = TGetPEFCapabilitiesReq
TGetPEFCapabilitiesReq.group = {}

local function TGetPEFCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TGetPEFCapabilitiesReq)
end

function TGetPEFCapabilitiesReq.new()
    return TGetPEFCapabilitiesReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetPEFCapabilitiesReq
function TGetPEFCapabilitiesReq:init_from_obj(obj)

end

function TGetPEFCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPEFCapabilitiesReq.group)
end

TGetPEFCapabilitiesReq.from_obj = TGetPEFCapabilitiesReq_from_obj

TGetPEFCapabilitiesReq.proto_property = {}

TGetPEFCapabilitiesReq.default = {}

TGetPEFCapabilitiesReq.struct = {}

function TGetPEFCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetPEFCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPEFCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TGetPEFCapabilitiesReq:unpack(_)
end

GetPEFCapabilities.GetPEFCapabilitiesReq = TGetPEFCapabilitiesReq

---@class SensorIpmiCmds.GetPEFCapabilitiesRsp
---@field CompletionCode integer
---@field PEFVersion integer
---@field Alert integer
---@field PowerDown integer
---@field Reset integer
---@field PowerCycle integer
---@field OEMAction integer
---@field DiagInterrupt integer
---@field Reserved integer
---@field OEMFilterSupport integer
---@field FilterNumber integer
local TGetPEFCapabilitiesRsp = {}
TGetPEFCapabilitiesRsp.__index = TGetPEFCapabilitiesRsp
TGetPEFCapabilitiesRsp.group = {}

local function TGetPEFCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TGetPEFCapabilitiesRsp)
end

function TGetPEFCapabilitiesRsp.new(CompletionCode, PEFVersion, Alert, PowerDown, Reset, PowerCycle, OEMAction,
    DiagInterrupt, Reserved, OEMFilterSupport, FilterNumber)
    return TGetPEFCapabilitiesRsp_from_obj({
        CompletionCode = CompletionCode,
        PEFVersion = PEFVersion,
        Alert = Alert,
        PowerDown = PowerDown,
        Reset = Reset,
        PowerCycle = PowerCycle,
        OEMAction = OEMAction,
        DiagInterrupt = DiagInterrupt,
        Reserved = Reserved,
        OEMFilterSupport = OEMFilterSupport,
        FilterNumber = FilterNumber
    })
end
---@param obj SensorIpmiCmds.GetPEFCapabilitiesRsp
function TGetPEFCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PEFVersion = obj.PEFVersion
    self.Alert = obj.Alert
    self.PowerDown = obj.PowerDown
    self.Reset = obj.Reset
    self.PowerCycle = obj.PowerCycle
    self.OEMAction = obj.OEMAction
    self.DiagInterrupt = obj.DiagInterrupt
    self.Reserved = obj.Reserved
    self.OEMFilterSupport = obj.OEMFilterSupport
    self.FilterNumber = obj.FilterNumber
end

function TGetPEFCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPEFCapabilitiesRsp.group)
end

TGetPEFCapabilitiesRsp.from_obj = TGetPEFCapabilitiesRsp_from_obj

TGetPEFCapabilitiesRsp.proto_property = {
    'CompletionCode', 'PEFVersion', 'Alert', 'PowerDown', 'Reset', 'PowerCycle', 'OEMAction', 'DiagInterrupt',
    'Reserved', 'OEMFilterSupport', 'FilterNumber'
}

TGetPEFCapabilitiesRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetPEFCapabilitiesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PEFVersion', is_array = false, struct = nil},
    {name = 'Alert', is_array = false, struct = nil}, {name = 'PowerDown', is_array = false, struct = nil},
    {name = 'Reset', is_array = false, struct = nil}, {name = 'PowerCycle', is_array = false, struct = nil},
    {name = 'OEMAction', is_array = false, struct = nil}, {name = 'DiagInterrupt', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'OEMFilterSupport', is_array = false, struct = nil},
    {name = 'FilterNumber', is_array = false, struct = nil}
}

function TGetPEFCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PEFVersion', self.PEFVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Alert', self.Alert, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PowerDown', self.PowerDown, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reset', self.Reset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PowerCycle', self.PowerCycle, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OEMAction', self.OEMAction, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DiagInterrupt', self.DiagInterrupt, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OEMFilterSupport', self.OEMFilterSupport, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FilterNumber', self.FilterNumber, 'uint8', false, errs, need_convert)

    TGetPEFCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPEFCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TGetPEFCapabilitiesRsp:unpack(_)
    return self.CompletionCode, self.PEFVersion, self.Alert, self.PowerDown, self.Reset, self.PowerCycle,
        self.OEMAction, self.DiagInterrupt, self.Reserved, self.OEMFilterSupport, self.FilterNumber
end

GetPEFCapabilities.GetPEFCapabilitiesRsp = TGetPEFCapabilitiesRsp

return GetPEFCapabilities
