--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceSDR = {}

---@class SensorIpmiCmds.GetDeviceSDRReq
---@field ReserveIdL integer
---@field ReserveIdH integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Offset integer
---@field Length integer
local TGetDeviceSDRReq = {}
TGetDeviceSDRReq.__index = TGetDeviceSDRReq
TGetDeviceSDRReq.group = {}

local function TGetDeviceSDRReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceSDRReq)
end

function TGetDeviceSDRReq.new(ReserveIdL, ReserveIdH, RecordIdL, RecordIdH, Offset, Length)
    return TGetDeviceSDRReq_from_obj({
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Offset = Offset,
        Length = Length
    })
end
---@param obj SensorIpmiCmds.GetDeviceSDRReq
function TGetDeviceSDRReq:init_from_obj(obj)
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDeviceSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceSDRReq.group)
end

TGetDeviceSDRReq.from_obj = TGetDeviceSDRReq_from_obj

TGetDeviceSDRReq.proto_property = {'ReserveIdL', 'ReserveIdH', 'RecordIdL', 'RecordIdH', 'Offset', 'Length'}

TGetDeviceSDRReq.default = {0, 0, 0, 0, 0, 0}

TGetDeviceSDRReq.struct = {
    {name = 'ReserveIdL', is_array = false, struct = nil}, {name = 'ReserveIdH', is_array = false, struct = nil},
    {name = 'RecordIdL', is_array = false, struct = nil}, {name = 'RecordIdH', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceSDRReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceSDRReq:unpack(_)
    return self.ReserveIdL, self.ReserveIdH, self.RecordIdL, self.RecordIdH, self.Offset, self.Length
end

GetDeviceSDR.GetDeviceSDRReq = TGetDeviceSDRReq

---@class SensorIpmiCmds.GetDeviceSDRRsp
---@field CompletionCode integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Datas string
local TGetDeviceSDRRsp = {}
TGetDeviceSDRRsp.__index = TGetDeviceSDRRsp
TGetDeviceSDRRsp.group = {}

local function TGetDeviceSDRRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceSDRRsp)
end

function TGetDeviceSDRRsp.new(CompletionCode, RecordIdL, RecordIdH, Datas)
    return TGetDeviceSDRRsp_from_obj({
        CompletionCode = CompletionCode,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.GetDeviceSDRRsp
function TGetDeviceSDRRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Datas = obj.Datas
end

function TGetDeviceSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceSDRRsp.group)
end

TGetDeviceSDRRsp.from_obj = TGetDeviceSDRRsp_from_obj

TGetDeviceSDRRsp.proto_property = {'CompletionCode', 'RecordIdL', 'RecordIdH', 'Datas'}

TGetDeviceSDRRsp.default = {0, 0, 0, ''}

TGetDeviceSDRRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RecordIdL', is_array = false, struct = nil},
    {name = 'RecordIdH', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TGetDeviceSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TGetDeviceSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceSDRRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceSDRRsp:unpack(_)
    return self.CompletionCode, self.RecordIdL, self.RecordIdH, self.Datas
end

GetDeviceSDR.GetDeviceSDRRsp = TGetDeviceSDRRsp

return GetDeviceSDR
