--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceLocatorRecordId = {}

---@class SensorIpmiCmds.GetDeviceLocatorRecordIdReq
---@field FruDeviceId integer
local TGetDeviceLocatorRecordIdReq = {}
TGetDeviceLocatorRecordIdReq.__index = TGetDeviceLocatorRecordIdReq
TGetDeviceLocatorRecordIdReq.group = {}

local function TGetDeviceLocatorRecordIdReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceLocatorRecordIdReq)
end

function TGetDeviceLocatorRecordIdReq.new(FruDeviceId)
    return TGetDeviceLocatorRecordIdReq_from_obj({FruDeviceId = FruDeviceId})
end
---@param obj SensorIpmiCmds.GetDeviceLocatorRecordIdReq
function TGetDeviceLocatorRecordIdReq:init_from_obj(obj)
    self.FruDeviceId = obj.FruDeviceId
end

function TGetDeviceLocatorRecordIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceLocatorRecordIdReq.group)
end

TGetDeviceLocatorRecordIdReq.from_obj = TGetDeviceLocatorRecordIdReq_from_obj

TGetDeviceLocatorRecordIdReq.proto_property = {'FruDeviceId'}

TGetDeviceLocatorRecordIdReq.default = {0}

TGetDeviceLocatorRecordIdReq.struct = {{name = 'FruDeviceId', is_array = false, struct = nil}}

function TGetDeviceLocatorRecordIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruDeviceId', self.FruDeviceId, 'uint8', false, errs, need_convert)

    TGetDeviceLocatorRecordIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceLocatorRecordIdReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceLocatorRecordIdReq:unpack(_)
    return self.FruDeviceId
end

GetDeviceLocatorRecordId.GetDeviceLocatorRecordIdReq = TGetDeviceLocatorRecordIdReq

---@class SensorIpmiCmds.GetDeviceLocatorRecordIdRsp
---@field CompletionCode integer
---@field PicmgIdentifier integer
---@field RecordIdLs integer
---@field RecordIdMs integer
local TGetDeviceLocatorRecordIdRsp = {}
TGetDeviceLocatorRecordIdRsp.__index = TGetDeviceLocatorRecordIdRsp
TGetDeviceLocatorRecordIdRsp.group = {}

local function TGetDeviceLocatorRecordIdRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceLocatorRecordIdRsp)
end

function TGetDeviceLocatorRecordIdRsp.new(CompletionCode, PicmgIdentifier, RecordIdLs, RecordIdMs)
    return TGetDeviceLocatorRecordIdRsp_from_obj({
        CompletionCode = CompletionCode,
        PicmgIdentifier = PicmgIdentifier,
        RecordIdLs = RecordIdLs,
        RecordIdMs = RecordIdMs
    })
end
---@param obj SensorIpmiCmds.GetDeviceLocatorRecordIdRsp
function TGetDeviceLocatorRecordIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgIdentifier = obj.PicmgIdentifier
    self.RecordIdLs = obj.RecordIdLs
    self.RecordIdMs = obj.RecordIdMs
end

function TGetDeviceLocatorRecordIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceLocatorRecordIdRsp.group)
end

TGetDeviceLocatorRecordIdRsp.from_obj = TGetDeviceLocatorRecordIdRsp_from_obj

TGetDeviceLocatorRecordIdRsp.proto_property = {'CompletionCode', 'PicmgIdentifier', 'RecordIdLs', 'RecordIdMs'}

TGetDeviceLocatorRecordIdRsp.default = {0, 0, 0, 0}

TGetDeviceLocatorRecordIdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'PicmgIdentifier', is_array = false, struct = nil}, {name = 'RecordIdLs', is_array = false, struct = nil},
    {name = 'RecordIdMs', is_array = false, struct = nil}
}

function TGetDeviceLocatorRecordIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdLs', self.RecordIdLs, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdMs', self.RecordIdMs, 'uint8', false, errs, need_convert)

    TGetDeviceLocatorRecordIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceLocatorRecordIdRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceLocatorRecordIdRsp:unpack(_)
    return self.CompletionCode, self.PicmgIdentifier, self.RecordIdLs, self.RecordIdMs
end

GetDeviceLocatorRecordId.GetDeviceLocatorRecordIdRsp = TGetDeviceLocatorRecordIdRsp

return GetDeviceLocatorRecordId
