--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBMCEnables = {}

---@class SensorIpmiCmds.GetBMCEnablesReq
local TGetBMCEnablesReq = {}
TGetBMCEnablesReq.__index = TGetBMCEnablesReq
TGetBMCEnablesReq.group = {}

local function TGetBMCEnablesReq_from_obj(obj)
    return setmetatable(obj, TGetBMCEnablesReq)
end

function TGetBMCEnablesReq.new()
    return TGetBMCEnablesReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetBMCEnablesReq
function TGetBMCEnablesReq:init_from_obj(obj)

end

function TGetBMCEnablesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBMCEnablesReq.group)
end

TGetBMCEnablesReq.from_obj = TGetBMCEnablesReq_from_obj

TGetBMCEnablesReq.proto_property = {}

TGetBMCEnablesReq.default = {}

TGetBMCEnablesReq.struct = {}

function TGetBMCEnablesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetBMCEnablesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBMCEnablesReq.proto_property, errs, need_convert)
    return self
end

function TGetBMCEnablesReq:unpack(_)
end

GetBMCEnables.GetBMCEnablesReq = TGetBMCEnablesReq

---@class SensorIpmiCmds.GetBMCEnablesRsp
---@field CompletionCode integer
---@field Enable integer
local TGetBMCEnablesRsp = {}
TGetBMCEnablesRsp.__index = TGetBMCEnablesRsp
TGetBMCEnablesRsp.group = {}

local function TGetBMCEnablesRsp_from_obj(obj)
    return setmetatable(obj, TGetBMCEnablesRsp)
end

function TGetBMCEnablesRsp.new(CompletionCode, Enable)
    return TGetBMCEnablesRsp_from_obj({CompletionCode = CompletionCode, Enable = Enable})
end
---@param obj SensorIpmiCmds.GetBMCEnablesRsp
function TGetBMCEnablesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Enable = obj.Enable
end

function TGetBMCEnablesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBMCEnablesRsp.group)
end

TGetBMCEnablesRsp.from_obj = TGetBMCEnablesRsp_from_obj

TGetBMCEnablesRsp.proto_property = {'CompletionCode', 'Enable'}

TGetBMCEnablesRsp.default = {0, 0}

TGetBMCEnablesRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Enable', is_array = false, struct = nil}
}

function TGetBMCEnablesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Enable', self.Enable, 'uint8', false, errs, need_convert)

    TGetBMCEnablesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBMCEnablesRsp.proto_property, errs, need_convert)
    return self
end

function TGetBMCEnablesRsp:unpack(_)
    return self.CompletionCode, self.Enable
end

GetBMCEnables.GetBMCEnablesRsp = TGetBMCEnablesRsp

return GetBMCEnables
