--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ClearSel = {}

---@class SensorIpmiCmds.ClearSelReq
---@field ReserveIdL integer
---@field ReserveIdH integer
---@field FlagC integer
---@field FlagL integer
---@field FlagR integer
---@field Operation integer
local TClearSelReq = {}
TClearSelReq.__index = TClearSelReq
TClearSelReq.group = {}

local function TClearSelReq_from_obj(obj)
    return setmetatable(obj, TClearSelReq)
end

function TClearSelReq.new(ReserveIdL, ReserveIdH, FlagC, FlagL, FlagR, Operation)
    return TClearSelReq_from_obj({
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH,
        FlagC = FlagC,
        FlagL = FlagL,
        FlagR = FlagR,
        Operation = Operation
    })
end
---@param obj SensorIpmiCmds.ClearSelReq
function TClearSelReq:init_from_obj(obj)
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
    self.FlagC = obj.FlagC
    self.FlagL = obj.FlagL
    self.FlagR = obj.FlagR
    self.Operation = obj.Operation
end

function TClearSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearSelReq.group)
end

TClearSelReq.from_obj = TClearSelReq_from_obj

TClearSelReq.proto_property = {'ReserveIdL', 'ReserveIdH', 'FlagC', 'FlagL', 'FlagR', 'Operation'}

TClearSelReq.default = {0, 0, 0, 0, 0, 0}

TClearSelReq.struct = {
    {name = 'ReserveIdL', is_array = false, struct = nil}, {name = 'ReserveIdH', is_array = false, struct = nil},
    {name = 'FlagC', is_array = false, struct = nil}, {name = 'FlagL', is_array = false, struct = nil},
    {name = 'FlagR', is_array = false, struct = nil}, {name = 'Operation', is_array = false, struct = nil}
}

function TClearSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FlagC', self.FlagC, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FlagL', self.FlagL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FlagR', self.FlagR, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Operation', self.Operation, 'uint8', false, errs, need_convert)

    TClearSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearSelReq.proto_property, errs, need_convert)
    return self
end

function TClearSelReq:unpack(_)
    return self.ReserveIdL, self.ReserveIdH, self.FlagC, self.FlagL, self.FlagR, self.Operation
end

ClearSel.ClearSelReq = TClearSelReq

---@class SensorIpmiCmds.ClearSelRsp
---@field CompletionCode integer
---@field Status integer
---@field Reserved integer
local TClearSelRsp = {}
TClearSelRsp.__index = TClearSelRsp
TClearSelRsp.group = {}

local function TClearSelRsp_from_obj(obj)
    return setmetatable(obj, TClearSelRsp)
end

function TClearSelRsp.new(CompletionCode, Status, Reserved)
    return TClearSelRsp_from_obj({CompletionCode = CompletionCode, Status = Status, Reserved = Reserved})
end
---@param obj SensorIpmiCmds.ClearSelRsp
function TClearSelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Status = obj.Status
    self.Reserved = obj.Reserved
end

function TClearSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearSelRsp.group)
end

TClearSelRsp.from_obj = TClearSelRsp_from_obj

TClearSelRsp.proto_property = {'CompletionCode', 'Status', 'Reserved'}

TClearSelRsp.default = {0, 0, 0}

TClearSelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}
}

function TClearSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)

    TClearSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearSelRsp.proto_property, errs, need_convert)
    return self
end

function TClearSelRsp:unpack(_)
    return self.CompletionCode, self.Status, self.Reserved
end

ClearSel.ClearSelRsp = TClearSelRsp

return ClearSel
