--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local AddSelEntry = {}

---@class SensorIpmiCmds.AddSelEntryReq
---@field RecordId integer
---@field SelType integer
---@field Timestamp integer
---@field GeneratorId integer
---@field MsgVersion integer
---@field SensorType integer
---@field SensorNumber integer
---@field EventType integer
---@field EventDir integer
---@field Datas string
local TAddSelEntryReq = {}
TAddSelEntryReq.__index = TAddSelEntryReq
TAddSelEntryReq.group = {}

local function TAddSelEntryReq_from_obj(obj)
    return setmetatable(obj, TAddSelEntryReq)
end

function TAddSelEntryReq.new(RecordId, SelType, Timestamp, GeneratorId, MsgVersion, SensorType, SensorNumber, EventType,
    EventDir, Datas)
    return TAddSelEntryReq_from_obj({
        RecordId = RecordId,
        SelType = SelType,
        Timestamp = Timestamp,
        GeneratorId = GeneratorId,
        MsgVersion = MsgVersion,
        SensorType = SensorType,
        SensorNumber = SensorNumber,
        EventType = EventType,
        EventDir = EventDir,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.AddSelEntryReq
function TAddSelEntryReq:init_from_obj(obj)
    self.RecordId = obj.RecordId
    self.SelType = obj.SelType
    self.Timestamp = obj.Timestamp
    self.GeneratorId = obj.GeneratorId
    self.MsgVersion = obj.MsgVersion
    self.SensorType = obj.SensorType
    self.SensorNumber = obj.SensorNumber
    self.EventType = obj.EventType
    self.EventDir = obj.EventDir
    self.Datas = obj.Datas
end

function TAddSelEntryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddSelEntryReq.group)
end

TAddSelEntryReq.from_obj = TAddSelEntryReq_from_obj

TAddSelEntryReq.proto_property = {
    'RecordId', 'SelType', 'Timestamp', 'GeneratorId', 'MsgVersion', 'SensorType', 'SensorNumber', 'EventType',
    'EventDir', 'Datas'
}

TAddSelEntryReq.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, ''}

TAddSelEntryReq.struct = {
    {name = 'RecordId', is_array = false, struct = nil}, {name = 'SelType', is_array = false, struct = nil},
    {name = 'Timestamp', is_array = false, struct = nil}, {name = 'GeneratorId', is_array = false, struct = nil},
    {name = 'MsgVersion', is_array = false, struct = nil}, {name = 'SensorType', is_array = false, struct = nil},
    {name = 'SensorNumber', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil},
    {name = 'EventDir', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TAddSelEntryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecordId', self.RecordId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'SelType', self.SelType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timestamp', self.Timestamp, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'GeneratorId', self.GeneratorId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'MsgVersion', self.MsgVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TAddSelEntryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddSelEntryReq.proto_property, errs, need_convert)
    return self
end

function TAddSelEntryReq:unpack(_)
    return self.RecordId, self.SelType, self.Timestamp, self.GeneratorId, self.MsgVersion, self.SensorType,
        self.SensorNumber, self.EventType, self.EventDir, self.Datas
end

AddSelEntry.AddSelEntryReq = TAddSelEntryReq

---@class SensorIpmiCmds.AddSelEntryRsp
---@field CompletionCode integer
---@field RecordId integer
local TAddSelEntryRsp = {}
TAddSelEntryRsp.__index = TAddSelEntryRsp
TAddSelEntryRsp.group = {}

local function TAddSelEntryRsp_from_obj(obj)
    return setmetatable(obj, TAddSelEntryRsp)
end

function TAddSelEntryRsp.new(CompletionCode, RecordId)
    return TAddSelEntryRsp_from_obj({CompletionCode = CompletionCode, RecordId = RecordId})
end
---@param obj SensorIpmiCmds.AddSelEntryRsp
function TAddSelEntryRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RecordId = obj.RecordId
end

function TAddSelEntryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddSelEntryRsp.group)
end

TAddSelEntryRsp.from_obj = TAddSelEntryRsp_from_obj

TAddSelEntryRsp.proto_property = {'CompletionCode', 'RecordId'}

TAddSelEntryRsp.default = {0, 0}

TAddSelEntryRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RecordId', is_array = false, struct = nil}
}

function TAddSelEntryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordId', self.RecordId, 'uint16', false, errs, need_convert)

    TAddSelEntryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddSelEntryRsp.proto_property, errs, need_convert)
    return self
end

function TAddSelEntryRsp:unpack(_)
    return self.CompletionCode, self.RecordId
end

AddSelEntry.AddSelEntryRsp = TAddSelEntryRsp

return AddSelEntry
