-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSensorSelInfo = {}

---@class MSensorSelInfo.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 1})
end
---@param obj MSensorSelInfo.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 1
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MSensorSelInfo.Id = TId

---@class MSensorSelInfo.ReceiverAddr
---@field ReceiverAddr integer
local TReceiverAddr = {}
TReceiverAddr.__index = TReceiverAddr
TReceiverAddr.group = {}

local function TReceiverAddr_from_obj(obj)
    return setmetatable(obj, TReceiverAddr)
end

function TReceiverAddr.new(ReceiverAddr)
    return TReceiverAddr_from_obj({ReceiverAddr = ReceiverAddr or 255})
end
---@param obj MSensorSelInfo.ReceiverAddr
function TReceiverAddr:init_from_obj(obj)
    self.ReceiverAddr = obj.ReceiverAddr or 255
end

function TReceiverAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReceiverAddr.group)
end

TReceiverAddr.from_obj = TReceiverAddr_from_obj

TReceiverAddr.proto_property = {'ReceiverAddr'}

TReceiverAddr.default = {0}

TReceiverAddr.struct = {{name = 'ReceiverAddr', is_array = false, struct = nil}}

function TReceiverAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ReceiverAddr', self.ReceiverAddr, 'uint8', false, errs, need_convert)

    TReceiverAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReceiverAddr.proto_property, errs, need_convert)
    return self
end

function TReceiverAddr:unpack(_)
    return self.ReceiverAddr
end

MSensorSelInfo.ReceiverAddr = TReceiverAddr

---@class MSensorSelInfo.DelTimestamp
---@field DelTimestamp integer
local TDelTimestamp = {}
TDelTimestamp.__index = TDelTimestamp
TDelTimestamp.group = {}

local function TDelTimestamp_from_obj(obj)
    return setmetatable(obj, TDelTimestamp)
end

function TDelTimestamp.new(DelTimestamp)
    return TDelTimestamp_from_obj({DelTimestamp = DelTimestamp or 4294967295})
end
---@param obj MSensorSelInfo.DelTimestamp
function TDelTimestamp:init_from_obj(obj)
    self.DelTimestamp = obj.DelTimestamp or 4294967295
end

function TDelTimestamp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDelTimestamp.group)
end

TDelTimestamp.from_obj = TDelTimestamp_from_obj

TDelTimestamp.proto_property = {'DelTimestamp'}

TDelTimestamp.default = {0}

TDelTimestamp.struct = {{name = 'DelTimestamp', is_array = false, struct = nil}}

function TDelTimestamp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'DelTimestamp', self.DelTimestamp, 'uint32', false, errs, need_convert)

    TDelTimestamp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDelTimestamp.proto_property, errs, need_convert)
    return self
end

function TDelTimestamp:unpack(_)
    return self.DelTimestamp
end

MSensorSelInfo.DelTimestamp = TDelTimestamp

---@class MSensorSelInfo.AddTimestamp
---@field AddTimestamp integer
local TAddTimestamp = {}
TAddTimestamp.__index = TAddTimestamp
TAddTimestamp.group = {}

local function TAddTimestamp_from_obj(obj)
    return setmetatable(obj, TAddTimestamp)
end

function TAddTimestamp.new(AddTimestamp)
    return TAddTimestamp_from_obj({AddTimestamp = AddTimestamp or 4294967295})
end
---@param obj MSensorSelInfo.AddTimestamp
function TAddTimestamp:init_from_obj(obj)
    self.AddTimestamp = obj.AddTimestamp or 4294967295
end

function TAddTimestamp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddTimestamp.group)
end

TAddTimestamp.from_obj = TAddTimestamp_from_obj

TAddTimestamp.proto_property = {'AddTimestamp'}

TAddTimestamp.default = {0}

TAddTimestamp.struct = {{name = 'AddTimestamp', is_array = false, struct = nil}}

function TAddTimestamp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'AddTimestamp', self.AddTimestamp, 'uint32', false, errs, need_convert)

    TAddTimestamp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddTimestamp.proto_property, errs, need_convert)
    return self
end

function TAddTimestamp:unpack(_)
    return self.AddTimestamp
end

MSensorSelInfo.AddTimestamp = TAddTimestamp

---@class MSensorSelInfo.QueryMaxCount
---@field QueryMaxCount integer
local TQueryMaxCount = {}
TQueryMaxCount.__index = TQueryMaxCount
TQueryMaxCount.group = {}

local function TQueryMaxCount_from_obj(obj)
    return setmetatable(obj, TQueryMaxCount)
end

function TQueryMaxCount.new(QueryMaxCount)
    return TQueryMaxCount_from_obj({QueryMaxCount = QueryMaxCount or 2000})
end
---@param obj MSensorSelInfo.QueryMaxCount
function TQueryMaxCount:init_from_obj(obj)
    self.QueryMaxCount = obj.QueryMaxCount or 2000
end

function TQueryMaxCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQueryMaxCount.group)
end

TQueryMaxCount.from_obj = TQueryMaxCount_from_obj

TQueryMaxCount.proto_property = {'QueryMaxCount'}

TQueryMaxCount.default = {0}

TQueryMaxCount.struct = {{name = 'QueryMaxCount', is_array = false, struct = nil}}

function TQueryMaxCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'QueryMaxCount', self.QueryMaxCount, 'uint16', false, errs, need_convert)

    TQueryMaxCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQueryMaxCount.proto_property, errs, need_convert)
    return self
end

function TQueryMaxCount:unpack(_)
    return self.QueryMaxCount
end

MSensorSelInfo.QueryMaxCount = TQueryMaxCount

---@class MSensorSelInfo.CurRecordId
---@field CurRecordId integer
local TCurRecordId = {}
TCurRecordId.__index = TCurRecordId
TCurRecordId.group = {}

local function TCurRecordId_from_obj(obj)
    return setmetatable(obj, TCurRecordId)
end

function TCurRecordId.new(CurRecordId)
    return TCurRecordId_from_obj({CurRecordId = CurRecordId or 0})
end
---@param obj MSensorSelInfo.CurRecordId
function TCurRecordId:init_from_obj(obj)
    self.CurRecordId = obj.CurRecordId or 0
end

function TCurRecordId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurRecordId.group)
end

TCurRecordId.from_obj = TCurRecordId_from_obj

TCurRecordId.proto_property = {'CurRecordId'}

TCurRecordId.default = {0}

TCurRecordId.struct = {{name = 'CurRecordId', is_array = false, struct = nil}}

function TCurRecordId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'CurRecordId', self.CurRecordId, 'uint16', false, errs, need_convert)

    TCurRecordId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurRecordId.proto_property, errs, need_convert)
    return self
end

function TCurRecordId:unpack(_)
    return self.CurRecordId
end

MSensorSelInfo.CurRecordId = TCurRecordId

return MSensorSelInfo
