-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSelMsgList = {}

---@class MSelMsgList.Level
---@field Level integer
local TLevel = {}
TLevel.__index = TLevel
TLevel.group = {}

local function TLevel_from_obj(obj)
    return setmetatable(obj, TLevel)
end

function TLevel.new(Level)
    return TLevel_from_obj({Level = Level})
end
---@param obj MSelMsgList.Level
function TLevel:init_from_obj(obj)
    self.Level = obj.Level
end

function TLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLevel.group)
end

TLevel.from_obj = TLevel_from_obj

TLevel.proto_property = {'Level'}

TLevel.default = {0}

TLevel.struct = {{name = 'Level', is_array = false, struct = nil}}

function TLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs, need_convert)

    TLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLevel.proto_property, errs, need_convert)
    return self
end

function TLevel:unpack(_)
    return self.Level
end

MSelMsgList.Level = TLevel

---@class MSelMsgList.EventData3
---@field EventData3 integer
local TEventData3 = {}
TEventData3.__index = TEventData3
TEventData3.group = {}

local function TEventData3_from_obj(obj)
    return setmetatable(obj, TEventData3)
end

function TEventData3.new(EventData3)
    return TEventData3_from_obj({EventData3 = EventData3})
end
---@param obj MSelMsgList.EventData3
function TEventData3:init_from_obj(obj)
    self.EventData3 = obj.EventData3
end

function TEventData3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData3.group)
end

TEventData3.from_obj = TEventData3_from_obj

TEventData3.proto_property = {'EventData3'}

TEventData3.default = {0}

TEventData3.struct = {{name = 'EventData3', is_array = false, struct = nil}}

function TEventData3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'EventData3', self.EventData3, 'uint8', false, errs, need_convert)

    TEventData3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData3.proto_property, errs, need_convert)
    return self
end

function TEventData3:unpack(_)
    return self.EventData3
end

MSelMsgList.EventData3 = TEventData3

---@class MSelMsgList.EventData2
---@field EventData2 integer
local TEventData2 = {}
TEventData2.__index = TEventData2
TEventData2.group = {}

local function TEventData2_from_obj(obj)
    return setmetatable(obj, TEventData2)
end

function TEventData2.new(EventData2)
    return TEventData2_from_obj({EventData2 = EventData2})
end
---@param obj MSelMsgList.EventData2
function TEventData2:init_from_obj(obj)
    self.EventData2 = obj.EventData2
end

function TEventData2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData2.group)
end

TEventData2.from_obj = TEventData2_from_obj

TEventData2.proto_property = {'EventData2'}

TEventData2.default = {0}

TEventData2.struct = {{name = 'EventData2', is_array = false, struct = nil}}

function TEventData2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'EventData2', self.EventData2, 'uint8', false, errs, need_convert)

    TEventData2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData2.proto_property, errs, need_convert)
    return self
end

function TEventData2:unpack(_)
    return self.EventData2
end

MSelMsgList.EventData2 = TEventData2

---@class MSelMsgList.EventData1
---@field EventData1 integer
local TEventData1 = {}
TEventData1.__index = TEventData1
TEventData1.group = {}

local function TEventData1_from_obj(obj)
    return setmetatable(obj, TEventData1)
end

function TEventData1.new(EventData1)
    return TEventData1_from_obj({EventData1 = EventData1})
end
---@param obj MSelMsgList.EventData1
function TEventData1:init_from_obj(obj)
    self.EventData1 = obj.EventData1
end

function TEventData1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData1.group)
end

TEventData1.from_obj = TEventData1_from_obj

TEventData1.proto_property = {'EventData1'}

TEventData1.default = {0}

TEventData1.struct = {{name = 'EventData1', is_array = false, struct = nil}}

function TEventData1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'EventData1', self.EventData1, 'uint8', false, errs, need_convert)

    TEventData1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData1.proto_property, errs, need_convert)
    return self
end

function TEventData1:unpack(_)
    return self.EventData1
end

MSelMsgList.EventData1 = TEventData1

---@class MSelMsgList.EventDir
---@field EventDir integer
local TEventDir = {}
TEventDir.__index = TEventDir
TEventDir.group = {}

local function TEventDir_from_obj(obj)
    return setmetatable(obj, TEventDir)
end

function TEventDir.new(EventDir)
    return TEventDir_from_obj({EventDir = EventDir})
end
---@param obj MSelMsgList.EventDir
function TEventDir:init_from_obj(obj)
    self.EventDir = obj.EventDir
end

function TEventDir:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventDir.group)
end

TEventDir.from_obj = TEventDir_from_obj

TEventDir.proto_property = {'EventDir'}

TEventDir.default = {0}

TEventDir.struct = {{name = 'EventDir', is_array = false, struct = nil}}

function TEventDir:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', false, errs, need_convert)

    TEventDir:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventDir.proto_property, errs, need_convert)
    return self
end

function TEventDir:unpack(_)
    return self.EventDir
end

MSelMsgList.EventDir = TEventDir

---@class MSelMsgList.EventType
---@field EventType integer
local TEventType = {}
TEventType.__index = TEventType
TEventType.group = {}

local function TEventType_from_obj(obj)
    return setmetatable(obj, TEventType)
end

function TEventType.new(EventType)
    return TEventType_from_obj({EventType = EventType})
end
---@param obj MSelMsgList.EventType
function TEventType:init_from_obj(obj)
    self.EventType = obj.EventType
end

function TEventType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventType.group)
end

TEventType.from_obj = TEventType_from_obj

TEventType.proto_property = {'EventType'}

TEventType.default = {0}

TEventType.struct = {{name = 'EventType', is_array = false, struct = nil}}

function TEventType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)

    TEventType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventType.proto_property, errs, need_convert)
    return self
end

function TEventType:unpack(_)
    return self.EventType
end

MSelMsgList.EventType = TEventType

---@class MSelMsgList.SensorNumber
---@field SensorNumber integer
local TSensorNumber = {}
TSensorNumber.__index = TSensorNumber
TSensorNumber.group = {}

local function TSensorNumber_from_obj(obj)
    return setmetatable(obj, TSensorNumber)
end

function TSensorNumber.new(SensorNumber)
    return TSensorNumber_from_obj({SensorNumber = SensorNumber})
end
---@param obj MSelMsgList.SensorNumber
function TSensorNumber:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber
end

function TSensorNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorNumber.group)
end

TSensorNumber.from_obj = TSensorNumber_from_obj

TSensorNumber.proto_property = {'SensorNumber'}

TSensorNumber.default = {0}

TSensorNumber.struct = {{name = 'SensorNumber', is_array = false, struct = nil}}

function TSensorNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint8', false, errs, need_convert)

    TSensorNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorNumber.proto_property, errs, need_convert)
    return self
end

function TSensorNumber:unpack(_)
    return self.SensorNumber
end

MSelMsgList.SensorNumber = TSensorNumber

---@class MSelMsgList.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType})
end
---@param obj MSelMsgList.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

MSelMsgList.SensorType = TSensorType

---@class MSelMsgList.EventMsgVersion
---@field EventMsgVersion integer
local TEventMsgVersion = {}
TEventMsgVersion.__index = TEventMsgVersion
TEventMsgVersion.group = {}

local function TEventMsgVersion_from_obj(obj)
    return setmetatable(obj, TEventMsgVersion)
end

function TEventMsgVersion.new(EventMsgVersion)
    return TEventMsgVersion_from_obj({EventMsgVersion = EventMsgVersion})
end
---@param obj MSelMsgList.EventMsgVersion
function TEventMsgVersion:init_from_obj(obj)
    self.EventMsgVersion = obj.EventMsgVersion
end

function TEventMsgVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventMsgVersion.group)
end

TEventMsgVersion.from_obj = TEventMsgVersion_from_obj

TEventMsgVersion.proto_property = {'EventMsgVersion'}

TEventMsgVersion.default = {0}

TEventMsgVersion.struct = {{name = 'EventMsgVersion', is_array = false, struct = nil}}

function TEventMsgVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventMsgVersion', self.EventMsgVersion, 'uint8', false, errs, need_convert)

    TEventMsgVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventMsgVersion.proto_property, errs, need_convert)
    return self
end

function TEventMsgVersion:unpack(_)
    return self.EventMsgVersion
end

MSelMsgList.EventMsgVersion = TEventMsgVersion

---@class MSelMsgList.SensorId
---@field SensorId string
local TSensorId = {}
TSensorId.__index = TSensorId
TSensorId.group = {}

local function TSensorId_from_obj(obj)
    return setmetatable(obj, TSensorId)
end

function TSensorId.new(SensorId)
    return TSensorId_from_obj({SensorId = SensorId})
end
---@param obj MSelMsgList.SensorId
function TSensorId:init_from_obj(obj)
    self.SensorId = obj.SensorId
end

function TSensorId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorId.group)
end

TSensorId.from_obj = TSensorId_from_obj

TSensorId.proto_property = {'SensorId'}

TSensorId.default = {''}

TSensorId.struct = {{name = 'SensorId', is_array = false, struct = nil}}

function TSensorId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SensorId', self.SensorId, 'string', false, errs, need_convert)

    TSensorId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorId.proto_property, errs, need_convert)
    return self
end

function TSensorId:unpack(_)
    return self.SensorId
end

MSelMsgList.SensorId = TSensorId

return MSelMsgList
