-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiSelList = {}

---@class MIpmiSelList.RecordSeq
---@field RecordSeq integer
local TRecordSeq = {}
TRecordSeq.__index = TRecordSeq
TRecordSeq.group = {}

local function TRecordSeq_from_obj(obj)
    return setmetatable(obj, TRecordSeq)
end

function TRecordSeq.new(RecordSeq)
    return TRecordSeq_from_obj({RecordSeq = RecordSeq})
end
---@param obj MIpmiSelList.RecordSeq
function TRecordSeq:init_from_obj(obj)
    self.RecordSeq = obj.RecordSeq
end

function TRecordSeq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecordSeq.group)
end

TRecordSeq.from_obj = TRecordSeq_from_obj

TRecordSeq.proto_property = {'RecordSeq'}

TRecordSeq.default = {0}

TRecordSeq.struct = {{name = 'RecordSeq', is_array = false, struct = nil}}

function TRecordSeq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecordSeq', self.RecordSeq, 'uint64', false, errs, need_convert)

    TRecordSeq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecordSeq.proto_property, errs, need_convert)
    return self
end

function TRecordSeq:unpack(_)
    return self.RecordSeq
end

MIpmiSelList.RecordSeq = TRecordSeq

---@class MIpmiSelList.SubjectName
---@field SubjectName string
local TSubjectName = {}
TSubjectName.__index = TSubjectName
TSubjectName.group = {}

local function TSubjectName_from_obj(obj)
    return setmetatable(obj, TSubjectName)
end

function TSubjectName.new(SubjectName)
    return TSubjectName_from_obj({SubjectName = SubjectName})
end
---@param obj MIpmiSelList.SubjectName
function TSubjectName:init_from_obj(obj)
    self.SubjectName = obj.SubjectName
end

function TSubjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubjectName.group)
end

TSubjectName.from_obj = TSubjectName_from_obj

TSubjectName.proto_property = {'SubjectName'}

TSubjectName.default = {''}

TSubjectName.struct = {{name = 'SubjectName', is_array = false, struct = nil}}

function TSubjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubjectName', self.SubjectName, 'string', false, errs, need_convert)

    TSubjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubjectName.proto_property, errs, need_convert)
    return self
end

function TSubjectName:unpack(_)
    return self.SubjectName
end

MIpmiSelList.SubjectName = TSubjectName

---@class MIpmiSelList.SensorName
---@field SensorName string
local TSensorName = {}
TSensorName.__index = TSensorName
TSensorName.group = {}

local function TSensorName_from_obj(obj)
    return setmetatable(obj, TSensorName)
end

function TSensorName.new(SensorName)
    return TSensorName_from_obj({SensorName = SensorName})
end
---@param obj MIpmiSelList.SensorName
function TSensorName:init_from_obj(obj)
    self.SensorName = obj.SensorName
end

function TSensorName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorName.group)
end

TSensorName.from_obj = TSensorName_from_obj

TSensorName.proto_property = {'SensorName'}

TSensorName.default = {''}

TSensorName.struct = {{name = 'SensorName', is_array = false, struct = nil}}

function TSensorName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', false, errs, need_convert)

    TSensorName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorName.proto_property, errs, need_convert)
    return self
end

function TSensorName:unpack(_)
    return self.SensorName
end

MIpmiSelList.SensorName = TSensorName

---@class MIpmiSelList.SensorId
---@field SensorId string
local TSensorId = {}
TSensorId.__index = TSensorId
TSensorId.group = {}

local function TSensorId_from_obj(obj)
    return setmetatable(obj, TSensorId)
end

function TSensorId.new(SensorId)
    return TSensorId_from_obj({SensorId = SensorId})
end
---@param obj MIpmiSelList.SensorId
function TSensorId:init_from_obj(obj)
    self.SensorId = obj.SensorId
end

function TSensorId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorId.group)
end

TSensorId.from_obj = TSensorId_from_obj

TSensorId.proto_property = {'SensorId'}

TSensorId.default = {''}

TSensorId.struct = {{name = 'SensorId', is_array = false, struct = nil}}

function TSensorId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorId', self.SensorId, 'string', false, errs, need_convert)

    TSensorId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorId.proto_property, errs, need_convert)
    return self
end

function TSensorId:unpack(_)
    return self.SensorId
end

MIpmiSelList.SensorId = TSensorId

---@class MIpmiSelList.SelData3
---@field SelData3 integer
local TSelData3 = {}
TSelData3.__index = TSelData3
TSelData3.group = {}

local function TSelData3_from_obj(obj)
    return setmetatable(obj, TSelData3)
end

function TSelData3.new(SelData3)
    return TSelData3_from_obj({SelData3 = SelData3})
end
---@param obj MIpmiSelList.SelData3
function TSelData3:init_from_obj(obj)
    self.SelData3 = obj.SelData3
end

function TSelData3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelData3.group)
end

TSelData3.from_obj = TSelData3_from_obj

TSelData3.proto_property = {'SelData3'}

TSelData3.default = {0}

TSelData3.struct = {{name = 'SelData3', is_array = false, struct = nil}}

function TSelData3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelData3', self.SelData3, 'uint8', false, errs, need_convert)

    TSelData3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelData3.proto_property, errs, need_convert)
    return self
end

function TSelData3:unpack(_)
    return self.SelData3
end

MIpmiSelList.SelData3 = TSelData3

---@class MIpmiSelList.SelData2
---@field SelData2 integer
local TSelData2 = {}
TSelData2.__index = TSelData2
TSelData2.group = {}

local function TSelData2_from_obj(obj)
    return setmetatable(obj, TSelData2)
end

function TSelData2.new(SelData2)
    return TSelData2_from_obj({SelData2 = SelData2})
end
---@param obj MIpmiSelList.SelData2
function TSelData2:init_from_obj(obj)
    self.SelData2 = obj.SelData2
end

function TSelData2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelData2.group)
end

TSelData2.from_obj = TSelData2_from_obj

TSelData2.proto_property = {'SelData2'}

TSelData2.default = {0}

TSelData2.struct = {{name = 'SelData2', is_array = false, struct = nil}}

function TSelData2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelData2', self.SelData2, 'uint8', false, errs, need_convert)

    TSelData2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelData2.proto_property, errs, need_convert)
    return self
end

function TSelData2:unpack(_)
    return self.SelData2
end

MIpmiSelList.SelData2 = TSelData2

---@class MIpmiSelList.SelData1
---@field SelData1 integer
local TSelData1 = {}
TSelData1.__index = TSelData1
TSelData1.group = {}

local function TSelData1_from_obj(obj)
    return setmetatable(obj, TSelData1)
end

function TSelData1.new(SelData1)
    return TSelData1_from_obj({SelData1 = SelData1})
end
---@param obj MIpmiSelList.SelData1
function TSelData1:init_from_obj(obj)
    self.SelData1 = obj.SelData1
end

function TSelData1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelData1.group)
end

TSelData1.from_obj = TSelData1_from_obj

TSelData1.proto_property = {'SelData1'}

TSelData1.default = {0}

TSelData1.struct = {{name = 'SelData1', is_array = false, struct = nil}}

function TSelData1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelData1', self.SelData1, 'uint8', false, errs, need_convert)

    TSelData1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelData1.proto_property, errs, need_convert)
    return self
end

function TSelData1:unpack(_)
    return self.SelData1
end

MIpmiSelList.SelData1 = TSelData1

---@class MIpmiSelList.SelEventType
---@field SelEventType integer
local TSelEventType = {}
TSelEventType.__index = TSelEventType
TSelEventType.group = {}

local function TSelEventType_from_obj(obj)
    return setmetatable(obj, TSelEventType)
end

function TSelEventType.new(SelEventType)
    return TSelEventType_from_obj({SelEventType = SelEventType})
end
---@param obj MIpmiSelList.SelEventType
function TSelEventType:init_from_obj(obj)
    self.SelEventType = obj.SelEventType
end

function TSelEventType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelEventType.group)
end

TSelEventType.from_obj = TSelEventType_from_obj

TSelEventType.proto_property = {'SelEventType'}

TSelEventType.default = {0}

TSelEventType.struct = {{name = 'SelEventType', is_array = false, struct = nil}}

function TSelEventType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelEventType', self.SelEventType, 'uint8', false, errs, need_convert)

    TSelEventType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelEventType.proto_property, errs, need_convert)
    return self
end

function TSelEventType:unpack(_)
    return self.SelEventType
end

MIpmiSelList.SelEventType = TSelEventType

---@class MIpmiSelList.SensorNumber
---@field SensorNumber integer
local TSensorNumber = {}
TSensorNumber.__index = TSensorNumber
TSensorNumber.group = {}

local function TSensorNumber_from_obj(obj)
    return setmetatable(obj, TSensorNumber)
end

function TSensorNumber.new(SensorNumber)
    return TSensorNumber_from_obj({SensorNumber = SensorNumber})
end
---@param obj MIpmiSelList.SensorNumber
function TSensorNumber:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber
end

function TSensorNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorNumber.group)
end

TSensorNumber.from_obj = TSensorNumber_from_obj

TSensorNumber.proto_property = {'SensorNumber'}

TSensorNumber.default = {0}

TSensorNumber.struct = {{name = 'SensorNumber', is_array = false, struct = nil}}

function TSensorNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint8', false, errs, need_convert)

    TSensorNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorNumber.proto_property, errs, need_convert)
    return self
end

function TSensorNumber:unpack(_)
    return self.SensorNumber
end

MIpmiSelList.SensorNumber = TSensorNumber

---@class MIpmiSelList.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType})
end
---@param obj MIpmiSelList.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

MIpmiSelList.SensorType = TSensorType

---@class MIpmiSelList.SelMsgVersion
---@field SelMsgVersion integer
local TSelMsgVersion = {}
TSelMsgVersion.__index = TSelMsgVersion
TSelMsgVersion.group = {}

local function TSelMsgVersion_from_obj(obj)
    return setmetatable(obj, TSelMsgVersion)
end

function TSelMsgVersion.new(SelMsgVersion)
    return TSelMsgVersion_from_obj({SelMsgVersion = SelMsgVersion})
end
---@param obj MIpmiSelList.SelMsgVersion
function TSelMsgVersion:init_from_obj(obj)
    self.SelMsgVersion = obj.SelMsgVersion
end

function TSelMsgVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelMsgVersion.group)
end

TSelMsgVersion.from_obj = TSelMsgVersion_from_obj

TSelMsgVersion.proto_property = {'SelMsgVersion'}

TSelMsgVersion.default = {0}

TSelMsgVersion.struct = {{name = 'SelMsgVersion', is_array = false, struct = nil}}

function TSelMsgVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelMsgVersion', self.SelMsgVersion, 'uint8', false, errs, need_convert)

    TSelMsgVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelMsgVersion.proto_property, errs, need_convert)
    return self
end

function TSelMsgVersion:unpack(_)
    return self.SelMsgVersion
end

MIpmiSelList.SelMsgVersion = TSelMsgVersion

---@class MIpmiSelList.GenerateId
---@field GenerateId integer
local TGenerateId = {}
TGenerateId.__index = TGenerateId
TGenerateId.group = {}

local function TGenerateId_from_obj(obj)
    return setmetatable(obj, TGenerateId)
end

function TGenerateId.new(GenerateId)
    return TGenerateId_from_obj({GenerateId = GenerateId})
end
---@param obj MIpmiSelList.GenerateId
function TGenerateId:init_from_obj(obj)
    self.GenerateId = obj.GenerateId
end

function TGenerateId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenerateId.group)
end

TGenerateId.from_obj = TGenerateId_from_obj

TGenerateId.proto_property = {'GenerateId'}

TGenerateId.default = {0}

TGenerateId.struct = {{name = 'GenerateId', is_array = false, struct = nil}}

function TGenerateId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GenerateId', self.GenerateId, 'uint16', false, errs, need_convert)

    TGenerateId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenerateId.proto_property, errs, need_convert)
    return self
end

function TGenerateId:unpack(_)
    return self.GenerateId
end

MIpmiSelList.GenerateId = TGenerateId

---@class MIpmiSelList.Timestamp
---@field Timestamp integer
local TTimestamp = {}
TTimestamp.__index = TTimestamp
TTimestamp.group = {}

local function TTimestamp_from_obj(obj)
    return setmetatable(obj, TTimestamp)
end

function TTimestamp.new(Timestamp)
    return TTimestamp_from_obj({Timestamp = Timestamp})
end
---@param obj MIpmiSelList.Timestamp
function TTimestamp:init_from_obj(obj)
    self.Timestamp = obj.Timestamp
end

function TTimestamp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimestamp.group)
end

TTimestamp.from_obj = TTimestamp_from_obj

TTimestamp.proto_property = {'Timestamp'}

TTimestamp.default = {0}

TTimestamp.struct = {{name = 'Timestamp', is_array = false, struct = nil}}

function TTimestamp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Timestamp', self.Timestamp, 'uint32', false, errs, need_convert)

    TTimestamp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimestamp.proto_property, errs, need_convert)
    return self
end

function TTimestamp:unpack(_)
    return self.Timestamp
end

MIpmiSelList.Timestamp = TTimestamp

---@class MIpmiSelList.SelType
---@field SelType integer
local TSelType = {}
TSelType.__index = TSelType
TSelType.group = {}

local function TSelType_from_obj(obj)
    return setmetatable(obj, TSelType)
end

function TSelType.new(SelType)
    return TSelType_from_obj({SelType = SelType})
end
---@param obj MIpmiSelList.SelType
function TSelType:init_from_obj(obj)
    self.SelType = obj.SelType
end

function TSelType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelType.group)
end

TSelType.from_obj = TSelType_from_obj

TSelType.proto_property = {'SelType'}

TSelType.default = {0}

TSelType.struct = {{name = 'SelType', is_array = false, struct = nil}}

function TSelType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SelType', self.SelType, 'uint8', false, errs, need_convert)

    TSelType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelType.proto_property, errs, need_convert)
    return self
end

function TSelType:unpack(_)
    return self.SelType
end

MIpmiSelList.SelType = TSelType

---@class MIpmiSelList.RecordId
---@field RecordId integer
local TRecordId = {}
TRecordId.__index = TRecordId
TRecordId.group = {}

local function TRecordId_from_obj(obj)
    return setmetatable(obj, TRecordId)
end

function TRecordId.new(RecordId)
    return TRecordId_from_obj({RecordId = RecordId})
end
---@param obj MIpmiSelList.RecordId
function TRecordId:init_from_obj(obj)
    self.RecordId = obj.RecordId
end

function TRecordId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecordId.group)
end

TRecordId.from_obj = TRecordId_from_obj

TRecordId.proto_property = {'RecordId'}

TRecordId.default = {0}

TRecordId.struct = {{name = 'RecordId', is_array = false, struct = nil}}

function TRecordId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'RecordId', self.RecordId, 'uint16', false, errs, need_convert)

    TRecordId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecordId.proto_property, errs, need_convert)
    return self
end

function TRecordId:unpack(_)
    return self.RecordId
end

MIpmiSelList.RecordId = TRecordId

return MIpmiSelList
