-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiSelFilter = {}

---@class MIpmiSelFilter.FilterMask3
---@field FilterMask3 integer
local TFilterMask3 = {}
TFilterMask3.__index = TFilterMask3
TFilterMask3.group = {}

local function TFilterMask3_from_obj(obj)
    return setmetatable(obj, TFilterMask3)
end

function TFilterMask3.new(FilterMask3)
    return TFilterMask3_from_obj({FilterMask3 = FilterMask3 or 65535})
end
---@param obj MIpmiSelFilter.FilterMask3
function TFilterMask3:init_from_obj(obj)
    self.FilterMask3 = obj.FilterMask3 or 65535
end

function TFilterMask3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFilterMask3.group)
end

TFilterMask3.from_obj = TFilterMask3_from_obj

TFilterMask3.proto_property = {'FilterMask3'}

TFilterMask3.default = {0}

TFilterMask3.struct = {{name = 'FilterMask3', is_array = false, struct = nil}}

function TFilterMask3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilterMask3', self.FilterMask3, 'uint16', false, errs, need_convert)

    TFilterMask3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFilterMask3.proto_property, errs, need_convert)
    return self
end

function TFilterMask3:unpack(_)
    return self.FilterMask3
end

MIpmiSelFilter.FilterMask3 = TFilterMask3

---@class MIpmiSelFilter.FilterMask2
---@field FilterMask2 integer
local TFilterMask2 = {}
TFilterMask2.__index = TFilterMask2
TFilterMask2.group = {}

local function TFilterMask2_from_obj(obj)
    return setmetatable(obj, TFilterMask2)
end

function TFilterMask2.new(FilterMask2)
    return TFilterMask2_from_obj({FilterMask2 = FilterMask2 or 65535})
end
---@param obj MIpmiSelFilter.FilterMask2
function TFilterMask2:init_from_obj(obj)
    self.FilterMask2 = obj.FilterMask2 or 65535
end

function TFilterMask2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFilterMask2.group)
end

TFilterMask2.from_obj = TFilterMask2_from_obj

TFilterMask2.proto_property = {'FilterMask2'}

TFilterMask2.default = {0}

TFilterMask2.struct = {{name = 'FilterMask2', is_array = false, struct = nil}}

function TFilterMask2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilterMask2', self.FilterMask2, 'uint16', false, errs, need_convert)

    TFilterMask2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFilterMask2.proto_property, errs, need_convert)
    return self
end

function TFilterMask2:unpack(_)
    return self.FilterMask2
end

MIpmiSelFilter.FilterMask2 = TFilterMask2

---@class MIpmiSelFilter.FilterMask1
---@field FilterMask1 integer
local TFilterMask1 = {}
TFilterMask1.__index = TFilterMask1
TFilterMask1.group = {}

local function TFilterMask1_from_obj(obj)
    return setmetatable(obj, TFilterMask1)
end

function TFilterMask1.new(FilterMask1)
    return TFilterMask1_from_obj({FilterMask1 = FilterMask1 or 65535})
end
---@param obj MIpmiSelFilter.FilterMask1
function TFilterMask1:init_from_obj(obj)
    self.FilterMask1 = obj.FilterMask1 or 65535
end

function TFilterMask1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFilterMask1.group)
end

TFilterMask1.from_obj = TFilterMask1_from_obj

TFilterMask1.proto_property = {'FilterMask1'}

TFilterMask1.default = {0}

TFilterMask1.struct = {{name = 'FilterMask1', is_array = false, struct = nil}}

function TFilterMask1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FilterMask1', self.FilterMask1, 'uint16', false, errs, need_convert)

    TFilterMask1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFilterMask1.proto_property, errs, need_convert)
    return self
end

function TFilterMask1:unpack(_)
    return self.FilterMask1
end

MIpmiSelFilter.FilterMask1 = TFilterMask1

---@class MIpmiSelFilter.ReadingType
---@field ReadingType integer
local TReadingType = {}
TReadingType.__index = TReadingType
TReadingType.group = {}

local function TReadingType_from_obj(obj)
    return setmetatable(obj, TReadingType)
end

function TReadingType.new(ReadingType)
    return TReadingType_from_obj({ReadingType = ReadingType})
end
---@param obj MIpmiSelFilter.ReadingType
function TReadingType:init_from_obj(obj)
    self.ReadingType = obj.ReadingType
end

function TReadingType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingType.group)
end

TReadingType.from_obj = TReadingType_from_obj

TReadingType.proto_property = {'ReadingType'}

TReadingType.default = {0}

TReadingType.struct = {{name = 'ReadingType', is_array = false, struct = nil}}

function TReadingType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ReadingType', self.ReadingType, 'uint8', false, errs, need_convert)

    TReadingType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingType.proto_property, errs, need_convert)
    return self
end

function TReadingType:unpack(_)
    return self.ReadingType
end

MIpmiSelFilter.ReadingType = TReadingType

---@class MIpmiSelFilter.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType})
end
---@param obj MIpmiSelFilter.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

MIpmiSelFilter.SensorType = TSensorType

return MIpmiSelFilter
