-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiSelDesc = {}

---@class MIpmiSelDesc.ShieldFlag
---@field ShieldFlag integer
local TShieldFlag = {}
TShieldFlag.__index = TShieldFlag
TShieldFlag.group = {}

local function TShieldFlag_from_obj(obj)
    return setmetatable(obj, TShieldFlag)
end

function TShieldFlag.new(ShieldFlag)
    return TShieldFlag_from_obj({ShieldFlag = ShieldFlag or 0})
end
---@param obj MIpmiSelDesc.ShieldFlag
function TShieldFlag:init_from_obj(obj)
    self.ShieldFlag = obj.ShieldFlag or 0
end

function TShieldFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShieldFlag.group)
end

TShieldFlag.from_obj = TShieldFlag_from_obj

TShieldFlag.proto_property = {'ShieldFlag'}

TShieldFlag.default = {0}

TShieldFlag.struct = {{name = 'ShieldFlag', is_array = false, struct = nil}}

function TShieldFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ShieldFlag', self.ShieldFlag, 'uint8', false, errs, need_convert)

    TShieldFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShieldFlag.proto_property, errs, need_convert)
    return self
end

function TShieldFlag:unpack(_)
    return self.ShieldFlag
end

MIpmiSelDesc.ShieldFlag = TShieldFlag

---@class MIpmiSelDesc.SelData3
---@field SelData3 integer
local TSelData3 = {}
TSelData3.__index = TSelData3
TSelData3.group = {}

local function TSelData3_from_obj(obj)
    return setmetatable(obj, TSelData3)
end

function TSelData3.new(SelData3)
    return TSelData3_from_obj({SelData3 = SelData3 or 255})
end
---@param obj MIpmiSelDesc.SelData3
function TSelData3:init_from_obj(obj)
    self.SelData3 = obj.SelData3 or 255
end

function TSelData3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelData3.group)
end

TSelData3.from_obj = TSelData3_from_obj

TSelData3.proto_property = {'SelData3'}

TSelData3.default = {0}

TSelData3.struct = {{name = 'SelData3', is_array = false, struct = nil}}

function TSelData3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SelData3', self.SelData3, 'uint8', false, errs, need_convert)

    TSelData3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelData3.proto_property, errs, need_convert)
    return self
end

function TSelData3:unpack(_)
    return self.SelData3
end

MIpmiSelDesc.SelData3 = TSelData3

---@class MIpmiSelDesc.SelData2
---@field SelData2 integer
local TSelData2 = {}
TSelData2.__index = TSelData2
TSelData2.group = {}

local function TSelData2_from_obj(obj)
    return setmetatable(obj, TSelData2)
end

function TSelData2.new(SelData2)
    return TSelData2_from_obj({SelData2 = SelData2 or 255})
end
---@param obj MIpmiSelDesc.SelData2
function TSelData2:init_from_obj(obj)
    self.SelData2 = obj.SelData2 or 255
end

function TSelData2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelData2.group)
end

TSelData2.from_obj = TSelData2_from_obj

TSelData2.proto_property = {'SelData2'}

TSelData2.default = {0}

TSelData2.struct = {{name = 'SelData2', is_array = false, struct = nil}}

function TSelData2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SelData2', self.SelData2, 'uint8', false, errs, need_convert)

    TSelData2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelData2.proto_property, errs, need_convert)
    return self
end

function TSelData2:unpack(_)
    return self.SelData2
end

MIpmiSelDesc.SelData2 = TSelData2

---@class MIpmiSelDesc.SelData1
---@field SelData1 integer
local TSelData1 = {}
TSelData1.__index = TSelData1
TSelData1.group = {}

local function TSelData1_from_obj(obj)
    return setmetatable(obj, TSelData1)
end

function TSelData1.new(SelData1)
    return TSelData1_from_obj({SelData1 = SelData1 or 255})
end
---@param obj MIpmiSelDesc.SelData1
function TSelData1:init_from_obj(obj)
    self.SelData1 = obj.SelData1 or 255
end

function TSelData1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelData1.group)
end

TSelData1.from_obj = TSelData1_from_obj

TSelData1.proto_property = {'SelData1'}

TSelData1.default = {0}

TSelData1.struct = {{name = 'SelData1', is_array = false, struct = nil}}

function TSelData1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SelData1', self.SelData1, 'uint8', false, errs, need_convert)

    TSelData1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelData1.proto_property, errs, need_convert)
    return self
end

function TSelData1:unpack(_)
    return self.SelData1
end

MIpmiSelDesc.SelData1 = TSelData1

---@class MIpmiSelDesc.SelDesc
---@field SelDesc string
local TSelDesc = {}
TSelDesc.__index = TSelDesc
TSelDesc.group = {}

local function TSelDesc_from_obj(obj)
    return setmetatable(obj, TSelDesc)
end

function TSelDesc.new(SelDesc)
    return TSelDesc_from_obj({SelDesc = SelDesc})
end
---@param obj MIpmiSelDesc.SelDesc
function TSelDesc:init_from_obj(obj)
    self.SelDesc = obj.SelDesc
end

function TSelDesc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelDesc.group)
end

TSelDesc.from_obj = TSelDesc_from_obj

TSelDesc.proto_property = {'SelDesc'}

TSelDesc.default = {''}

TSelDesc.struct = {{name = 'SelDesc', is_array = false, struct = nil}}

function TSelDesc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SelDesc', self.SelDesc, 'string', false, errs, need_convert)

    TSelDesc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelDesc.proto_property, errs, need_convert)
    return self
end

function TSelDesc:unpack(_)
    return self.SelDesc
end

MIpmiSelDesc.SelDesc = TSelDesc

---@class MIpmiSelDesc.AlarmLevel
---@field AlarmLevel integer
local TAlarmLevel = {}
TAlarmLevel.__index = TAlarmLevel
TAlarmLevel.group = {}

local function TAlarmLevel_from_obj(obj)
    return setmetatable(obj, TAlarmLevel)
end

function TAlarmLevel.new(AlarmLevel)
    return TAlarmLevel_from_obj({AlarmLevel = AlarmLevel})
end
---@param obj MIpmiSelDesc.AlarmLevel
function TAlarmLevel:init_from_obj(obj)
    self.AlarmLevel = obj.AlarmLevel
end

function TAlarmLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlarmLevel.group)
end

TAlarmLevel.from_obj = TAlarmLevel_from_obj

TAlarmLevel.proto_property = {'AlarmLevel'}

TAlarmLevel.default = {0}

TAlarmLevel.struct = {{name = 'AlarmLevel', is_array = false, struct = nil}}

function TAlarmLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'AlarmLevel', self.AlarmLevel, 'uint8', false, errs, need_convert)

    TAlarmLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlarmLevel.proto_property, errs, need_convert)
    return self
end

function TAlarmLevel:unpack(_)
    return self.AlarmLevel
end

MIpmiSelDesc.AlarmLevel = TAlarmLevel

---@class MIpmiSelDesc.ReadingType
---@field ReadingType integer
local TReadingType = {}
TReadingType.__index = TReadingType
TReadingType.group = {}

local function TReadingType_from_obj(obj)
    return setmetatable(obj, TReadingType)
end

function TReadingType.new(ReadingType)
    return TReadingType_from_obj({ReadingType = ReadingType})
end
---@param obj MIpmiSelDesc.ReadingType
function TReadingType:init_from_obj(obj)
    self.ReadingType = obj.ReadingType
end

function TReadingType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingType.group)
end

TReadingType.from_obj = TReadingType_from_obj

TReadingType.proto_property = {'ReadingType'}

TReadingType.default = {0}

TReadingType.struct = {{name = 'ReadingType', is_array = false, struct = nil}}

function TReadingType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ReadingType', self.ReadingType, 'uint8', false, errs, need_convert)

    TReadingType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingType.proto_property, errs, need_convert)
    return self
end

function TReadingType:unpack(_)
    return self.ReadingType
end

MIpmiSelDesc.ReadingType = TReadingType

---@class MIpmiSelDesc.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType})
end
---@param obj MIpmiSelDesc.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

MIpmiSelDesc.SensorType = TSensorType

return MIpmiSelDesc
