-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiPefFilter = {}

---@class MIpmiPefFilter.Event3Compare2
---@field Event3Compare2 integer
local TEvent3Compare2 = {}
TEvent3Compare2.__index = TEvent3Compare2
TEvent3Compare2.group = {}

local function TEvent3Compare2_from_obj(obj)
    return setmetatable(obj, TEvent3Compare2)
end

function TEvent3Compare2.new(Event3Compare2)
    return TEvent3Compare2_from_obj({Event3Compare2 = Event3Compare2})
end
---@param obj MIpmiPefFilter.Event3Compare2
function TEvent3Compare2:init_from_obj(obj)
    self.Event3Compare2 = obj.Event3Compare2
end

function TEvent3Compare2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent3Compare2.group)
end

TEvent3Compare2.from_obj = TEvent3Compare2_from_obj

TEvent3Compare2.proto_property = {'Event3Compare2'}

TEvent3Compare2.default = {0}

TEvent3Compare2.struct = {{name = 'Event3Compare2', is_array = false, struct = nil}}

function TEvent3Compare2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event3Compare2', self.Event3Compare2, 'uint8', false, errs, need_convert)

    TEvent3Compare2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent3Compare2.proto_property, errs, need_convert)
    return self
end

function TEvent3Compare2:unpack(_)
    return self.Event3Compare2
end

MIpmiPefFilter.Event3Compare2 = TEvent3Compare2

---@class MIpmiPefFilter.Event3Compare1
---@field Event3Compare1 integer
local TEvent3Compare1 = {}
TEvent3Compare1.__index = TEvent3Compare1
TEvent3Compare1.group = {}

local function TEvent3Compare1_from_obj(obj)
    return setmetatable(obj, TEvent3Compare1)
end

function TEvent3Compare1.new(Event3Compare1)
    return TEvent3Compare1_from_obj({Event3Compare1 = Event3Compare1})
end
---@param obj MIpmiPefFilter.Event3Compare1
function TEvent3Compare1:init_from_obj(obj)
    self.Event3Compare1 = obj.Event3Compare1
end

function TEvent3Compare1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent3Compare1.group)
end

TEvent3Compare1.from_obj = TEvent3Compare1_from_obj

TEvent3Compare1.proto_property = {'Event3Compare1'}

TEvent3Compare1.default = {0}

TEvent3Compare1.struct = {{name = 'Event3Compare1', is_array = false, struct = nil}}

function TEvent3Compare1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event3Compare1', self.Event3Compare1, 'uint8', false, errs, need_convert)

    TEvent3Compare1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent3Compare1.proto_property, errs, need_convert)
    return self
end

function TEvent3Compare1:unpack(_)
    return self.Event3Compare1
end

MIpmiPefFilter.Event3Compare1 = TEvent3Compare1

---@class MIpmiPefFilter.Event3AndMask
---@field Event3AndMask integer
local TEvent3AndMask = {}
TEvent3AndMask.__index = TEvent3AndMask
TEvent3AndMask.group = {}

local function TEvent3AndMask_from_obj(obj)
    return setmetatable(obj, TEvent3AndMask)
end

function TEvent3AndMask.new(Event3AndMask)
    return TEvent3AndMask_from_obj({Event3AndMask = Event3AndMask})
end
---@param obj MIpmiPefFilter.Event3AndMask
function TEvent3AndMask:init_from_obj(obj)
    self.Event3AndMask = obj.Event3AndMask
end

function TEvent3AndMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent3AndMask.group)
end

TEvent3AndMask.from_obj = TEvent3AndMask_from_obj

TEvent3AndMask.proto_property = {'Event3AndMask'}

TEvent3AndMask.default = {0}

TEvent3AndMask.struct = {{name = 'Event3AndMask', is_array = false, struct = nil}}

function TEvent3AndMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event3AndMask', self.Event3AndMask, 'uint8', false, errs, need_convert)

    TEvent3AndMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent3AndMask.proto_property, errs, need_convert)
    return self
end

function TEvent3AndMask:unpack(_)
    return self.Event3AndMask
end

MIpmiPefFilter.Event3AndMask = TEvent3AndMask

---@class MIpmiPefFilter.Event2Compare2
---@field Event2Compare2 integer
local TEvent2Compare2 = {}
TEvent2Compare2.__index = TEvent2Compare2
TEvent2Compare2.group = {}

local function TEvent2Compare2_from_obj(obj)
    return setmetatable(obj, TEvent2Compare2)
end

function TEvent2Compare2.new(Event2Compare2)
    return TEvent2Compare2_from_obj({Event2Compare2 = Event2Compare2})
end
---@param obj MIpmiPefFilter.Event2Compare2
function TEvent2Compare2:init_from_obj(obj)
    self.Event2Compare2 = obj.Event2Compare2
end

function TEvent2Compare2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent2Compare2.group)
end

TEvent2Compare2.from_obj = TEvent2Compare2_from_obj

TEvent2Compare2.proto_property = {'Event2Compare2'}

TEvent2Compare2.default = {0}

TEvent2Compare2.struct = {{name = 'Event2Compare2', is_array = false, struct = nil}}

function TEvent2Compare2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event2Compare2', self.Event2Compare2, 'uint8', false, errs, need_convert)

    TEvent2Compare2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent2Compare2.proto_property, errs, need_convert)
    return self
end

function TEvent2Compare2:unpack(_)
    return self.Event2Compare2
end

MIpmiPefFilter.Event2Compare2 = TEvent2Compare2

---@class MIpmiPefFilter.Event2Compare1
---@field Event2Compare1 integer
local TEvent2Compare1 = {}
TEvent2Compare1.__index = TEvent2Compare1
TEvent2Compare1.group = {}

local function TEvent2Compare1_from_obj(obj)
    return setmetatable(obj, TEvent2Compare1)
end

function TEvent2Compare1.new(Event2Compare1)
    return TEvent2Compare1_from_obj({Event2Compare1 = Event2Compare1})
end
---@param obj MIpmiPefFilter.Event2Compare1
function TEvent2Compare1:init_from_obj(obj)
    self.Event2Compare1 = obj.Event2Compare1
end

function TEvent2Compare1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent2Compare1.group)
end

TEvent2Compare1.from_obj = TEvent2Compare1_from_obj

TEvent2Compare1.proto_property = {'Event2Compare1'}

TEvent2Compare1.default = {0}

TEvent2Compare1.struct = {{name = 'Event2Compare1', is_array = false, struct = nil}}

function TEvent2Compare1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event2Compare1', self.Event2Compare1, 'uint8', false, errs, need_convert)

    TEvent2Compare1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent2Compare1.proto_property, errs, need_convert)
    return self
end

function TEvent2Compare1:unpack(_)
    return self.Event2Compare1
end

MIpmiPefFilter.Event2Compare1 = TEvent2Compare1

---@class MIpmiPefFilter.Event2AndMask
---@field Event2AndMask integer
local TEvent2AndMask = {}
TEvent2AndMask.__index = TEvent2AndMask
TEvent2AndMask.group = {}

local function TEvent2AndMask_from_obj(obj)
    return setmetatable(obj, TEvent2AndMask)
end

function TEvent2AndMask.new(Event2AndMask)
    return TEvent2AndMask_from_obj({Event2AndMask = Event2AndMask})
end
---@param obj MIpmiPefFilter.Event2AndMask
function TEvent2AndMask:init_from_obj(obj)
    self.Event2AndMask = obj.Event2AndMask
end

function TEvent2AndMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent2AndMask.group)
end

TEvent2AndMask.from_obj = TEvent2AndMask_from_obj

TEvent2AndMask.proto_property = {'Event2AndMask'}

TEvent2AndMask.default = {0}

TEvent2AndMask.struct = {{name = 'Event2AndMask', is_array = false, struct = nil}}

function TEvent2AndMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event2AndMask', self.Event2AndMask, 'uint8', false, errs, need_convert)

    TEvent2AndMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent2AndMask.proto_property, errs, need_convert)
    return self
end

function TEvent2AndMask:unpack(_)
    return self.Event2AndMask
end

MIpmiPefFilter.Event2AndMask = TEvent2AndMask

---@class MIpmiPefFilter.Event1Compare2
---@field Event1Compare2 integer
local TEvent1Compare2 = {}
TEvent1Compare2.__index = TEvent1Compare2
TEvent1Compare2.group = {}

local function TEvent1Compare2_from_obj(obj)
    return setmetatable(obj, TEvent1Compare2)
end

function TEvent1Compare2.new(Event1Compare2)
    return TEvent1Compare2_from_obj({Event1Compare2 = Event1Compare2})
end
---@param obj MIpmiPefFilter.Event1Compare2
function TEvent1Compare2:init_from_obj(obj)
    self.Event1Compare2 = obj.Event1Compare2
end

function TEvent1Compare2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent1Compare2.group)
end

TEvent1Compare2.from_obj = TEvent1Compare2_from_obj

TEvent1Compare2.proto_property = {'Event1Compare2'}

TEvent1Compare2.default = {0}

TEvent1Compare2.struct = {{name = 'Event1Compare2', is_array = false, struct = nil}}

function TEvent1Compare2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event1Compare2', self.Event1Compare2, 'uint8', false, errs, need_convert)

    TEvent1Compare2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent1Compare2.proto_property, errs, need_convert)
    return self
end

function TEvent1Compare2:unpack(_)
    return self.Event1Compare2
end

MIpmiPefFilter.Event1Compare2 = TEvent1Compare2

---@class MIpmiPefFilter.Event1Compare1
---@field Event1Compare1 integer
local TEvent1Compare1 = {}
TEvent1Compare1.__index = TEvent1Compare1
TEvent1Compare1.group = {}

local function TEvent1Compare1_from_obj(obj)
    return setmetatable(obj, TEvent1Compare1)
end

function TEvent1Compare1.new(Event1Compare1)
    return TEvent1Compare1_from_obj({Event1Compare1 = Event1Compare1})
end
---@param obj MIpmiPefFilter.Event1Compare1
function TEvent1Compare1:init_from_obj(obj)
    self.Event1Compare1 = obj.Event1Compare1
end

function TEvent1Compare1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent1Compare1.group)
end

TEvent1Compare1.from_obj = TEvent1Compare1_from_obj

TEvent1Compare1.proto_property = {'Event1Compare1'}

TEvent1Compare1.default = {0}

TEvent1Compare1.struct = {{name = 'Event1Compare1', is_array = false, struct = nil}}

function TEvent1Compare1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event1Compare1', self.Event1Compare1, 'uint8', false, errs, need_convert)

    TEvent1Compare1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent1Compare1.proto_property, errs, need_convert)
    return self
end

function TEvent1Compare1:unpack(_)
    return self.Event1Compare1
end

MIpmiPefFilter.Event1Compare1 = TEvent1Compare1

---@class MIpmiPefFilter.Event1AndMask
---@field Event1AndMask integer
local TEvent1AndMask = {}
TEvent1AndMask.__index = TEvent1AndMask
TEvent1AndMask.group = {}

local function TEvent1AndMask_from_obj(obj)
    return setmetatable(obj, TEvent1AndMask)
end

function TEvent1AndMask.new(Event1AndMask)
    return TEvent1AndMask_from_obj({Event1AndMask = Event1AndMask})
end
---@param obj MIpmiPefFilter.Event1AndMask
function TEvent1AndMask:init_from_obj(obj)
    self.Event1AndMask = obj.Event1AndMask
end

function TEvent1AndMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvent1AndMask.group)
end

TEvent1AndMask.from_obj = TEvent1AndMask_from_obj

TEvent1AndMask.proto_property = {'Event1AndMask'}

TEvent1AndMask.default = {0}

TEvent1AndMask.struct = {{name = 'Event1AndMask', is_array = false, struct = nil}}

function TEvent1AndMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Event1AndMask', self.Event1AndMask, 'uint8', false, errs, need_convert)

    TEvent1AndMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvent1AndMask.proto_property, errs, need_convert)
    return self
end

function TEvent1AndMask:unpack(_)
    return self.Event1AndMask
end

MIpmiPefFilter.Event1AndMask = TEvent1AndMask

---@class MIpmiPefFilter.OffsetMask
---@field OffsetMask integer
local TOffsetMask = {}
TOffsetMask.__index = TOffsetMask
TOffsetMask.group = {}

local function TOffsetMask_from_obj(obj)
    return setmetatable(obj, TOffsetMask)
end

function TOffsetMask.new(OffsetMask)
    return TOffsetMask_from_obj({OffsetMask = OffsetMask})
end
---@param obj MIpmiPefFilter.OffsetMask
function TOffsetMask:init_from_obj(obj)
    self.OffsetMask = obj.OffsetMask
end

function TOffsetMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOffsetMask.group)
end

TOffsetMask.from_obj = TOffsetMask_from_obj

TOffsetMask.proto_property = {'OffsetMask'}

TOffsetMask.default = {0}

TOffsetMask.struct = {{name = 'OffsetMask', is_array = false, struct = nil}}

function TOffsetMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OffsetMask', self.OffsetMask, 'uint16', false, errs, need_convert)

    TOffsetMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOffsetMask.proto_property, errs, need_convert)
    return self
end

function TOffsetMask:unpack(_)
    return self.OffsetMask
end

MIpmiPefFilter.OffsetMask = TOffsetMask

---@class MIpmiPefFilter.EventTrigger
---@field EventTrigger integer
local TEventTrigger = {}
TEventTrigger.__index = TEventTrigger
TEventTrigger.group = {}

local function TEventTrigger_from_obj(obj)
    return setmetatable(obj, TEventTrigger)
end

function TEventTrigger.new(EventTrigger)
    return TEventTrigger_from_obj({EventTrigger = EventTrigger})
end
---@param obj MIpmiPefFilter.EventTrigger
function TEventTrigger:init_from_obj(obj)
    self.EventTrigger = obj.EventTrigger
end

function TEventTrigger:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventTrigger.group)
end

TEventTrigger.from_obj = TEventTrigger_from_obj

TEventTrigger.proto_property = {'EventTrigger'}

TEventTrigger.default = {0}

TEventTrigger.struct = {{name = 'EventTrigger', is_array = false, struct = nil}}

function TEventTrigger:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventTrigger', self.EventTrigger, 'uint8', false, errs, need_convert)

    TEventTrigger:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventTrigger.proto_property, errs, need_convert)
    return self
end

function TEventTrigger:unpack(_)
    return self.EventTrigger
end

MIpmiPefFilter.EventTrigger = TEventTrigger

---@class MIpmiPefFilter.SensorNumber
---@field SensorNumber integer
local TSensorNumber = {}
TSensorNumber.__index = TSensorNumber
TSensorNumber.group = {}

local function TSensorNumber_from_obj(obj)
    return setmetatable(obj, TSensorNumber)
end

function TSensorNumber.new(SensorNumber)
    return TSensorNumber_from_obj({SensorNumber = SensorNumber})
end
---@param obj MIpmiPefFilter.SensorNumber
function TSensorNumber:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber
end

function TSensorNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorNumber.group)
end

TSensorNumber.from_obj = TSensorNumber_from_obj

TSensorNumber.proto_property = {'SensorNumber'}

TSensorNumber.default = {0}

TSensorNumber.struct = {{name = 'SensorNumber', is_array = false, struct = nil}}

function TSensorNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint8', false, errs, need_convert)

    TSensorNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorNumber.proto_property, errs, need_convert)
    return self
end

function TSensorNumber:unpack(_)
    return self.SensorNumber
end

MIpmiPefFilter.SensorNumber = TSensorNumber

---@class MIpmiPefFilter.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType})
end
---@param obj MIpmiPefFilter.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', false, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

MIpmiPefFilter.SensorType = TSensorType

---@class MIpmiPefFilter.GeneratorId2
---@field GeneratorId2 integer
local TGeneratorId2 = {}
TGeneratorId2.__index = TGeneratorId2
TGeneratorId2.group = {}

local function TGeneratorId2_from_obj(obj)
    return setmetatable(obj, TGeneratorId2)
end

function TGeneratorId2.new(GeneratorId2)
    return TGeneratorId2_from_obj({GeneratorId2 = GeneratorId2})
end
---@param obj MIpmiPefFilter.GeneratorId2
function TGeneratorId2:init_from_obj(obj)
    self.GeneratorId2 = obj.GeneratorId2
end

function TGeneratorId2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGeneratorId2.group)
end

TGeneratorId2.from_obj = TGeneratorId2_from_obj

TGeneratorId2.proto_property = {'GeneratorId2'}

TGeneratorId2.default = {0}

TGeneratorId2.struct = {{name = 'GeneratorId2', is_array = false, struct = nil}}

function TGeneratorId2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GeneratorId2', self.GeneratorId2, 'uint8', false, errs, need_convert)

    TGeneratorId2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGeneratorId2.proto_property, errs, need_convert)
    return self
end

function TGeneratorId2:unpack(_)
    return self.GeneratorId2
end

MIpmiPefFilter.GeneratorId2 = TGeneratorId2

---@class MIpmiPefFilter.GeneratorId1
---@field GeneratorId1 integer
local TGeneratorId1 = {}
TGeneratorId1.__index = TGeneratorId1
TGeneratorId1.group = {}

local function TGeneratorId1_from_obj(obj)
    return setmetatable(obj, TGeneratorId1)
end

function TGeneratorId1.new(GeneratorId1)
    return TGeneratorId1_from_obj({GeneratorId1 = GeneratorId1})
end
---@param obj MIpmiPefFilter.GeneratorId1
function TGeneratorId1:init_from_obj(obj)
    self.GeneratorId1 = obj.GeneratorId1
end

function TGeneratorId1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGeneratorId1.group)
end

TGeneratorId1.from_obj = TGeneratorId1_from_obj

TGeneratorId1.proto_property = {'GeneratorId1'}

TGeneratorId1.default = {0}

TGeneratorId1.struct = {{name = 'GeneratorId1', is_array = false, struct = nil}}

function TGeneratorId1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GeneratorId1', self.GeneratorId1, 'uint8', false, errs, need_convert)

    TGeneratorId1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGeneratorId1.proto_property, errs, need_convert)
    return self
end

function TGeneratorId1:unpack(_)
    return self.GeneratorId1
end

MIpmiPefFilter.GeneratorId1 = TGeneratorId1

---@class MIpmiPefFilter.Severity
---@field Severity integer
local TSeverity = {}
TSeverity.__index = TSeverity
TSeverity.group = {}

local function TSeverity_from_obj(obj)
    return setmetatable(obj, TSeverity)
end

function TSeverity.new(Severity)
    return TSeverity_from_obj({Severity = Severity})
end
---@param obj MIpmiPefFilter.Severity
function TSeverity:init_from_obj(obj)
    self.Severity = obj.Severity
end

function TSeverity:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSeverity.group)
end

TSeverity.from_obj = TSeverity_from_obj

TSeverity.proto_property = {'Severity'}

TSeverity.default = {0}

TSeverity.struct = {{name = 'Severity', is_array = false, struct = nil}}

function TSeverity:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Severity', self.Severity, 'uint8', false, errs, need_convert)

    TSeverity:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSeverity.proto_property, errs, need_convert)
    return self
end

function TSeverity:unpack(_)
    return self.Severity
end

MIpmiPefFilter.Severity = TSeverity

---@class MIpmiPefFilter.PolicyNumber
---@field PolicyNumber integer
local TPolicyNumber = {}
TPolicyNumber.__index = TPolicyNumber
TPolicyNumber.group = {}

local function TPolicyNumber_from_obj(obj)
    return setmetatable(obj, TPolicyNumber)
end

function TPolicyNumber.new(PolicyNumber)
    return TPolicyNumber_from_obj({PolicyNumber = PolicyNumber})
end
---@param obj MIpmiPefFilter.PolicyNumber
function TPolicyNumber:init_from_obj(obj)
    self.PolicyNumber = obj.PolicyNumber
end

function TPolicyNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicyNumber.group)
end

TPolicyNumber.from_obj = TPolicyNumber_from_obj

TPolicyNumber.proto_property = {'PolicyNumber'}

TPolicyNumber.default = {0}

TPolicyNumber.struct = {{name = 'PolicyNumber', is_array = false, struct = nil}}

function TPolicyNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PolicyNumber', self.PolicyNumber, 'uint8', false, errs, need_convert)

    TPolicyNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicyNumber.proto_property, errs, need_convert)
    return self
end

function TPolicyNumber:unpack(_)
    return self.PolicyNumber
end

MIpmiPefFilter.PolicyNumber = TPolicyNumber

---@class MIpmiPefFilter.Action
---@field Action integer
local TAction = {}
TAction.__index = TAction
TAction.group = {}

local function TAction_from_obj(obj)
    return setmetatable(obj, TAction)
end

function TAction.new(Action)
    return TAction_from_obj({Action = Action})
end
---@param obj MIpmiPefFilter.Action
function TAction:init_from_obj(obj)
    self.Action = obj.Action
end

function TAction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAction.group)
end

TAction.from_obj = TAction_from_obj

TAction.proto_property = {'Action'}

TAction.default = {0}

TAction.struct = {{name = 'Action', is_array = false, struct = nil}}

function TAction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Action', self.Action, 'uint8', false, errs, need_convert)

    TAction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAction.proto_property, errs, need_convert)
    return self
end

function TAction:unpack(_)
    return self.Action
end

MIpmiPefFilter.Action = TAction

---@class MIpmiPefFilter.Configuration
---@field Configuration integer
local TConfiguration = {}
TConfiguration.__index = TConfiguration
TConfiguration.group = {}

local function TConfiguration_from_obj(obj)
    return setmetatable(obj, TConfiguration)
end

function TConfiguration.new(Configuration)
    return TConfiguration_from_obj({Configuration = Configuration})
end
---@param obj MIpmiPefFilter.Configuration
function TConfiguration:init_from_obj(obj)
    self.Configuration = obj.Configuration
end

function TConfiguration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfiguration.group)
end

TConfiguration.from_obj = TConfiguration_from_obj

TConfiguration.proto_property = {'Configuration'}

TConfiguration.default = {0}

TConfiguration.struct = {{name = 'Configuration', is_array = false, struct = nil}}

function TConfiguration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Configuration', self.Configuration, 'uint8', false, errs, need_convert)

    TConfiguration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfiguration.proto_property, errs, need_convert)
    return self
end

function TConfiguration:unpack(_)
    return self.Configuration
end

MIpmiPefFilter.Configuration = TConfiguration

return MIpmiPefFilter
