-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiPefControl = {}

---@class MIpmiPefControl.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 1})
end
---@param obj MIpmiPefControl.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 1
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MIpmiPefControl.Id = TId

---@class MIpmiPefControl.NextEvent
---@field NextEvent integer
local TNextEvent = {}
TNextEvent.__index = TNextEvent
TNextEvent.group = {}

local function TNextEvent_from_obj(obj)
    return setmetatable(obj, TNextEvent)
end

function TNextEvent.new(NextEvent)
    return TNextEvent_from_obj({NextEvent = NextEvent or 0})
end
---@param obj MIpmiPefControl.NextEvent
function TNextEvent:init_from_obj(obj)
    self.NextEvent = obj.NextEvent or 0
end

function TNextEvent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNextEvent.group)
end

TNextEvent.from_obj = TNextEvent_from_obj

TNextEvent.proto_property = {'NextEvent'}

TNextEvent.default = {0}

TNextEvent.struct = {{name = 'NextEvent', is_array = false, struct = nil}}

function TNextEvent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NextEvent', self.NextEvent, 'uint16', false, errs, need_convert)

    TNextEvent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNextEvent.proto_property, errs, need_convert)
    return self
end

function TNextEvent:unpack(_)
    return self.NextEvent
end

MIpmiPefControl.NextEvent = TNextEvent

---@class MIpmiPefControl.LastEventSMS
---@field LastEventSMS integer
local TLastEventSMS = {}
TLastEventSMS.__index = TLastEventSMS
TLastEventSMS.group = {}

local function TLastEventSMS_from_obj(obj)
    return setmetatable(obj, TLastEventSMS)
end

function TLastEventSMS.new(LastEventSMS)
    return TLastEventSMS_from_obj({LastEventSMS = LastEventSMS or 0})
end
---@param obj MIpmiPefControl.LastEventSMS
function TLastEventSMS:init_from_obj(obj)
    self.LastEventSMS = obj.LastEventSMS or 0
end

function TLastEventSMS:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastEventSMS.group)
end

TLastEventSMS.from_obj = TLastEventSMS_from_obj

TLastEventSMS.proto_property = {'LastEventSMS'}

TLastEventSMS.default = {0}

TLastEventSMS.struct = {{name = 'LastEventSMS', is_array = false, struct = nil}}

function TLastEventSMS:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastEventSMS', self.LastEventSMS, 'uint16', false, errs, need_convert)

    TLastEventSMS:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastEventSMS.proto_property, errs, need_convert)
    return self
end

function TLastEventSMS:unpack(_)
    return self.LastEventSMS
end

MIpmiPefControl.LastEventSMS = TLastEventSMS

---@class MIpmiPefControl.LastEventBMC
---@field LastEventBMC integer
local TLastEventBMC = {}
TLastEventBMC.__index = TLastEventBMC
TLastEventBMC.group = {}

local function TLastEventBMC_from_obj(obj)
    return setmetatable(obj, TLastEventBMC)
end

function TLastEventBMC.new(LastEventBMC)
    return TLastEventBMC_from_obj({LastEventBMC = LastEventBMC or 0})
end
---@param obj MIpmiPefControl.LastEventBMC
function TLastEventBMC:init_from_obj(obj)
    self.LastEventBMC = obj.LastEventBMC or 0
end

function TLastEventBMC:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastEventBMC.group)
end

TLastEventBMC.from_obj = TLastEventBMC_from_obj

TLastEventBMC.proto_property = {'LastEventBMC'}

TLastEventBMC.default = {0}

TLastEventBMC.struct = {{name = 'LastEventBMC', is_array = false, struct = nil}}

function TLastEventBMC:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastEventBMC', self.LastEventBMC, 'uint16', false, errs, need_convert)

    TLastEventBMC:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastEventBMC.proto_property, errs, need_convert)
    return self
end

function TLastEventBMC:unpack(_)
    return self.LastEventBMC
end

MIpmiPefControl.LastEventBMC = TLastEventBMC

---@class MIpmiPefControl.UnqueuedEvent
---@field UnqueuedEvent integer
local TUnqueuedEvent = {}
TUnqueuedEvent.__index = TUnqueuedEvent
TUnqueuedEvent.group = {}

local function TUnqueuedEvent_from_obj(obj)
    return setmetatable(obj, TUnqueuedEvent)
end

function TUnqueuedEvent.new(UnqueuedEvent)
    return TUnqueuedEvent_from_obj({UnqueuedEvent = UnqueuedEvent or 0})
end
---@param obj MIpmiPefControl.UnqueuedEvent
function TUnqueuedEvent:init_from_obj(obj)
    self.UnqueuedEvent = obj.UnqueuedEvent or 0
end

function TUnqueuedEvent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnqueuedEvent.group)
end

TUnqueuedEvent.from_obj = TUnqueuedEvent_from_obj

TUnqueuedEvent.proto_property = {'UnqueuedEvent'}

TUnqueuedEvent.default = {0}

TUnqueuedEvent.struct = {{name = 'UnqueuedEvent', is_array = false, struct = nil}}

function TUnqueuedEvent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnqueuedEvent', self.UnqueuedEvent, 'uint16', false, errs, need_convert)

    TUnqueuedEvent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnqueuedEvent.proto_property, errs, need_convert)
    return self
end

function TUnqueuedEvent:unpack(_)
    return self.UnqueuedEvent
end

MIpmiPefControl.UnqueuedEvent = TUnqueuedEvent

---@class MIpmiPefControl.Action
---@field Action integer
local TAction = {}
TAction.__index = TAction
TAction.group = {}

local function TAction_from_obj(obj)
    return setmetatable(obj, TAction)
end

function TAction.new(Action)
    return TAction_from_obj({Action = Action or 0})
end
---@param obj MIpmiPefControl.Action
function TAction:init_from_obj(obj)
    self.Action = obj.Action or 0
end

function TAction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAction.group)
end

TAction.from_obj = TAction_from_obj

TAction.proto_property = {'Action'}

TAction.default = {0}

TAction.struct = {{name = 'Action', is_array = false, struct = nil}}

function TAction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Action', self.Action, 'uint32', false, errs, need_convert)

    TAction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAction.proto_property, errs, need_convert)
    return self
end

function TAction:unpack(_)
    return self.Action
end

MIpmiPefControl.Action = TAction

---@class MIpmiPefControl.StartupDelayTID
---@field StartupDelayTID integer
local TStartupDelayTID = {}
TStartupDelayTID.__index = TStartupDelayTID
TStartupDelayTID.group = {}

local function TStartupDelayTID_from_obj(obj)
    return setmetatable(obj, TStartupDelayTID)
end

function TStartupDelayTID.new(StartupDelayTID)
    return TStartupDelayTID_from_obj({StartupDelayTID = StartupDelayTID or 0})
end
---@param obj MIpmiPefControl.StartupDelayTID
function TStartupDelayTID:init_from_obj(obj)
    self.StartupDelayTID = obj.StartupDelayTID or 0
end

function TStartupDelayTID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartupDelayTID.group)
end

TStartupDelayTID.from_obj = TStartupDelayTID_from_obj

TStartupDelayTID.proto_property = {'StartupDelayTID'}

TStartupDelayTID.default = {0}

TStartupDelayTID.struct = {{name = 'StartupDelayTID', is_array = false, struct = nil}}

function TStartupDelayTID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartupDelayTID', self.StartupDelayTID, 'uint16', false, errs, need_convert)

    TStartupDelayTID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartupDelayTID.proto_property, errs, need_convert)
    return self
end

function TStartupDelayTID:unpack(_)
    return self.StartupDelayTID
end

MIpmiPefControl.StartupDelayTID = TStartupDelayTID

---@class MIpmiPefControl.PostponeTimeout
---@field PostponeTimeout integer
local TPostponeTimeout = {}
TPostponeTimeout.__index = TPostponeTimeout
TPostponeTimeout.group = {}

local function TPostponeTimeout_from_obj(obj)
    return setmetatable(obj, TPostponeTimeout)
end

function TPostponeTimeout.new(PostponeTimeout)
    return TPostponeTimeout_from_obj({PostponeTimeout = PostponeTimeout or 0})
end
---@param obj MIpmiPefControl.PostponeTimeout
function TPostponeTimeout:init_from_obj(obj)
    self.PostponeTimeout = obj.PostponeTimeout or 0
end

function TPostponeTimeout:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPostponeTimeout.group)
end

TPostponeTimeout.from_obj = TPostponeTimeout_from_obj

TPostponeTimeout.proto_property = {'PostponeTimeout'}

TPostponeTimeout.default = {0}

TPostponeTimeout.struct = {{name = 'PostponeTimeout', is_array = false, struct = nil}}

function TPostponeTimeout:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PostponeTimeout', self.PostponeTimeout, 'uint8', false, errs, need_convert)

    TPostponeTimeout:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPostponeTimeout.proto_property, errs, need_convert)
    return self
end

function TPostponeTimeout:unpack(_)
    return self.PostponeTimeout
end

MIpmiPefControl.PostponeTimeout = TPostponeTimeout

---@class MIpmiPefControl.InProgress
---@field InProgress integer
local TInProgress = {}
TInProgress.__index = TInProgress
TInProgress.group = {}

local function TInProgress_from_obj(obj)
    return setmetatable(obj, TInProgress)
end

function TInProgress.new(InProgress)
    return TInProgress_from_obj({InProgress = InProgress or 0})
end
---@param obj MIpmiPefControl.InProgress
function TInProgress:init_from_obj(obj)
    self.InProgress = obj.InProgress or 0
end

function TInProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInProgress.group)
end

TInProgress.from_obj = TInProgress_from_obj

TInProgress.proto_property = {'InProgress'}

TInProgress.default = {0}

TInProgress.struct = {{name = 'InProgress', is_array = false, struct = nil}}

function TInProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InProgress', self.InProgress, 'uint8', false, errs, need_convert)

    TInProgress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInProgress.proto_property, errs, need_convert)
    return self
end

function TInProgress:unpack(_)
    return self.InProgress
end

MIpmiPefControl.InProgress = TInProgress

return MIpmiPefControl
