-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiPefAlertString = {}

---@class MIpmiPefAlertString.AlertString
---@field AlertString string
local TAlertString = {}
TAlertString.__index = TAlertString
TAlertString.group = {}

local function TAlertString_from_obj(obj)
    return setmetatable(obj, TAlertString)
end

function TAlertString.new(AlertString)
    return TAlertString_from_obj({AlertString = AlertString})
end
---@param obj MIpmiPefAlertString.AlertString
function TAlertString:init_from_obj(obj)
    self.AlertString = obj.AlertString
end

function TAlertString:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlertString.group)
end

TAlertString.from_obj = TAlertString_from_obj

TAlertString.proto_property = {'AlertString'}

TAlertString.default = {''}

TAlertString.struct = {{name = 'AlertString', is_array = false, struct = nil}}

function TAlertString:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AlertString', self.AlertString, 'string', false, errs, need_convert)

    TAlertString:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlertString.proto_property, errs, need_convert)
    return self
end

function TAlertString:unpack(_)
    return self.AlertString
end

MIpmiPefAlertString.AlertString = TAlertString

---@class MIpmiPefAlertString.StringSet
---@field StringSet integer
local TStringSet = {}
TStringSet.__index = TStringSet
TStringSet.group = {}

local function TStringSet_from_obj(obj)
    return setmetatable(obj, TStringSet)
end

function TStringSet.new(StringSet)
    return TStringSet_from_obj({StringSet = StringSet})
end
---@param obj MIpmiPefAlertString.StringSet
function TStringSet:init_from_obj(obj)
    self.StringSet = obj.StringSet
end

function TStringSet:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStringSet.group)
end

TStringSet.from_obj = TStringSet_from_obj

TStringSet.proto_property = {'StringSet'}

TStringSet.default = {0}

TStringSet.struct = {{name = 'StringSet', is_array = false, struct = nil}}

function TStringSet:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StringSet', self.StringSet, 'uint8', false, errs, need_convert)

    TStringSet:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStringSet.proto_property, errs, need_convert)
    return self
end

function TStringSet:unpack(_)
    return self.StringSet
end

MIpmiPefAlertString.StringSet = TStringSet

---@class MIpmiPefAlertString.FilterNumber
---@field FilterNumber integer
local TFilterNumber = {}
TFilterNumber.__index = TFilterNumber
TFilterNumber.group = {}

local function TFilterNumber_from_obj(obj)
    return setmetatable(obj, TFilterNumber)
end

function TFilterNumber.new(FilterNumber)
    return TFilterNumber_from_obj({FilterNumber = FilterNumber})
end
---@param obj MIpmiPefAlertString.FilterNumber
function TFilterNumber:init_from_obj(obj)
    self.FilterNumber = obj.FilterNumber
end

function TFilterNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFilterNumber.group)
end

TFilterNumber.from_obj = TFilterNumber_from_obj

TFilterNumber.proto_property = {'FilterNumber'}

TFilterNumber.default = {0}

TFilterNumber.struct = {{name = 'FilterNumber', is_array = false, struct = nil}}

function TFilterNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilterNumber', self.FilterNumber, 'uint8', false, errs, need_convert)

    TFilterNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFilterNumber.proto_property, errs, need_convert)
    return self
end

function TFilterNumber:unpack(_)
    return self.FilterNumber
end

MIpmiPefAlertString.FilterNumber = TFilterNumber

---@class MIpmiPefAlertString.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MIpmiPefAlertString.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MIpmiPefAlertString.Id = TId

return MIpmiPefAlertString
