-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MEntity = {}

---@class MEntity.BelongsToSystem
---@field BelongsToSystem boolean
local TBelongsToSystem = {}
TBelongsToSystem.__index = TBelongsToSystem
TBelongsToSystem.group = {}

local function TBelongsToSystem_from_obj(obj)
    return setmetatable(obj, TBelongsToSystem)
end

function TBelongsToSystem.new(BelongsToSystem)
    return TBelongsToSystem_from_obj({BelongsToSystem = BelongsToSystem or false})
end
---@param obj MEntity.BelongsToSystem
function TBelongsToSystem:init_from_obj(obj)
    self.BelongsToSystem = obj.BelongsToSystem or false
end

function TBelongsToSystem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBelongsToSystem.group)
end

TBelongsToSystem.from_obj = TBelongsToSystem_from_obj

TBelongsToSystem.proto_property = {'BelongsToSystem'}

TBelongsToSystem.default = {false}

TBelongsToSystem.struct = {{name = 'BelongsToSystem', is_array = false, struct = nil}}

function TBelongsToSystem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BelongsToSystem', self.BelongsToSystem, 'bool', true, errs, need_convert)

    TBelongsToSystem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBelongsToSystem.proto_property, errs, need_convert)
    return self
end

function TBelongsToSystem:unpack(_)
    return self.BelongsToSystem
end

MEntity.BelongsToSystem = TBelongsToSystem

return MEntity
