-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDEASDR = {}

---@class MDEASDR.Entity4Instance
---@field Entity4Instance integer
local TEntity4Instance = {}
TEntity4Instance.__index = TEntity4Instance
TEntity4Instance.group = {}

local function TEntity4Instance_from_obj(obj)
    return setmetatable(obj, TEntity4Instance)
end

function TEntity4Instance.new(Entity4Instance)
    return TEntity4Instance_from_obj({Entity4Instance = Entity4Instance})
end
---@param obj MDEASDR.Entity4Instance
function TEntity4Instance:init_from_obj(obj)
    self.Entity4Instance = obj.Entity4Instance
end

function TEntity4Instance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity4Instance.group)
end

TEntity4Instance.from_obj = TEntity4Instance_from_obj

TEntity4Instance.proto_property = {'Entity4Instance'}

TEntity4Instance.default = {0}

TEntity4Instance.struct = {{name = 'Entity4Instance', is_array = false, struct = nil}}

function TEntity4Instance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity4Instance', self.Entity4Instance, 'uint8', false, errs, need_convert)

    TEntity4Instance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity4Instance.proto_property, errs, need_convert)
    return self
end

function TEntity4Instance:unpack(_)
    return self.Entity4Instance
end

MDEASDR.Entity4Instance = TEntity4Instance

---@class MDEASDR.Entity4Id
---@field Entity4Id integer
local TEntity4Id = {}
TEntity4Id.__index = TEntity4Id
TEntity4Id.group = {}

local function TEntity4Id_from_obj(obj)
    return setmetatable(obj, TEntity4Id)
end

function TEntity4Id.new(Entity4Id)
    return TEntity4Id_from_obj({Entity4Id = Entity4Id})
end
---@param obj MDEASDR.Entity4Id
function TEntity4Id:init_from_obj(obj)
    self.Entity4Id = obj.Entity4Id
end

function TEntity4Id:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity4Id.group)
end

TEntity4Id.from_obj = TEntity4Id_from_obj

TEntity4Id.proto_property = {'Entity4Id'}

TEntity4Id.default = {0}

TEntity4Id.struct = {{name = 'Entity4Id', is_array = false, struct = nil}}

function TEntity4Id:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity4Id', self.Entity4Id, 'uint8', false, errs, need_convert)

    TEntity4Id:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity4Id.proto_property, errs, need_convert)
    return self
end

function TEntity4Id:unpack(_)
    return self.Entity4Id
end

MDEASDR.Entity4Id = TEntity4Id

---@class MDEASDR.Channel4
---@field Channel4 integer
local TChannel4 = {}
TChannel4.__index = TChannel4
TChannel4.group = {}

local function TChannel4_from_obj(obj)
    return setmetatable(obj, TChannel4)
end

function TChannel4.new(Channel4)
    return TChannel4_from_obj({Channel4 = Channel4 or 0})
end
---@param obj MDEASDR.Channel4
function TChannel4:init_from_obj(obj)
    self.Channel4 = obj.Channel4 or 0
end

function TChannel4:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel4.group)
end

TChannel4.from_obj = TChannel4_from_obj

TChannel4.proto_property = {'Channel4'}

TChannel4.default = {0}

TChannel4.struct = {{name = 'Channel4', is_array = false, struct = nil}}

function TChannel4:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel4', self.Channel4, 'uint8', false, errs, need_convert)

    TChannel4:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel4.proto_property, errs, need_convert)
    return self
end

function TChannel4:unpack(_)
    return self.Channel4
end

MDEASDR.Channel4 = TChannel4

---@class MDEASDR.Address4
---@field Address4 integer
local TAddress4 = {}
TAddress4.__index = TAddress4
TAddress4.group = {}

local function TAddress4_from_obj(obj)
    return setmetatable(obj, TAddress4)
end

function TAddress4.new(Address4)
    return TAddress4_from_obj({Address4 = Address4 or 0})
end
---@param obj MDEASDR.Address4
function TAddress4:init_from_obj(obj)
    self.Address4 = obj.Address4 or 0
end

function TAddress4:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress4.group)
end

TAddress4.from_obj = TAddress4_from_obj

TAddress4.proto_property = {'Address4'}

TAddress4.default = {0}

TAddress4.struct = {{name = 'Address4', is_array = false, struct = nil}}

function TAddress4:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address4', self.Address4, 'uint8', false, errs, need_convert)

    TAddress4:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress4.proto_property, errs, need_convert)
    return self
end

function TAddress4:unpack(_)
    return self.Address4
end

MDEASDR.Address4 = TAddress4

---@class MDEASDR.Entity3Instance
---@field Entity3Instance integer
local TEntity3Instance = {}
TEntity3Instance.__index = TEntity3Instance
TEntity3Instance.group = {}

local function TEntity3Instance_from_obj(obj)
    return setmetatable(obj, TEntity3Instance)
end

function TEntity3Instance.new(Entity3Instance)
    return TEntity3Instance_from_obj({Entity3Instance = Entity3Instance})
end
---@param obj MDEASDR.Entity3Instance
function TEntity3Instance:init_from_obj(obj)
    self.Entity3Instance = obj.Entity3Instance
end

function TEntity3Instance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity3Instance.group)
end

TEntity3Instance.from_obj = TEntity3Instance_from_obj

TEntity3Instance.proto_property = {'Entity3Instance'}

TEntity3Instance.default = {0}

TEntity3Instance.struct = {{name = 'Entity3Instance', is_array = false, struct = nil}}

function TEntity3Instance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity3Instance', self.Entity3Instance, 'uint8', false, errs, need_convert)

    TEntity3Instance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity3Instance.proto_property, errs, need_convert)
    return self
end

function TEntity3Instance:unpack(_)
    return self.Entity3Instance
end

MDEASDR.Entity3Instance = TEntity3Instance

---@class MDEASDR.Entity3Id
---@field Entity3Id integer
local TEntity3Id = {}
TEntity3Id.__index = TEntity3Id
TEntity3Id.group = {}

local function TEntity3Id_from_obj(obj)
    return setmetatable(obj, TEntity3Id)
end

function TEntity3Id.new(Entity3Id)
    return TEntity3Id_from_obj({Entity3Id = Entity3Id})
end
---@param obj MDEASDR.Entity3Id
function TEntity3Id:init_from_obj(obj)
    self.Entity3Id = obj.Entity3Id
end

function TEntity3Id:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity3Id.group)
end

TEntity3Id.from_obj = TEntity3Id_from_obj

TEntity3Id.proto_property = {'Entity3Id'}

TEntity3Id.default = {0}

TEntity3Id.struct = {{name = 'Entity3Id', is_array = false, struct = nil}}

function TEntity3Id:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity3Id', self.Entity3Id, 'uint8', false, errs, need_convert)

    TEntity3Id:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity3Id.proto_property, errs, need_convert)
    return self
end

function TEntity3Id:unpack(_)
    return self.Entity3Id
end

MDEASDR.Entity3Id = TEntity3Id

---@class MDEASDR.Channel3
---@field Channel3 integer
local TChannel3 = {}
TChannel3.__index = TChannel3
TChannel3.group = {}

local function TChannel3_from_obj(obj)
    return setmetatable(obj, TChannel3)
end

function TChannel3.new(Channel3)
    return TChannel3_from_obj({Channel3 = Channel3 or 0})
end
---@param obj MDEASDR.Channel3
function TChannel3:init_from_obj(obj)
    self.Channel3 = obj.Channel3 or 0
end

function TChannel3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel3.group)
end

TChannel3.from_obj = TChannel3_from_obj

TChannel3.proto_property = {'Channel3'}

TChannel3.default = {0}

TChannel3.struct = {{name = 'Channel3', is_array = false, struct = nil}}

function TChannel3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel3', self.Channel3, 'uint8', false, errs, need_convert)

    TChannel3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel3.proto_property, errs, need_convert)
    return self
end

function TChannel3:unpack(_)
    return self.Channel3
end

MDEASDR.Channel3 = TChannel3

---@class MDEASDR.Address3
---@field Address3 integer
local TAddress3 = {}
TAddress3.__index = TAddress3
TAddress3.group = {}

local function TAddress3_from_obj(obj)
    return setmetatable(obj, TAddress3)
end

function TAddress3.new(Address3)
    return TAddress3_from_obj({Address3 = Address3 or 0})
end
---@param obj MDEASDR.Address3
function TAddress3:init_from_obj(obj)
    self.Address3 = obj.Address3 or 0
end

function TAddress3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress3.group)
end

TAddress3.from_obj = TAddress3_from_obj

TAddress3.proto_property = {'Address3'}

TAddress3.default = {0}

TAddress3.struct = {{name = 'Address3', is_array = false, struct = nil}}

function TAddress3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address3', self.Address3, 'uint8', false, errs, need_convert)

    TAddress3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress3.proto_property, errs, need_convert)
    return self
end

function TAddress3:unpack(_)
    return self.Address3
end

MDEASDR.Address3 = TAddress3

---@class MDEASDR.Entity2Instance
---@field Entity2Instance integer
local TEntity2Instance = {}
TEntity2Instance.__index = TEntity2Instance
TEntity2Instance.group = {}

local function TEntity2Instance_from_obj(obj)
    return setmetatable(obj, TEntity2Instance)
end

function TEntity2Instance.new(Entity2Instance)
    return TEntity2Instance_from_obj({Entity2Instance = Entity2Instance})
end
---@param obj MDEASDR.Entity2Instance
function TEntity2Instance:init_from_obj(obj)
    self.Entity2Instance = obj.Entity2Instance
end

function TEntity2Instance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity2Instance.group)
end

TEntity2Instance.from_obj = TEntity2Instance_from_obj

TEntity2Instance.proto_property = {'Entity2Instance'}

TEntity2Instance.default = {0}

TEntity2Instance.struct = {{name = 'Entity2Instance', is_array = false, struct = nil}}

function TEntity2Instance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity2Instance', self.Entity2Instance, 'uint8', false, errs, need_convert)

    TEntity2Instance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity2Instance.proto_property, errs, need_convert)
    return self
end

function TEntity2Instance:unpack(_)
    return self.Entity2Instance
end

MDEASDR.Entity2Instance = TEntity2Instance

---@class MDEASDR.Entity2Id
---@field Entity2Id integer
local TEntity2Id = {}
TEntity2Id.__index = TEntity2Id
TEntity2Id.group = {}

local function TEntity2Id_from_obj(obj)
    return setmetatable(obj, TEntity2Id)
end

function TEntity2Id.new(Entity2Id)
    return TEntity2Id_from_obj({Entity2Id = Entity2Id})
end
---@param obj MDEASDR.Entity2Id
function TEntity2Id:init_from_obj(obj)
    self.Entity2Id = obj.Entity2Id
end

function TEntity2Id:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity2Id.group)
end

TEntity2Id.from_obj = TEntity2Id_from_obj

TEntity2Id.proto_property = {'Entity2Id'}

TEntity2Id.default = {0}

TEntity2Id.struct = {{name = 'Entity2Id', is_array = false, struct = nil}}

function TEntity2Id:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity2Id', self.Entity2Id, 'uint8', false, errs, need_convert)

    TEntity2Id:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity2Id.proto_property, errs, need_convert)
    return self
end

function TEntity2Id:unpack(_)
    return self.Entity2Id
end

MDEASDR.Entity2Id = TEntity2Id

---@class MDEASDR.Channel2
---@field Channel2 integer
local TChannel2 = {}
TChannel2.__index = TChannel2
TChannel2.group = {}

local function TChannel2_from_obj(obj)
    return setmetatable(obj, TChannel2)
end

function TChannel2.new(Channel2)
    return TChannel2_from_obj({Channel2 = Channel2 or 0})
end
---@param obj MDEASDR.Channel2
function TChannel2:init_from_obj(obj)
    self.Channel2 = obj.Channel2 or 0
end

function TChannel2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel2.group)
end

TChannel2.from_obj = TChannel2_from_obj

TChannel2.proto_property = {'Channel2'}

TChannel2.default = {0}

TChannel2.struct = {{name = 'Channel2', is_array = false, struct = nil}}

function TChannel2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel2', self.Channel2, 'uint8', false, errs, need_convert)

    TChannel2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel2.proto_property, errs, need_convert)
    return self
end

function TChannel2:unpack(_)
    return self.Channel2
end

MDEASDR.Channel2 = TChannel2

---@class MDEASDR.Address2
---@field Address2 integer
local TAddress2 = {}
TAddress2.__index = TAddress2
TAddress2.group = {}

local function TAddress2_from_obj(obj)
    return setmetatable(obj, TAddress2)
end

function TAddress2.new(Address2)
    return TAddress2_from_obj({Address2 = Address2 or 0})
end
---@param obj MDEASDR.Address2
function TAddress2:init_from_obj(obj)
    self.Address2 = obj.Address2 or 0
end

function TAddress2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress2.group)
end

TAddress2.from_obj = TAddress2_from_obj

TAddress2.proto_property = {'Address2'}

TAddress2.default = {0}

TAddress2.struct = {{name = 'Address2', is_array = false, struct = nil}}

function TAddress2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address2', self.Address2, 'uint8', false, errs, need_convert)

    TAddress2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress2.proto_property, errs, need_convert)
    return self
end

function TAddress2:unpack(_)
    return self.Address2
end

MDEASDR.Address2 = TAddress2

---@class MDEASDR.Entity1Instance
---@field Entity1Instance integer
local TEntity1Instance = {}
TEntity1Instance.__index = TEntity1Instance
TEntity1Instance.group = {}

local function TEntity1Instance_from_obj(obj)
    return setmetatable(obj, TEntity1Instance)
end

function TEntity1Instance.new(Entity1Instance)
    return TEntity1Instance_from_obj({Entity1Instance = Entity1Instance})
end
---@param obj MDEASDR.Entity1Instance
function TEntity1Instance:init_from_obj(obj)
    self.Entity1Instance = obj.Entity1Instance
end

function TEntity1Instance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity1Instance.group)
end

TEntity1Instance.from_obj = TEntity1Instance_from_obj

TEntity1Instance.proto_property = {'Entity1Instance'}

TEntity1Instance.default = {0}

TEntity1Instance.struct = {{name = 'Entity1Instance', is_array = false, struct = nil}}

function TEntity1Instance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity1Instance', self.Entity1Instance, 'uint8', false, errs, need_convert)

    TEntity1Instance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity1Instance.proto_property, errs, need_convert)
    return self
end

function TEntity1Instance:unpack(_)
    return self.Entity1Instance
end

MDEASDR.Entity1Instance = TEntity1Instance

---@class MDEASDR.Entity1Id
---@field Entity1Id integer
local TEntity1Id = {}
TEntity1Id.__index = TEntity1Id
TEntity1Id.group = {}

local function TEntity1Id_from_obj(obj)
    return setmetatable(obj, TEntity1Id)
end

function TEntity1Id.new(Entity1Id)
    return TEntity1Id_from_obj({Entity1Id = Entity1Id})
end
---@param obj MDEASDR.Entity1Id
function TEntity1Id:init_from_obj(obj)
    self.Entity1Id = obj.Entity1Id
end

function TEntity1Id:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntity1Id.group)
end

TEntity1Id.from_obj = TEntity1Id_from_obj

TEntity1Id.proto_property = {'Entity1Id'}

TEntity1Id.default = {0}

TEntity1Id.struct = {{name = 'Entity1Id', is_array = false, struct = nil}}

function TEntity1Id:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Entity1Id', self.Entity1Id, 'uint8', false, errs, need_convert)

    TEntity1Id:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntity1Id.proto_property, errs, need_convert)
    return self
end

function TEntity1Id:unpack(_)
    return self.Entity1Id
end

MDEASDR.Entity1Id = TEntity1Id

---@class MDEASDR.Channel1
---@field Channel1 integer
local TChannel1 = {}
TChannel1.__index = TChannel1
TChannel1.group = {}

local function TChannel1_from_obj(obj)
    return setmetatable(obj, TChannel1)
end

function TChannel1.new(Channel1)
    return TChannel1_from_obj({Channel1 = Channel1 or 0})
end
---@param obj MDEASDR.Channel1
function TChannel1:init_from_obj(obj)
    self.Channel1 = obj.Channel1 or 0
end

function TChannel1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel1.group)
end

TChannel1.from_obj = TChannel1_from_obj

TChannel1.proto_property = {'Channel1'}

TChannel1.default = {0}

TChannel1.struct = {{name = 'Channel1', is_array = false, struct = nil}}

function TChannel1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel1', self.Channel1, 'uint8', false, errs, need_convert)

    TChannel1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel1.proto_property, errs, need_convert)
    return self
end

function TChannel1:unpack(_)
    return self.Channel1
end

MDEASDR.Channel1 = TChannel1

---@class MDEASDR.Address1
---@field Address1 integer
local TAddress1 = {}
TAddress1.__index = TAddress1
TAddress1.group = {}

local function TAddress1_from_obj(obj)
    return setmetatable(obj, TAddress1)
end

function TAddress1.new(Address1)
    return TAddress1_from_obj({Address1 = Address1 or 0})
end
---@param obj MDEASDR.Address1
function TAddress1:init_from_obj(obj)
    self.Address1 = obj.Address1 or 0
end

function TAddress1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress1.group)
end

TAddress1.from_obj = TAddress1_from_obj

TAddress1.proto_property = {'Address1'}

TAddress1.default = {0}

TAddress1.struct = {{name = 'Address1', is_array = false, struct = nil}}

function TAddress1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address1', self.Address1, 'uint8', false, errs, need_convert)

    TAddress1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress1.proto_property, errs, need_convert)
    return self
end

function TAddress1:unpack(_)
    return self.Address1
end

MDEASDR.Address1 = TAddress1

---@class MDEASDR.Flags
---@field Flags integer
local TFlags = {}
TFlags.__index = TFlags
TFlags.group = {}

local function TFlags_from_obj(obj)
    return setmetatable(obj, TFlags)
end

function TFlags.new(Flags)
    return TFlags_from_obj({Flags = Flags})
end
---@param obj MDEASDR.Flags
function TFlags:init_from_obj(obj)
    self.Flags = obj.Flags
end

function TFlags:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFlags.group)
end

TFlags.from_obj = TFlags_from_obj

TFlags.proto_property = {'Flags'}

TFlags.default = {0}

TFlags.struct = {{name = 'Flags', is_array = false, struct = nil}}

function TFlags:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Flags', self.Flags, 'uint8', false, errs, need_convert)

    TFlags:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFlags.proto_property, errs, need_convert)
    return self
end

function TFlags:unpack(_)
    return self.Flags
end

MDEASDR.Flags = TFlags

---@class MDEASDR.Channel
---@field Channel integer
local TChannel = {}
TChannel.__index = TChannel
TChannel.group = {}

local function TChannel_from_obj(obj)
    return setmetatable(obj, TChannel)
end

function TChannel.new(Channel)
    return TChannel_from_obj({Channel = Channel or 0})
end
---@param obj MDEASDR.Channel
function TChannel:init_from_obj(obj)
    self.Channel = obj.Channel or 0
end

function TChannel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel.group)
end

TChannel.from_obj = TChannel_from_obj

TChannel.proto_property = {'Channel'}

TChannel.default = {0}

TChannel.struct = {{name = 'Channel', is_array = false, struct = nil}}

function TChannel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel', self.Channel, 'uint8', false, errs, need_convert)

    TChannel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel.proto_property, errs, need_convert)
    return self
end

function TChannel:unpack(_)
    return self.Channel
end

MDEASDR.Channel = TChannel

---@class MDEASDR.Address
---@field Address integer
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address or 0})
end
---@param obj MDEASDR.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address or 0
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {0}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address', self.Address, 'uint8', false, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

MDEASDR.Address = TAddress

---@class MDEASDR.EntityInstance
---@field EntityInstance integer
local TEntityInstance = {}
TEntityInstance.__index = TEntityInstance
TEntityInstance.group = {}

local function TEntityInstance_from_obj(obj)
    return setmetatable(obj, TEntityInstance)
end

function TEntityInstance.new(EntityInstance)
    return TEntityInstance_from_obj({EntityInstance = EntityInstance})
end
---@param obj MDEASDR.EntityInstance
function TEntityInstance:init_from_obj(obj)
    self.EntityInstance = obj.EntityInstance
end

function TEntityInstance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityInstance.group)
end

TEntityInstance.from_obj = TEntityInstance_from_obj

TEntityInstance.proto_property = {'EntityInstance'}

TEntityInstance.default = {0}

TEntityInstance.struct = {{name = 'EntityInstance', is_array = false, struct = nil}}

function TEntityInstance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityInstance', self.EntityInstance, 'uint8', false, errs, need_convert)

    TEntityInstance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityInstance.proto_property, errs, need_convert)
    return self
end

function TEntityInstance:unpack(_)
    return self.EntityInstance
end

MDEASDR.EntityInstance = TEntityInstance

---@class MDEASDR.EntityId
---@field EntityId integer
local TEntityId = {}
TEntityId.__index = TEntityId
TEntityId.group = {}

local function TEntityId_from_obj(obj)
    return setmetatable(obj, TEntityId)
end

function TEntityId.new(EntityId)
    return TEntityId_from_obj({EntityId = EntityId})
end
---@param obj MDEASDR.EntityId
function TEntityId:init_from_obj(obj)
    self.EntityId = obj.EntityId
end

function TEntityId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityId.group)
end

TEntityId.from_obj = TEntityId_from_obj

TEntityId.proto_property = {'EntityId'}

TEntityId.default = {0}

TEntityId.struct = {{name = 'EntityId', is_array = false, struct = nil}}

function TEntityId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityId', self.EntityId, 'uint8', false, errs, need_convert)

    TEntityId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityId.proto_property, errs, need_convert)
    return self
end

function TEntityId:unpack(_)
    return self.EntityId
end

MDEASDR.EntityId = TEntityId

return MDEASDR
