-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBMCEnables = {}

---@class MBMCEnables.OEM2Enabled
---@field OEM2Enabled integer
local TOEM2Enabled = {}
TOEM2Enabled.__index = TOEM2Enabled
TOEM2Enabled.group = {}

local function TOEM2Enabled_from_obj(obj)
    return setmetatable(obj, TOEM2Enabled)
end

function TOEM2Enabled.new(OEM2Enabled)
    return TOEM2Enabled_from_obj({OEM2Enabled = OEM2Enabled or 0})
end
---@param obj MBMCEnables.OEM2Enabled
function TOEM2Enabled:init_from_obj(obj)
    self.OEM2Enabled = obj.OEM2Enabled or 0
end

function TOEM2Enabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEM2Enabled.group)
end

TOEM2Enabled.from_obj = TOEM2Enabled_from_obj

TOEM2Enabled.proto_property = {'OEM2Enabled'}

TOEM2Enabled.default = {0}

TOEM2Enabled.struct = {{name = 'OEM2Enabled', is_array = false, struct = nil}}

function TOEM2Enabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OEM2Enabled', self.OEM2Enabled, 'uint8', false, errs, need_convert)

    TOEM2Enabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEM2Enabled.proto_property, errs, need_convert)
    return self
end

function TOEM2Enabled:unpack(_)
    return self.OEM2Enabled
end

MBMCEnables.OEM2Enabled = TOEM2Enabled

---@class MBMCEnables.OEM1Enabled
---@field OEM1Enabled integer
local TOEM1Enabled = {}
TOEM1Enabled.__index = TOEM1Enabled
TOEM1Enabled.group = {}

local function TOEM1Enabled_from_obj(obj)
    return setmetatable(obj, TOEM1Enabled)
end

function TOEM1Enabled.new(OEM1Enabled)
    return TOEM1Enabled_from_obj({OEM1Enabled = OEM1Enabled or 0})
end
---@param obj MBMCEnables.OEM1Enabled
function TOEM1Enabled:init_from_obj(obj)
    self.OEM1Enabled = obj.OEM1Enabled or 0
end

function TOEM1Enabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEM1Enabled.group)
end

TOEM1Enabled.from_obj = TOEM1Enabled_from_obj

TOEM1Enabled.proto_property = {'OEM1Enabled'}

TOEM1Enabled.default = {0}

TOEM1Enabled.struct = {{name = 'OEM1Enabled', is_array = false, struct = nil}}

function TOEM1Enabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OEM1Enabled', self.OEM1Enabled, 'uint8', false, errs, need_convert)

    TOEM1Enabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEM1Enabled.proto_property, errs, need_convert)
    return self
end

function TOEM1Enabled:unpack(_)
    return self.OEM1Enabled
end

MBMCEnables.OEM1Enabled = TOEM1Enabled

---@class MBMCEnables.OEM0Enabled
---@field OEM0Enabled integer
local TOEM0Enabled = {}
TOEM0Enabled.__index = TOEM0Enabled
TOEM0Enabled.group = {}

local function TOEM0Enabled_from_obj(obj)
    return setmetatable(obj, TOEM0Enabled)
end

function TOEM0Enabled.new(OEM0Enabled)
    return TOEM0Enabled_from_obj({OEM0Enabled = OEM0Enabled or 0})
end
---@param obj MBMCEnables.OEM0Enabled
function TOEM0Enabled:init_from_obj(obj)
    self.OEM0Enabled = obj.OEM0Enabled or 0
end

function TOEM0Enabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEM0Enabled.group)
end

TOEM0Enabled.from_obj = TOEM0Enabled_from_obj

TOEM0Enabled.proto_property = {'OEM0Enabled'}

TOEM0Enabled.default = {0}

TOEM0Enabled.struct = {{name = 'OEM0Enabled', is_array = false, struct = nil}}

function TOEM0Enabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OEM0Enabled', self.OEM0Enabled, 'uint8', false, errs, need_convert)

    TOEM0Enabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEM0Enabled.proto_property, errs, need_convert)
    return self
end

function TOEM0Enabled:unpack(_)
    return self.OEM0Enabled
end

MBMCEnables.OEM0Enabled = TOEM0Enabled

---@class MBMCEnables.SELEnabled
---@field SELEnabled integer
local TSELEnabled = {}
TSELEnabled.__index = TSELEnabled
TSELEnabled.group = {}

local function TSELEnabled_from_obj(obj)
    return setmetatable(obj, TSELEnabled)
end

function TSELEnabled.new(SELEnabled)
    return TSELEnabled_from_obj({SELEnabled = SELEnabled or 1})
end
---@param obj MBMCEnables.SELEnabled
function TSELEnabled:init_from_obj(obj)
    self.SELEnabled = obj.SELEnabled or 1
end

function TSELEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSELEnabled.group)
end

TSELEnabled.from_obj = TSELEnabled_from_obj

TSELEnabled.proto_property = {'SELEnabled'}

TSELEnabled.default = {0}

TSELEnabled.struct = {{name = 'SELEnabled', is_array = false, struct = nil}}

function TSELEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SELEnabled', self.SELEnabled, 'uint8', false, errs, need_convert)

    TSELEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSELEnabled.proto_property, errs, need_convert)
    return self
end

function TSELEnabled:unpack(_)
    return self.SELEnabled
end

MBMCEnables.SELEnabled = TSELEnabled

---@class MBMCEnables.EvtMsgBufEnabled
---@field EvtMsgBufEnabled integer
local TEvtMsgBufEnabled = {}
TEvtMsgBufEnabled.__index = TEvtMsgBufEnabled
TEvtMsgBufEnabled.group = {}

local function TEvtMsgBufEnabled_from_obj(obj)
    return setmetatable(obj, TEvtMsgBufEnabled)
end

function TEvtMsgBufEnabled.new(EvtMsgBufEnabled)
    return TEvtMsgBufEnabled_from_obj({EvtMsgBufEnabled = EvtMsgBufEnabled or 1})
end
---@param obj MBMCEnables.EvtMsgBufEnabled
function TEvtMsgBufEnabled:init_from_obj(obj)
    self.EvtMsgBufEnabled = obj.EvtMsgBufEnabled or 1
end

function TEvtMsgBufEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvtMsgBufEnabled.group)
end

TEvtMsgBufEnabled.from_obj = TEvtMsgBufEnabled_from_obj

TEvtMsgBufEnabled.proto_property = {'EvtMsgBufEnabled'}

TEvtMsgBufEnabled.default = {0}

TEvtMsgBufEnabled.struct = {{name = 'EvtMsgBufEnabled', is_array = false, struct = nil}}

function TEvtMsgBufEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EvtMsgBufEnabled', self.EvtMsgBufEnabled, 'uint8', false, errs, need_convert)

    TEvtMsgBufEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvtMsgBufEnabled.proto_property, errs, need_convert)
    return self
end

function TEvtMsgBufEnabled:unpack(_)
    return self.EvtMsgBufEnabled
end

MBMCEnables.EvtMsgBufEnabled = TEvtMsgBufEnabled

---@class MBMCEnables.EvtMsgBufFullIntrptEnabled
---@field EvtMsgBufFullIntrptEnabled integer
local TEvtMsgBufFullIntrptEnabled = {}
TEvtMsgBufFullIntrptEnabled.__index = TEvtMsgBufFullIntrptEnabled
TEvtMsgBufFullIntrptEnabled.group = {}

local function TEvtMsgBufFullIntrptEnabled_from_obj(obj)
    return setmetatable(obj, TEvtMsgBufFullIntrptEnabled)
end

function TEvtMsgBufFullIntrptEnabled.new(EvtMsgBufFullIntrptEnabled)
    return TEvtMsgBufFullIntrptEnabled_from_obj({EvtMsgBufFullIntrptEnabled = EvtMsgBufFullIntrptEnabled or 1})
end
---@param obj MBMCEnables.EvtMsgBufFullIntrptEnabled
function TEvtMsgBufFullIntrptEnabled:init_from_obj(obj)
    self.EvtMsgBufFullIntrptEnabled = obj.EvtMsgBufFullIntrptEnabled or 1
end

function TEvtMsgBufFullIntrptEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEvtMsgBufFullIntrptEnabled.group)
end

TEvtMsgBufFullIntrptEnabled.from_obj = TEvtMsgBufFullIntrptEnabled_from_obj

TEvtMsgBufFullIntrptEnabled.proto_property = {'EvtMsgBufFullIntrptEnabled'}

TEvtMsgBufFullIntrptEnabled.default = {0}

TEvtMsgBufFullIntrptEnabled.struct = {{name = 'EvtMsgBufFullIntrptEnabled', is_array = false, struct = nil}}

function TEvtMsgBufFullIntrptEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EvtMsgBufFullIntrptEnabled', self.EvtMsgBufFullIntrptEnabled, 'uint8', false, errs,
        need_convert)

    TEvtMsgBufFullIntrptEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEvtMsgBufFullIntrptEnabled.proto_property, errs, need_convert)
    return self
end

function TEvtMsgBufFullIntrptEnabled:unpack(_)
    return self.EvtMsgBufFullIntrptEnabled
end

MBMCEnables.EvtMsgBufFullIntrptEnabled = TEvtMsgBufFullIntrptEnabled

---@class MBMCEnables.RecvMsgIntrptEnabled
---@field RecvMsgIntrptEnabled integer
local TRecvMsgIntrptEnabled = {}
TRecvMsgIntrptEnabled.__index = TRecvMsgIntrptEnabled
TRecvMsgIntrptEnabled.group = {}

local function TRecvMsgIntrptEnabled_from_obj(obj)
    return setmetatable(obj, TRecvMsgIntrptEnabled)
end

function TRecvMsgIntrptEnabled.new(RecvMsgIntrptEnabled)
    return TRecvMsgIntrptEnabled_from_obj({RecvMsgIntrptEnabled = RecvMsgIntrptEnabled or 1})
end
---@param obj MBMCEnables.RecvMsgIntrptEnabled
function TRecvMsgIntrptEnabled:init_from_obj(obj)
    self.RecvMsgIntrptEnabled = obj.RecvMsgIntrptEnabled or 1
end

function TRecvMsgIntrptEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecvMsgIntrptEnabled.group)
end

TRecvMsgIntrptEnabled.from_obj = TRecvMsgIntrptEnabled_from_obj

TRecvMsgIntrptEnabled.proto_property = {'RecvMsgIntrptEnabled'}

TRecvMsgIntrptEnabled.default = {0}

TRecvMsgIntrptEnabled.struct = {{name = 'RecvMsgIntrptEnabled', is_array = false, struct = nil}}

function TRecvMsgIntrptEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecvMsgIntrptEnabled', self.RecvMsgIntrptEnabled, 'uint8', false, errs, need_convert)

    TRecvMsgIntrptEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecvMsgIntrptEnabled.proto_property, errs, need_convert)
    return self
end

function TRecvMsgIntrptEnabled:unpack(_)
    return self.RecvMsgIntrptEnabled
end

MBMCEnables.RecvMsgIntrptEnabled = TRecvMsgIntrptEnabled

return MBMCEnables
