-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local threshold_sensor_class_types = require 'class.types.ThresholdSensor'
local discrete_sensor_class_types = require 'class.types.DiscreteSensor'
local entity_class_types = require 'class.types.Entity'
local discrete_event_class_types = require 'class.types.DiscreteEvent'
local ipmi_sel_desc_class_types = require 'class.types.IpmiSelDesc'
local ipmi_sel_filter_class_types = require 'class.types.IpmiSelFilter'
local ipmi_sel_list_class_types = require 'class.types.IpmiSelList'
local ipmi_sel_list_dump_class_types = require 'class.types.IpmiSelListDump'
local sensor_sel_info_class_types = require 'class.types.SensorSelInfo'
local ipmi_pef_config_class_types = require 'class.types.IpmiPefConfig'
local ipmi_pef_control_class_types = require 'class.types.IpmiPefControl'
local ipmi_pef_filter_class_types = require 'class.types.IpmiPefFilter'
local ipmi_pef_alert_filter_class_types = require 'class.types.IpmiPefAlertFilter'
local ipmi_pef_alert_string_class_types = require 'class.types.IpmiPefAlertString'
local sel_msg_list_class_types = require 'class.types.SelMsgList'
local persist_property_class_types = require 'class.types.PersistProperty'
local mcdlsdr_class_types = require 'class.types.MCDLSDR'
local deasdr_class_types = require 'class.types.DEASDR'
local bmc_enables_class_types = require 'class.types.BMCEnables'
local boot_error_class_types = require 'class.types.BootError'
local threshold_sensor_intf_types = require 'sensor.json_types.ThresholdSensor'
local threshold_sensor_display_intf_types = require 'sensor.json_types.ThresholdSensorDisplay'
local properties_intf_types = require 'sensor.json_types.Properties'
local sensors_intf_types = require 'sensor.json_types.Sensors'
local discrete_sensor_intf_types = require 'sensor.json_types.DiscreteSensor'
local discrete_sensor_display_intf_types = require 'sensor.json_types.DiscreteSensorDisplay'
local entity_intf_types = require 'sensor.json_types.Entity'
local discrete_event_intf_types = require 'sensor.json_types.DiscreteEvent'
local sensor_sel_info_intf_types = require 'sensor.json_types.SensorSelInfo'
local ipmi_event_intf_types = require 'sensor.json_types.IPMIEvent'

local ThresholdSensor = {
    ['prop_configs'] = {
        ['OwnerId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 32,
            ['description'] = '传感器归属标识，默认32（归属于BMC），来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.OwnerId
        },
        ['Initialization'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器初始化选项，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.Initialization
        },
        ['ReadingType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器读值类型，来自于IPMI规范，具体可以参考规范 42.1',
            ['validator'] = threshold_sensor_class_types.ReadingType
        },
        ['AssertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器事件发生掩码，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.AssertMask
        },
        ['DeassertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器事件恢复掩码，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.DeassertMask
        },
        ['Unit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器的表征单位，可以表征比率，修饰，百分比，具体参考 IPMI 规范 43.1',
            ['validator'] = threshold_sensor_class_types.Unit
        },
        ['BaseUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器基准单位，来自于IPMI规范，具体可以参考规范 43.17',
            ['validator'] = threshold_sensor_class_types.BaseUnit
        },
        ['ModifierUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器单位描述符，默认0，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.ModifierUnit
        },
        ['Linearization'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器线性计算方程，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.Linearization
        },
        ['M'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器M计算表达式低8bit，来自于IPMI规范，具体可以参考规范 36.3',
            ['validator'] = threshold_sensor_class_types.M
        },
        ['MT'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器M计算表达式高2bit和容差，来自于IPMI规范，具体可以参考规范 36.3',
            ['validator'] = threshold_sensor_class_types.MT
        },
        ['B'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器B计算表达式低8bit，来自于IPMI规范，具体可以参考规范 36.3',
            ['validator'] = threshold_sensor_class_types.B
        },
        ['BA'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器B计算表达式高2bit和准确率低6bit，来自于IPMI规范，具体可以参考规范 36.3',
            ['validator'] = threshold_sensor_class_types.BA
        },
        ['Accuracy'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器准确率高6bit和传感器方向，来自于IPMI规范，具体可以参考规范 36.3',
            ['validator'] = threshold_sensor_class_types.Accuracy
        },
        ['RBExp'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器R/B计算表达式，各4bit，来自于IPMI规范，具体可以参考规范 36.3',
            ['validator'] = threshold_sensor_class_types.RBExp
        },
        ['Analog'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 1,
            ['description'] = '传感器模拟标志，默认1，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.Analog
        },
        ['NominalReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器名义读值，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.NominalReading
        },
        ['NormalMaximum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器正常最大读值，默认0，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.NormalMaximum
        },
        ['NormalMinimum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器正常最小读值，默认0，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.NormalMinimum
        },
        ['MaximumReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器实际最大读值，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.MaximumReading
        },
        ['MinimumReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器实际最小读值，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = threshold_sensor_class_types.MinimumReading
        },
        ['BelongsToSystem'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['readOnly'] = true,
            ['description'] = '多Host场景表征当前对象是否归属单一系统，默认为公共对象（false），SystemId取0',
            ['validator'] = threshold_sensor_class_types.BelongsToSystem
        }
    },
    ['default_props'] = {
        ['OwnerId'] = 32,
        ['Initialization'] = 0,
        ['ReadingType'] = 0,
        ['AssertMask'] = 0,
        ['DeassertMask'] = 0,
        ['Unit'] = 0,
        ['BaseUnit'] = 0,
        ['ModifierUnit'] = 0,
        ['Linearization'] = 0,
        ['M'] = 0,
        ['MT'] = 0,
        ['B'] = 0,
        ['BA'] = 0,
        ['Accuracy'] = 0,
        ['RBExp'] = 0,
        ['Analog'] = 1,
        ['NominalReading'] = 0,
        ['NormalMaximum'] = 0,
        ['NormalMinimum'] = 0,
        ['MaximumReading'] = 0,
        ['MinimumReading'] = 0,
        ['BelongsToSystem'] = false
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.ThresholdSensor'] = {
            ['EntityId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器对应的实体，来自于IPMI规范，具体需要关联传感器对应的Entity.Id',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.EntityId
            },
            ['EntityInstance'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器对应的实体，来自于IPMI规范，具体需要关联传感器对应的Entity.Instance',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.EntityInstance
            },
            ['SensorIdentifier'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = '',
                ['description'] = '传感器标识',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorIdentifier
            },
            ['SensorName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = '',
                ['description'] = '传感器对外显示名称',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorName
            },
            ['Capabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['description'] = '传感器支持能力，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.Capabilities
            },
            ['SensorType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['description'] = '传感器类型，来自于IPMI规范，具体可以参考规范 42.2',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorType
            },
            ['ReadingMask'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['description'] = '传感器读值掩码，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.ReadingMask
            },
            ['UpperNonrecoverable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器紧急事件上限，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.UpperNonrecoverable
            },
            ['UpperCritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器严重事件上限，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.UpperCritical
            },
            ['UpperNoncritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器一般事件上限，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.UpperNoncritical
            },
            ['LowerNonrecoverable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器紧急事件下限，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.LowerNonrecoverable
            },
            ['LowerNoncritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器严重事件下限，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.LowerNoncritical
            },
            ['LowerCritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器一般事件下限，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.LowerCritical
            },
            ['PositiveHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器正向迟滞量，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.PositiveHysteresis
            },
            ['NegativeHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器负向迟滞量，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.NegativeHysteresis
            },
            ['SensorNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['description'] = '传感器编号，默认255，来自于IPMI规范，由BMC自行生成；如果需要特殊的编号，则需要单独在传感器定制化进行定制（BMC正常运行时插入的部件的传感器不支持定制）',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorNumber
            },
            ['OwnerLun'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '传感器的Lun，默认0，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.OwnerLun
            },
            ['Reading'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['default'] = 0,
                ['description'] = '传感器原始读值，引用传感器的数据源（如Scanner）读值同步，需要填写一个默认值，用于数据源未更新时显示，需要注意在门限之内，防止产生SEL事件',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.Reading
            },
            ['ReadingStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器读值状态，默认0，引用传感器的数据源（如Scanner）读值状态同步',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.ReadingStatus
            },
            ['OriginalReading'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器的原始值，当线型标志配置0x70-0x7f时，需要此属性配合Reading(固定配置170)计算传感器读数系数以提升读值精度至1w',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.OriginalReading
            }
        },
        ['bmc.kepler.Systems.ThresholdSensorDisplay'] = {
            ['UpperNonrecoverableDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器紧急门限上限可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.UpperNonrecoverableDisplay
            },
            ['UpperCriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器严重门限上限可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.UpperCriticalDisplay
            },
            ['UpperNoncriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器一般门限上限可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.UpperNoncriticalDisplay
            },
            ['LowerNonrecoverableDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器紧急门限下限可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.LowerNonrecoverableDisplay
            },
            ['LowerNoncriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器严重门限下限可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.LowerNoncriticalDisplay
            },
            ['LowerCriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器一般门限下限可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.LowerCriticalDisplay
            },
            ['PositiveHysteresisDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器正向迟滞量可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.PositiveHysteresisDisplay
            },
            ['NegativeHysteresisDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器负向迟滞量可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.NegativeHysteresisDisplay
            },
            ['ReadingDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器读值可读描述，精度3位有效数字',
                ['validator'] = threshold_sensor_display_intf_types.ReadingDisplay
            },
            ['UnitDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = '传感器单位可读描述',
                ['validator'] = threshold_sensor_display_intf_types.UnitDisplay
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '传感器当前状态：Enabled：传感器使能；Disabled：传感器禁用；InTest：传感器测试中；Starting：传感器更新中',
                ['validator'] = threshold_sensor_display_intf_types.Status
            },
            ['Health'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '传感器健康状态：Critical：紧急；Major：严重；Minor：一般；OK：正常',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_display_intf_types.Health
            },
            ['AssertStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器SEL事件状态，16进制的数，bit4 - bit15依次对应12种门限事件状态，1：Assert；0：Deassert',
                ['validator'] = threshold_sensor_display_intf_types.AssertStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/ThresholdSensors/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.ThresholdSensor'] = {
            ['property_defaults'] = {
                ['EntityId'] = 0,
                ['EntityInstance'] = 0,
                ['SensorIdentifier'] = '',
                ['SensorName'] = '',
                ['Capabilities'] = 0,
                ['SensorType'] = 0,
                ['ReadingMask'] = 0,
                ['UpperNonrecoverable'] = 0,
                ['UpperCritical'] = 0,
                ['UpperNoncritical'] = 0,
                ['LowerNonrecoverable'] = 0,
                ['LowerNoncritical'] = 0,
                ['LowerCritical'] = 0,
                ['PositiveHysteresis'] = 0,
                ['NegativeHysteresis'] = 0,
                ['SensorNumber'] = 255,
                ['OwnerLun'] = 0,
                ['Reading'] = 0,
                ['ReadingStatus'] = 0,
                ['OriginalReading'] = 0
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = threshold_sensor_intf_types
        },
        ['bmc.kepler.Systems.ThresholdSensorDisplay'] = {
            ['property_defaults'] = {
                ['UpperNonrecoverableDisplay'] = threshold_sensor_display_intf_types.UpperNonrecoverableDisplay.default[1],
                ['UpperCriticalDisplay'] = threshold_sensor_display_intf_types.UpperCriticalDisplay.default[1],
                ['UpperNoncriticalDisplay'] = threshold_sensor_display_intf_types.UpperNoncriticalDisplay.default[1],
                ['LowerNonrecoverableDisplay'] = threshold_sensor_display_intf_types.LowerNonrecoverableDisplay.default[1],
                ['LowerNoncriticalDisplay'] = threshold_sensor_display_intf_types.LowerNoncriticalDisplay.default[1],
                ['LowerCriticalDisplay'] = threshold_sensor_display_intf_types.LowerCriticalDisplay.default[1],
                ['PositiveHysteresisDisplay'] = threshold_sensor_display_intf_types.PositiveHysteresisDisplay.default[1],
                ['NegativeHysteresisDisplay'] = threshold_sensor_display_intf_types.NegativeHysteresisDisplay.default[1],
                ['ReadingDisplay'] = threshold_sensor_display_intf_types.ReadingDisplay.default[1],
                ['UnitDisplay'] = threshold_sensor_display_intf_types.UnitDisplay.default[1],
                ['Status'] = threshold_sensor_display_intf_types.Status.default[1],
                ['Health'] = threshold_sensor_display_intf_types.Health.default[1],
                ['AssertStatus'] = threshold_sensor_display_intf_types.AssertStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = threshold_sensor_display_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Sensors = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Sensors'] = {
            ['Health'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Normal',
                ['description'] = '系统健康状态,取值有0：Normal，1：Minor，2：Major，3：Critical',
                ['validator'] = sensors_intf_types.Health
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.Sensors'] = {
            ['GetThresholdSensorList'] = {
                ['description'] = '查询门限传感器列表',
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/ThresholdSensorItem'},
                        ['description'] = '门限传感器列表',
                        ['param'] = 'SensorList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['MockSensor'] = {
                ['description'] = '模拟传感器',
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['minimum'] = 0,
                        ['maximum'] = 1,
                        ['description'] = '是否使能模拟',
                        ['param'] = 'Enabled'
                    },
                    {['baseType'] = 'String', ['description'] = '模拟传感器的名称', ['param'] = 'SensorName'},
                    {
                        ['baseType'] = 'String',
                        ['description'] = '模拟传感器读值，stop是停止模拟',
                        ['param'] = 'Value'
                    }
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetSensorList'] = {
                ['description'] = '查询所有传感器列表',
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/AllSensorItem'},
                        ['description'] = '查询到的传感器列表',
                        ['param'] = 'SensorList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['SetSensorStatus'] = {
                ['description'] = '设置传感器使能状态',
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '传感器的名称', ['param'] = 'SensorName'},
                    {['baseType'] = 'String', ['description'] = '使能状态(enabled,disabled)', ['param'] = 'Status'}
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['ExportSel'] = {
                ['description'] = '导出传感器事件列表',
                ['req'] = {{['baseType'] = 'String', ['description'] = '导出sel的路径', ['param'] = 'Path'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'U32',
                        ['description'] = 'Task标识,用于拼接任务路径',
                        ['param'] = 'TaskId'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['GetSel'] = {
                ['description'] = '获取传感器事件列表',
                ['req'] = {
                    {['baseType'] = 'U16', ['description'] = '事件索引', ['param'] = 'StartId'},
                    {['baseType'] = 'U16', ['description'] = '事件条数', ['param'] = 'Count'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U16', ['description'] = '事件总条数', ['param'] = 'Total'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/SelInfo'},
                        ['description'] = '事件列表',
                        ['param'] = 'SelList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['GetDiscreteSensorList'] = {
                ['description'] = '查询离散传感器列表',
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DiscreteSensorItem'},
                        ['description'] = '离散传感器列表',
                        ['param'] = 'SensorList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['GetReportedSel'] = {
                ['description'] = '获取上报事件',
                ['req'] = {
                    {['baseType'] = 'U64', ['description'] = '事件起始序列号', ['param'] = 'StartId'},
                    {['baseType'] = 'U16', ['description'] = '事件条数', ['param'] = 'Count'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U16', ['description'] = '事件总条数', ['param'] = 'Total'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/SelInfo'},
                        ['description'] = '事件列表',
                        ['param'] = 'SelList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['DumpSDR'] = {
                ['description'] = '将SDR数据dump为二进制文件',
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'LAN', 'BT'},
                        ['description'] = 'SDR数据缓存模式，限定为 LAN/BT 两种模式',
                        ['param'] = 'DumpMode'
                    }
                },
                ['rsp'] = {},
                ['privilege'] = {'ReadOnly'}
            },
            ['AddOemSel'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '表征当前要添加的OEM SEL的类型',
                        ['param'] = 'RecordType'
                    },
                    {['baseType'] = 'U32', ['description'] = '表征当前SEL发生的时间', ['param'] = 'Timestamp'},
                    {
                        ['baseType'] = 'U32',
                        ['description'] = '表征当前SEL记录的厂商',
                        ['param'] = 'ManufactureID'
                    },
                    {
                        ['baseType'] = 'String',
                        ['description'] = '表征当前SEL记录的数据',
                        ['param'] = 'SELDatas'
                    }
                },
                ['rsp'] = {
                    {['baseType'] = 'U32', ['description'] = '当前OEM SEL数据记录id', ['param'] = 'RecordId'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['ClearSel'] = {
                ['description'] = '清空传感器事件',
                ['req'] = {},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Sensors'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Sensors'] = {
            ['property_defaults'] = {['Health'] = 'Normal'},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['GetThresholdSensorList'] = privilege.ReadOnly,
                    ['MockSensor'] = privilege.BasicSetting,
                    ['GetSensorList'] = privilege.ReadOnly,
                    ['SetSensorStatus'] = privilege.BasicSetting,
                    ['ExportSel'] = privilege.ReadOnly,
                    ['GetSel'] = privilege.ReadOnly,
                    ['GetDiscreteSensorList'] = privilege.ReadOnly,
                    ['GetReportedSel'] = privilege.ReadOnly,
                    ['DumpSDR'] = privilege.ReadOnly,
                    ['AddOemSel'] = privilege.BasicSetting,
                    ['ClearSel'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = sensors_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DiscreteSensor = {
    ['prop_configs'] = {
        ['Initialization'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器初始化选项，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = discrete_sensor_class_types.Initialization
        },
        ['SensorType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器类型，来自于IPMI规范，具体可以参考规范 42.2',
            ['validator'] = discrete_sensor_class_types.SensorType
        },
        ['ReadingType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器读值类型，来自于IPMI规范，具体可以参考规范 42.1',
            ['validator'] = discrete_sensor_class_types.ReadingType
        },
        ['AssertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器事件发生掩码，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = discrete_sensor_class_types.AssertMask
        },
        ['DeassertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器事件恢复掩码，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = discrete_sensor_class_types.DeassertMask
        },
        ['DiscreteMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器可以返回的离散值，具体参考 IPMI 规范 43.2',
            ['validator'] = discrete_sensor_class_types.DiscreteMask
        },
        ['DiscreteType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器离散类型，0：普通离散，1：数字离散，默认值为0，具体参考 IPMI 规范 42.1',
            ['validator'] = discrete_sensor_class_types.DiscreteType
        },
        ['Unit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器的表征单位，可以表征比率，修饰，百分比，具体参考 IPMI 规范 43.2',
            ['validator'] = discrete_sensor_class_types.Unit
        },
        ['BaseUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器基准单位，来自于IPMI规范，具体可以参考规范 43.17',
            ['validator'] = discrete_sensor_class_types.BaseUnit
        },
        ['ModifierUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器单位描述符，默认0，来自于IPMI规范，具体可以参考规范 43.1',
            ['validator'] = discrete_sensor_class_types.ModifierUnit
        },
        ['RecordSharing'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['description'] = '传感器的共享标识，多个传感器可以共享同一个SDR数据，具体参考 IPMI 规范 43.2',
            ['validator'] = discrete_sensor_class_types.RecordSharing
        },
        ['BelongsToSystem'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['readOnly'] = true,
            ['description'] = '多Host场景表征当前对象是否归属单一系统，默认为公共对象（false），SystemId取0',
            ['validator'] = discrete_sensor_class_types.BelongsToSystem
        }
    },
    ['default_props'] = {
        ['Initialization'] = 0,
        ['SensorType'] = 0,
        ['ReadingType'] = 0,
        ['AssertMask'] = 0,
        ['DeassertMask'] = 0,
        ['DiscreteMask'] = 0,
        ['DiscreteType'] = 0,
        ['Unit'] = 0,
        ['BaseUnit'] = 0,
        ['ModifierUnit'] = 0,
        ['RecordSharing'] = 0,
        ['BelongsToSystem'] = false
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.DiscreteSensor'] = {
            ['EntityId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器对应的实体，来自于IPMI规范，具体需要关联传感器对应的Entity.Id',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.EntityId
            },
            ['EntityInstance'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器对应的实体，来自于IPMI规范，具体需要关联传感器对应的Entity.Instance',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.EntityInstance
            },
            ['SensorIdentifier'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = '',
                ['description'] = '传感器标识',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.SensorIdentifier
            },
            ['OwnerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 32,
                ['description'] = '传感器归属标识，默认32（归属于BMC），来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.OwnerId
            },
            ['OwnerLun'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['description'] = '传感器的Lun，默认0，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.OwnerLun
            },
            ['Capabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['description'] = '传感器支持能力，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.Capabilities
            },
            ['SensorName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = '',
                ['description'] = '传感器对外显示的名称',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.SensorName
            },
            ['PositiveHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器正向迟滞量，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.PositiveHysteresis
            },
            ['NegativeHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器负向迟滞量，来自于IPMI规范，具体可以参考规范 43.1',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.NegativeHysteresis
            },
            ['Reading'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['description'] = '传感器原始读值，引用传感器的数据源（如Scanner）读值同步，需要填写一个默认值，用于数据源未更新时显示，需要注意在门限之内，防止产生SEL事件',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.Reading
            },
            ['SensorNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 255,
                ['description'] = '传感器编号，默认255，来自于IPMI规范，由BMC自行生成；如果需要特殊的编号，则需要单独在传感器定制化进行定制（BMC正常运行时插入的部件的传感器不支持定制）',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.SensorNumber
            }
        },
        ['bmc.kepler.Systems.DiscreteSensorDisplay'] = {
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器当前状态：Enabled：传感器使能；Disabled：传感器禁用；InTest：传感器测试中；Starting：传感器更新中',
                ['validator'] = discrete_sensor_display_intf_types.Status
            },
            ['Health'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '传感器健康状态：Critical：紧急；Major：严重；Minor：一般；OK：正常',
                ['validator'] = discrete_sensor_display_intf_types.Health
            },
            ['AssertStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '传感器SEL事件状态，bit0 - bit14依次对应15种offset的离散事件状态，1：Assert；0：Deassert',
                ['validator'] = discrete_sensor_display_intf_types.AssertStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/DiscreteSensors/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.DiscreteSensor'] = {
            ['property_defaults'] = {
                ['EntityId'] = 0,
                ['EntityInstance'] = 0,
                ['SensorIdentifier'] = '',
                ['OwnerId'] = 32,
                ['OwnerLun'] = 0,
                ['Capabilities'] = 0,
                ['SensorName'] = '',
                ['PositiveHysteresis'] = 0,
                ['NegativeHysteresis'] = 0,
                ['Reading'] = 0,
                ['SensorNumber'] = 255
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = discrete_sensor_intf_types
        },
        ['bmc.kepler.Systems.DiscreteSensorDisplay'] = {
            ['property_defaults'] = {
                ['Status'] = discrete_sensor_display_intf_types.Status.default[1],
                ['Health'] = discrete_sensor_display_intf_types.Health.default[1],
                ['AssertStatus'] = discrete_sensor_display_intf_types.AssertStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = discrete_sensor_display_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Entity = {
    ['prop_configs'] = {
        ['BelongsToSystem'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['readOnly'] = true,
            ['description'] = '多Host场景表征当前对象是否归属单一系统，默认为公共对象（false），SystemId取0',
            ['validator'] = entity_class_types.BelongsToSystem
        }
    },
    ['default_props'] = {['BelongsToSystem'] = false},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Entity'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'Entity Id，IPMI 规范 43.14',
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.Id
            },
            ['Instance'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'Entity Instance，IPMI 规范 43.1中描述Instance配置，默认值 96',
                ['usage'] = {'CSR'},
                ['default'] = 96,
                ['validator'] = entity_intf_types.Instance
            },
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = 'Entity所在的槽位号，默认 255',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = entity_intf_types.Slot
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = 'Entity的名称',
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.Name
            },
            ['PowerState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Entity的上下电状态，关联对应的上下电信号来源',
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.PowerState
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Entity的在位状态，关联对应的在位信号来源',
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.Presence
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'Entity的健康状态，不需要配置，默认值 0',
                ['validator'] = entity_intf_types.Health
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Entities/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Entity'] = {
            ['property_defaults'] = {
                ['Id'] = entity_intf_types.Id.default[1],
                ['Instance'] = 96,
                ['Slot'] = 255,
                ['Name'] = entity_intf_types.Name.default[1],
                ['PowerState'] = entity_intf_types.PowerState.default[1],
                ['Presence'] = entity_intf_types.Presence.default[1],
                ['Health'] = entity_intf_types.Health.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = entity_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DiscreteEvent = {
    ['prop_configs'] = {
        ['ListenType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['minimum'] = 0,
            ['maximum'] = 1,
            ['description'] = '离散事件监听类型：1 - 独立侦听，IPMI SEL的数据和方向来自于本对象属性； 0 - 组合侦听，IPMI SEL的数据和方向均来自于Property属性',
            ['validator'] = discrete_event_class_types.ListenType
        },
        ['EventData1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['description'] = '离散事件产生的数据1，当监听类型是独立侦听时使用，同时用来表征同一类型的离散传感器不同的离散状态方向，具体可以参考IPMI 规范 42.2',
            ['validator'] = discrete_event_class_types.EventData1
        },
        ['EventData2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['description'] = '离散事件产生的数据2，当监听类型是独立侦听时使用',
            ['validator'] = discrete_event_class_types.EventData2
        },
        ['EventData3'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['description'] = '离散事件产生的数据3，当监听类型是独立侦听时使用',
            ['validator'] = discrete_event_class_types.EventData3
        },
        ['Conversion'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['description'] = '离散事件翻转标识，高4bit用来组合侦听时EventData1的掩码，低4bit用来表征是否翻转：1 - 翻转；其他 - 不翻转',
            ['validator'] = discrete_event_class_types.Conversion
        },
        ['InvalidReadingIgnore'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['description'] = '离散事件是否忽略无效值(1:是，0:否)',
            ['validator'] = discrete_event_class_types.InvalidReadingIgnore
        },
        ['InvalidReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['description'] = '离散事件的无效值',
            ['validator'] = discrete_event_class_types.InvalidReading
        }
    },
    ['default_props'] = {
        ['ListenType'] = discrete_event_class_types.ListenType.default[1],
        ['EventData1'] = discrete_event_class_types.EventData1.default[1],
        ['EventData2'] = discrete_event_class_types.EventData2.default[1],
        ['EventData3'] = discrete_event_class_types.EventData3.default[1],
        ['Conversion'] = discrete_event_class_types.Conversion.default[1],
        ['InvalidReadingIgnore'] = discrete_event_class_types.InvalidReadingIgnore.default[1],
        ['InvalidReading'] = discrete_event_class_types.InvalidReading.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.DiscreteEvent'] = {
            ['Property'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '离散事件监听的属性，如果监听类型是组合侦听则代表 IPMI SEL产生使用的数据和方向',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_event_intf_types.Property
            },
            ['EventDir'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '离散事件产生的方向：0 - 恢复；其他 - 产生，当监听类型是独立侦听时使用',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_event_intf_types.EventDir
            },
            ['SensorObject'] = {
                ['baseType'] = 'String',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['readOnly'] = true,
                ['description'] = '离散事件关联的离散传感器，当IPMI SEL产生或者恢复时体现在当前传感器的健康状态以及SEL上',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_event_intf_types.SensorObject
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/DiscreteEvents/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.DiscreteEvent'] = {
            ['property_defaults'] = {
                ['Property'] = discrete_event_intf_types.Property.default[1],
                ['EventDir'] = discrete_event_intf_types.EventDir.default[1],
                ['SensorObject'] = discrete_event_intf_types.SensorObject.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = discrete_event_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local IpmiSelDesc = {
    ['table_name'] = 't_ipmi_sel_descs',
    ['prop_configs'] = {
        ['SensorType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件关联的传感器类型',
            ['validator'] = ipmi_sel_desc_class_types.SensorType
        },
        ['ReadingType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件关联的传感器读值类型',
            ['validator'] = ipmi_sel_desc_class_types.ReadingType
        },
        ['AlarmLevel'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL 对应事件的等级',
            ['validator'] = ipmi_sel_desc_class_types.AlarmLevel
        },
        ['SelDesc'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件描述',
            ['validator'] = ipmi_sel_desc_class_types.SelDesc
        },
        ['SelData1'] = {
            ['primaryKey'] = true,
            ['default'] = 255,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件描述第一个参数',
            ['validator'] = ipmi_sel_desc_class_types.SelData1
        },
        ['SelData2'] = {
            ['primaryKey'] = true,
            ['default'] = 255,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件描述第二个参数',
            ['validator'] = ipmi_sel_desc_class_types.SelData2
        },
        ['SelData3'] = {
            ['primaryKey'] = true,
            ['default'] = 255,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件描述第三个参数',
            ['validator'] = ipmi_sel_desc_class_types.SelData3
        },
        ['ShieldFlag'] = {
            ['default'] = 0,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件是否屏蔽标识',
            ['validator'] = ipmi_sel_desc_class_types.ShieldFlag
        }
    },
    ['default_props'] = {
        ['SensorType'] = ipmi_sel_desc_class_types.SensorType.default[1],
        ['ReadingType'] = ipmi_sel_desc_class_types.ReadingType.default[1],
        ['AlarmLevel'] = ipmi_sel_desc_class_types.AlarmLevel.default[1],
        ['SelDesc'] = ipmi_sel_desc_class_types.SelDesc.default[1],
        ['SelData1'] = 255,
        ['SelData2'] = 255,
        ['SelData3'] = 255,
        ['ShieldFlag'] = 0
    }
}

local IpmiSelFilter = {
    ['table_name'] = 't_ipmi_sel_filters',
    ['prop_configs'] = {
        ['SensorType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件关联的传感器类型',
            ['validator'] = ipmi_sel_filter_class_types.SensorType
        },
        ['ReadingType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件关联的传感器读值类型',
            ['validator'] = ipmi_sel_filter_class_types.ReadingType
        },
        ['FilterMask1'] = {
            ['primaryKey'] = true,
            ['default'] = 65535,
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件过滤掩码1，和IPMI SEL Data1相与为非零，则匹配成功',
            ['validator'] = ipmi_sel_filter_class_types.FilterMask1
        },
        ['FilterMask2'] = {
            ['default'] = 65535,
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件过滤掩码2，和IPMI SEL Data2相与为非零，则匹配成功',
            ['validator'] = ipmi_sel_filter_class_types.FilterMask2
        },
        ['FilterMask3'] = {
            ['default'] = 65535,
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件过滤掩码3，和IPMI SEL Data3相与为非零，则匹配成功',
            ['validator'] = ipmi_sel_filter_class_types.FilterMask3
        }
    },
    ['default_props'] = {
        ['SensorType'] = ipmi_sel_filter_class_types.SensorType.default[1],
        ['ReadingType'] = ipmi_sel_filter_class_types.ReadingType.default[1],
        ['FilterMask1'] = 65535,
        ['FilterMask2'] = 65535,
        ['FilterMask3'] = 65535
    }
}

local IpmiSelList = {
    ['table_name'] = 't_ipmi_sel_list',
    ['prop_configs'] = {
        ['RecordId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件记录标识，主键',
            ['validator'] = ipmi_sel_list_class_types.RecordId
        },
        ['SelType'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件类型',
            ['validator'] = ipmi_sel_list_class_types.SelType
        },
        ['Timestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['description'] = 'IPMI SEL事件产生时间',
            ['validator'] = ipmi_sel_list_class_types.Timestamp
        },
        ['GenerateId'] = {
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件生成标识',
            ['validator'] = ipmi_sel_list_class_types.GenerateId
        },
        ['SelMsgVersion'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件消息对应的版本号',
            ['validator'] = ipmi_sel_list_class_types.SelMsgVersion
        },
        ['SensorType'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件对应消息的传感器类型',
            ['validator'] = ipmi_sel_list_class_types.SensorType
        },
        ['SensorNumber'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件对应消息的传感器编号',
            ['validator'] = ipmi_sel_list_class_types.SensorNumber
        },
        ['SelEventType'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件对应的事件类型',
            ['validator'] = ipmi_sel_list_class_types.SelEventType
        },
        ['SelData1'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件数据1',
            ['validator'] = ipmi_sel_list_class_types.SelData1
        },
        ['SelData2'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件数据2',
            ['validator'] = ipmi_sel_list_class_types.SelData2
        },
        ['SelData3'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件数据3',
            ['validator'] = ipmi_sel_list_class_types.SelData3
        },
        ['SensorId'] = {
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件对应的传感器标识，更新SEL的传感器编号时使用',
            ['validator'] = ipmi_sel_list_class_types.SensorId
        },
        ['SensorName'] = {
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件对应消息的传感器名称',
            ['validator'] = ipmi_sel_list_class_types.SensorName
        },
        ['SubjectName'] = {
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件主体名称',
            ['validator'] = ipmi_sel_list_class_types.SubjectName
        },
        ['RecordSeq'] = {
            ['baseType'] = 'U64',
            ['description'] = '事件记录标识，随着事件产生递增',
            ['validator'] = ipmi_sel_list_class_types.RecordSeq
        }
    },
    ['default_props'] = {
        ['RecordId'] = ipmi_sel_list_class_types.RecordId.default[1],
        ['SelType'] = ipmi_sel_list_class_types.SelType.default[1],
        ['Timestamp'] = ipmi_sel_list_class_types.Timestamp.default[1],
        ['GenerateId'] = ipmi_sel_list_class_types.GenerateId.default[1],
        ['SelMsgVersion'] = ipmi_sel_list_class_types.SelMsgVersion.default[1],
        ['SensorType'] = ipmi_sel_list_class_types.SensorType.default[1],
        ['SensorNumber'] = ipmi_sel_list_class_types.SensorNumber.default[1],
        ['SelEventType'] = ipmi_sel_list_class_types.SelEventType.default[1],
        ['SelData1'] = ipmi_sel_list_class_types.SelData1.default[1],
        ['SelData2'] = ipmi_sel_list_class_types.SelData2.default[1],
        ['SelData3'] = ipmi_sel_list_class_types.SelData3.default[1],
        ['SensorId'] = ipmi_sel_list_class_types.SensorId.default[1],
        ['SensorName'] = ipmi_sel_list_class_types.SensorName.default[1],
        ['SubjectName'] = ipmi_sel_list_class_types.SubjectName.default[1],
        ['RecordSeq'] = ipmi_sel_list_class_types.RecordSeq.default[1]
    }
}

local IpmiSelListDump = {
    ['table_name'] = 't_ipmi_sel_list_dump',
    ['prop_configs'] = {
        ['RecordId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件记录标识，主键',
            ['validator'] = ipmi_sel_list_dump_class_types.RecordId
        },
        ['SelType'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件类型',
            ['validator'] = ipmi_sel_list_dump_class_types.SelType
        },
        ['Timestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['description'] = 'IPMI SEL事件产生时间',
            ['validator'] = ipmi_sel_list_dump_class_types.Timestamp
        },
        ['GenerateId'] = {
            ['baseType'] = 'U16',
            ['description'] = 'IPMI SEL事件生成标识',
            ['validator'] = ipmi_sel_list_dump_class_types.GenerateId
        },
        ['SelMsgVersion'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件消息对应的版本号',
            ['validator'] = ipmi_sel_list_dump_class_types.SelMsgVersion
        },
        ['SensorType'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件对应消息的传感器类型',
            ['validator'] = ipmi_sel_list_dump_class_types.SensorType
        },
        ['SensorNumber'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件对应消息的传感器编号',
            ['validator'] = ipmi_sel_list_dump_class_types.SensorNumber
        },
        ['SelEventType'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件对应的事件类型',
            ['validator'] = ipmi_sel_list_dump_class_types.SelEventType
        },
        ['SelData1'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件数据1',
            ['validator'] = ipmi_sel_list_dump_class_types.SelData1
        },
        ['SelData2'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件数据2',
            ['validator'] = ipmi_sel_list_dump_class_types.SelData2
        },
        ['SelData3'] = {
            ['baseType'] = 'U8',
            ['description'] = 'IPMI SEL事件数据3',
            ['validator'] = ipmi_sel_list_dump_class_types.SelData3
        },
        ['SensorId'] = {
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件对应的传感器标识，更新SEL的传感器编号时使用',
            ['validator'] = ipmi_sel_list_dump_class_types.SensorId
        },
        ['SensorName'] = {
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件对应消息的传感器名称',
            ['validator'] = ipmi_sel_list_dump_class_types.SensorName
        },
        ['SubjectName'] = {
            ['baseType'] = 'String',
            ['description'] = 'IPMI SEL事件主体名称',
            ['validator'] = ipmi_sel_list_dump_class_types.SubjectName
        },
        ['RecordSeq'] = {
            ['baseType'] = 'U64',
            ['description'] = '事件记录标识，随着事件产生递增',
            ['validator'] = ipmi_sel_list_dump_class_types.RecordSeq
        }
    },
    ['default_props'] = {
        ['RecordId'] = ipmi_sel_list_dump_class_types.RecordId.default[1],
        ['SelType'] = ipmi_sel_list_dump_class_types.SelType.default[1],
        ['Timestamp'] = ipmi_sel_list_dump_class_types.Timestamp.default[1],
        ['GenerateId'] = ipmi_sel_list_dump_class_types.GenerateId.default[1],
        ['SelMsgVersion'] = ipmi_sel_list_dump_class_types.SelMsgVersion.default[1],
        ['SensorType'] = ipmi_sel_list_dump_class_types.SensorType.default[1],
        ['SensorNumber'] = ipmi_sel_list_dump_class_types.SensorNumber.default[1],
        ['SelEventType'] = ipmi_sel_list_dump_class_types.SelEventType.default[1],
        ['SelData1'] = ipmi_sel_list_dump_class_types.SelData1.default[1],
        ['SelData2'] = ipmi_sel_list_dump_class_types.SelData2.default[1],
        ['SelData3'] = ipmi_sel_list_dump_class_types.SelData3.default[1],
        ['SensorId'] = ipmi_sel_list_dump_class_types.SensorId.default[1],
        ['SensorName'] = ipmi_sel_list_dump_class_types.SensorName.default[1],
        ['SubjectName'] = ipmi_sel_list_dump_class_types.SubjectName.default[1],
        ['RecordSeq'] = ipmi_sel_list_dump_class_types.RecordSeq.default[1]
    }
}

local SensorSelInfo = {
    ['table_name'] = 't_sel_info',
    ['prop_configs'] = {
        ['CurRecordId'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['description'] = '持久化复位之前记录的RecordId',
            ['validator'] = sensor_sel_info_class_types.CurRecordId
        },
        ['QueryMaxCount'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U16',
            ['default'] = 2000,
            ['usage'] = {'CSR'},
            ['description'] = 'SEL 支持 IPMI 查询的最大记录数，默认 2000',
            ['validator'] = sensor_sel_info_class_types.QueryMaxCount
        },
        ['AddTimestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['usage'] = {'CSR'},
            ['description'] = 'SEL 添加的时间戳，默认 0xFFFFFFFF',
            ['validator'] = sensor_sel_info_class_types.AddTimestamp
        },
        ['DelTimestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['usage'] = {'CSR'},
            ['description'] = 'SEL 删除的时间戳，默认 0xFFFFFFFF',
            ['validator'] = sensor_sel_info_class_types.DelTimestamp
        },
        ['ReceiverAddr'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['usage'] = {'CSR'},
            ['description'] = '接收sensor事件上报的地址，默认 0xFF',
            ['validator'] = sensor_sel_info_class_types.ReceiverAddr
        },
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = '持久化数据主键，无实际意义，由于配置数据只有1条，因此采用默认值配置',
            ['validator'] = sensor_sel_info_class_types.Id
        }
    },
    ['default_props'] = {
        ['CurRecordId'] = 0,
        ['QueryMaxCount'] = 2000,
        ['AddTimestamp'] = 4294967295,
        ['DelTimestamp'] = 4294967295,
        ['ReceiverAddr'] = 255,
        ['Id'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.SensorSelInfo'] = {
            ['SelMode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['description'] = 'SEL 记录的模式：0: 默认模式，记录达到最大数量后清空; 1: 记录达到最大数量后滚动',
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['notAllowNull'] = true,
                ['validator'] = sensor_sel_info_intf_types.SelMode
            },
            ['RecordSeq'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['description'] = '当前事件的序列号，随着事件产生无限递增',
                ['notAllowNull'] = true,
                ['validator'] = sensor_sel_info_intf_types.RecordSeq
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/SensorSelInfo'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.SensorSelInfo'] = {
            ['property_defaults'] = {
                ['SelMode'] = sensor_sel_info_intf_types.SelMode.default[1],
                ['RecordSeq'] = sensor_sel_info_intf_types.RecordSeq.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['SelMode'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}}
            },
            ['interface_types'] = sensor_sel_info_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local IpmiPefConfig = {
    ['table_name'] = 't_pef_config',
    ['prop_configs'] = {
        ['Enabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 配置使能',
            ['validator'] = ipmi_pef_config_class_types.Enabled
        },
        ['ActionEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Action 使能',
            ['validator'] = ipmi_pef_config_class_types.ActionEnabled
        },
        ['StartupDelayDisabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Startup Delay 禁止',
            ['validator'] = ipmi_pef_config_class_types.StartupDelayDisabled
        },
        ['AlertStartupDelayDisabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'SPEF Alert Startup Delay 禁止',
            ['validator'] = ipmi_pef_config_class_types.AlertStartupDelayDisabled
        },
        ['AlertEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Alert 使能',
            ['validator'] = ipmi_pef_config_class_types.AlertEnabled
        },
        ['PowerOffEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF PowerOff 使能',
            ['validator'] = ipmi_pef_config_class_types.PowerOffEnabled
        },
        ['ResetEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Reset 使能',
            ['validator'] = ipmi_pef_config_class_types.ResetEnabled
        },
        ['PowerCycleEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF PowerCycle 使能',
            ['validator'] = ipmi_pef_config_class_types.PowerCycleEnabled
        },
        ['OEMEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF OEM 使能',
            ['validator'] = ipmi_pef_config_class_types.OEMEnabled
        },
        ['DiagInterruptEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Diagnostic Interrupt 使能',
            ['validator'] = ipmi_pef_config_class_types.DiagInterruptEnabled
        },
        ['SystemGUIDEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF System GUID 使能',
            ['validator'] = ipmi_pef_config_class_types.SystemGUIDEnabled
        },
        ['StartupDelay'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Startup Delay 配置值',
            ['validator'] = ipmi_pef_config_class_types.StartupDelay
        },
        ['AlertStartupDelay'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Alert Startup Delay 配置值',
            ['validator'] = ipmi_pef_config_class_types.AlertStartupDelay
        },
        ['SystemGUID'] = {
            ['baseType'] = 'String',
            ['default'] = '000000000000000000',
            ['usage'] = {'CSR'},
            ['description'] = 'PEF System GUID',
            ['validator'] = ipmi_pef_config_class_types.SystemGUID
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = '持久化数据主键，无实际意义，由于配置数据只有1条，因此采用默认值配置',
            ['validator'] = ipmi_pef_config_class_types.Id
        }
    },
    ['default_props'] = {
        ['Enabled'] = 1,
        ['ActionEnabled'] = 0,
        ['StartupDelayDisabled'] = 0,
        ['AlertStartupDelayDisabled'] = 0,
        ['AlertEnabled'] = 1,
        ['PowerOffEnabled'] = 1,
        ['ResetEnabled'] = 1,
        ['PowerCycleEnabled'] = 1,
        ['OEMEnabled'] = 0,
        ['DiagInterruptEnabled'] = 0,
        ['SystemGUIDEnabled'] = 0,
        ['StartupDelay'] = 0,
        ['AlertStartupDelay'] = 0,
        ['SystemGUID'] = '000000000000000000',
        ['Id'] = 1
    }
}

local IpmiPefControl = {
    ['table_name'] = 't_pef_control',
    ['prop_configs'] = {
        ['InProgress'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 配置设置进度',
            ['validator'] = ipmi_pef_control_class_types.InProgress
        },
        ['PostponeTimeout'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 推迟超时时间',
            ['validator'] = ipmi_pef_control_class_types.PostponeTimeout
        },
        ['StartupDelayTID'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Startup Delay 时间戳',
            ['validator'] = ipmi_pef_control_class_types.StartupDelayTID
        },
        ['Action'] = {
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF Action',
            ['validator'] = ipmi_pef_control_class_types.Action
        },
        ['UnqueuedEvent'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 最后一个已经处理的事件标识',
            ['validator'] = ipmi_pef_control_class_types.UnqueuedEvent
        },
        ['LastEventBMC'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 处理的上一个BMC事件标识',
            ['validator'] = ipmi_pef_control_class_types.LastEventBMC
        },
        ['LastEventSMS'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 处理的上一个SMS事件标识',
            ['validator'] = ipmi_pef_control_class_types.LastEventSMS
        },
        ['NextEvent'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = 'PEF 需要处理的下一个事件标识',
            ['validator'] = ipmi_pef_control_class_types.NextEvent
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['description'] = '持久化数据主键，无实际意义，由于配置数据只有1条，因此采用默认值配置',
            ['validator'] = ipmi_pef_control_class_types.Id
        }
    },
    ['default_props'] = {
        ['InProgress'] = 0,
        ['PostponeTimeout'] = 0,
        ['StartupDelayTID'] = 0,
        ['Action'] = 0,
        ['UnqueuedEvent'] = 0,
        ['LastEventBMC'] = 0,
        ['LastEventSMS'] = 0,
        ['NextEvent'] = 0,
        ['Id'] = 1
    }
}

local IpmiPefFilter = {
    ['prop_configs'] = {
        ['Configuration'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Configuration
        },
        ['Action'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ipmi_pef_filter_class_types.Action},
        ['PolicyNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.PolicyNumber
        },
        ['Severity'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ipmi_pef_filter_class_types.Severity},
        ['GeneratorId1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.GeneratorId1
        },
        ['GeneratorId2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.GeneratorId2
        },
        ['SensorType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.SensorType
        },
        ['SensorNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.SensorNumber
        },
        ['EventTrigger'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.EventTrigger
        },
        ['OffsetMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['validator'] = ipmi_pef_filter_class_types.OffsetMask
        },
        ['Event1AndMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event1AndMask
        },
        ['Event1Compare1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event1Compare1
        },
        ['Event1Compare2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event1Compare2
        },
        ['Event2AndMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event2AndMask
        },
        ['Event2Compare1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event2Compare1
        },
        ['Event2Compare2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event2Compare2
        },
        ['Event3AndMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event3AndMask
        },
        ['Event3Compare1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event3Compare1
        },
        ['Event3Compare2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event3Compare2
        }
    },
    ['default_props'] = {
        ['Configuration'] = ipmi_pef_filter_class_types.Configuration.default[1],
        ['Action'] = ipmi_pef_filter_class_types.Action.default[1],
        ['PolicyNumber'] = ipmi_pef_filter_class_types.PolicyNumber.default[1],
        ['Severity'] = ipmi_pef_filter_class_types.Severity.default[1],
        ['GeneratorId1'] = ipmi_pef_filter_class_types.GeneratorId1.default[1],
        ['GeneratorId2'] = ipmi_pef_filter_class_types.GeneratorId2.default[1],
        ['SensorType'] = ipmi_pef_filter_class_types.SensorType.default[1],
        ['SensorNumber'] = ipmi_pef_filter_class_types.SensorNumber.default[1],
        ['EventTrigger'] = ipmi_pef_filter_class_types.EventTrigger.default[1],
        ['OffsetMask'] = ipmi_pef_filter_class_types.OffsetMask.default[1],
        ['Event1AndMask'] = ipmi_pef_filter_class_types.Event1AndMask.default[1],
        ['Event1Compare1'] = ipmi_pef_filter_class_types.Event1Compare1.default[1],
        ['Event1Compare2'] = ipmi_pef_filter_class_types.Event1Compare2.default[1],
        ['Event2AndMask'] = ipmi_pef_filter_class_types.Event2AndMask.default[1],
        ['Event2Compare1'] = ipmi_pef_filter_class_types.Event2Compare1.default[1],
        ['Event2Compare2'] = ipmi_pef_filter_class_types.Event2Compare2.default[1],
        ['Event3AndMask'] = ipmi_pef_filter_class_types.Event3AndMask.default[1],
        ['Event3Compare1'] = ipmi_pef_filter_class_types.Event3Compare1.default[1],
        ['Event3Compare2'] = ipmi_pef_filter_class_types.Event3Compare2.default[1]
    }
}

local IpmiPefAlertFilter = {
    ['prop_configs'] = {
        ['PolicyNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_filter_class_types.PolicyNum
        },
        ['Destination'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_filter_class_types.Destination
        },
        ['AlertString'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_filter_class_types.AlertString
        }
    },
    ['default_props'] = {
        ['PolicyNum'] = ipmi_pef_alert_filter_class_types.PolicyNum.default[1],
        ['Destination'] = ipmi_pef_alert_filter_class_types.Destination.default[1],
        ['AlertString'] = ipmi_pef_alert_filter_class_types.AlertString.default[1]
    }
}

local IpmiPefAlertString = {
    ['prop_configs'] = {
        ['Id'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ipmi_pef_alert_string_class_types.Id},
        ['FilterNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_string_class_types.FilterNumber
        },
        ['StringSet'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_string_class_types.StringSet
        },
        ['AlertString'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = ipmi_pef_alert_string_class_types.AlertString
        }
    },
    ['default_props'] = {
        ['Id'] = ipmi_pef_alert_string_class_types.Id.default[1],
        ['FilterNumber'] = ipmi_pef_alert_string_class_types.FilterNumber.default[1],
        ['StringSet'] = ipmi_pef_alert_string_class_types.StringSet.default[1],
        ['AlertString'] = ipmi_pef_alert_string_class_types.AlertString.default[1]
    }
}

local SelMsgList = {
    ['table_name'] = 't_sel_msg_list',
    ['prop_configs'] = {
        ['SensorId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['description'] = '事件对应的传感器标识，联合主键',
            ['validator'] = sel_msg_list_class_types.SensorId
        },
        ['EventMsgVersion'] = {
            ['baseType'] = 'U8',
            ['description'] = '事件的版本号',
            ['validator'] = sel_msg_list_class_types.EventMsgVersion
        },
        ['SensorType'] = {
            ['baseType'] = 'U8',
            ['description'] = '事件对应的传感器类型',
            ['validator'] = sel_msg_list_class_types.SensorType
        },
        ['SensorNumber'] = {
            ['baseType'] = 'U8',
            ['description'] = '事件对应的传感器编号',
            ['validator'] = sel_msg_list_class_types.SensorNumber
        },
        ['EventType'] = {
            ['baseType'] = 'U8',
            ['description'] = '事件对应的事件类型',
            ['validator'] = sel_msg_list_class_types.EventType
        },
        ['EventDir'] = {
            ['baseType'] = 'U8',
            ['description'] = '事件产生的方向',
            ['validator'] = sel_msg_list_class_types.EventDir
        },
        ['EventData1'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['description'] = '事件数据1，联合主键',
            ['validator'] = sel_msg_list_class_types.EventData1
        },
        ['EventData2'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['description'] = '事件数据2，联合主键',
            ['validator'] = sel_msg_list_class_types.EventData2
        },
        ['EventData3'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['description'] = '事件数据3，联合主键',
            ['validator'] = sel_msg_list_class_types.EventData3
        },
        ['Level'] = {
            ['baseType'] = 'U8',
            ['description'] = '事件严重等级',
            ['validator'] = sel_msg_list_class_types.Level
        }
    },
    ['default_props'] = {
        ['SensorId'] = sel_msg_list_class_types.SensorId.default[1],
        ['EventMsgVersion'] = sel_msg_list_class_types.EventMsgVersion.default[1],
        ['SensorType'] = sel_msg_list_class_types.SensorType.default[1],
        ['SensorNumber'] = sel_msg_list_class_types.SensorNumber.default[1],
        ['EventType'] = sel_msg_list_class_types.EventType.default[1],
        ['EventDir'] = sel_msg_list_class_types.EventDir.default[1],
        ['EventData1'] = sel_msg_list_class_types.EventData1.default[1],
        ['EventData2'] = sel_msg_list_class_types.EventData2.default[1],
        ['EventData3'] = sel_msg_list_class_types.EventData3.default[1],
        ['Level'] = sel_msg_list_class_types.Level.default[1]
    }
}

local PersistProperty = {
    ['table_name'] = 't_persist_property',
    ['prop_configs'] = {
        ['PerId'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = persist_property_class_types.PerId},
        ['Key'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = persist_property_class_types.Key},
        ['Value'] = {['baseType'] = 'String', ['validator'] = persist_property_class_types.Value}
    },
    ['default_props'] = {
        ['PerId'] = persist_property_class_types.PerId.default[1],
        ['Key'] = persist_property_class_types.Key.default[1],
        ['Value'] = persist_property_class_types.Value.default[1]
    }
}

local MCDLSDR = {
    ['prop_configs'] = {
        ['SlaveAddr'] = {
            ['baseType'] = 'U8',
            ['default'] = 32,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的从地址，默认 0x20',
            ['validator'] = mcdlsdr_class_types.SlaveAddr
        },
        ['Channel'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的通道，低 4bit 有效，默认 0x00',
            ['validator'] = mcdlsdr_class_types.Channel
        },
        ['PowerStateInitialization'] = {
            ['baseType'] = 'U8',
            ['default'] = 128,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的上电状态（高 3bit）和全局初始化选项（ 低4bit ），默认 0x80',
            ['validator'] = mcdlsdr_class_types.PowerStateInitialization
        },
        ['Capabilities'] = {
            ['baseType'] = 'U8',
            ['default'] = 45,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的属性，默认 0x2D',
            ['validator'] = mcdlsdr_class_types.Capabilities
        },
        ['EntityId'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的设备实体标识',
            ['validator'] = mcdlsdr_class_types.EntityId
        },
        ['EntityInstance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的设备实体实例标识',
            ['validator'] = mcdlsdr_class_types.EntityInstance
        },
        ['DeviceName'] = {
            ['baseType'] = 'String',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的具体名称，最长 16',
            ['validator'] = mcdlsdr_class_types.DeviceName
        }
    },
    ['default_props'] = {
        ['SlaveAddr'] = 32,
        ['Channel'] = 0,
        ['PowerStateInitialization'] = 128,
        ['Capabilities'] = 45,
        ['EntityId'] = mcdlsdr_class_types.EntityId.default[1],
        ['EntityInstance'] = mcdlsdr_class_types.EntityInstance.default[1],
        ['DeviceName'] = mcdlsdr_class_types.DeviceName.default[1]
    }
}

local DEASDR = {
    ['prop_configs'] = {
        ['EntityId'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的实体标识',
            ['validator'] = deasdr_class_types.EntityId
        },
        ['EntityInstance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的实体实例',
            ['validator'] = deasdr_class_types.EntityInstance
        },
        ['Address'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的从地址，如果是相对地址，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Address
        },
        ['Channel'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备的通道，如果是相对通道，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Channel
        },
        ['Flags'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的设备标记，bit7的取值：0 - 使用列表的方式关联实体；1 - 使用范围的方式关联实体',
            ['validator'] = deasdr_class_types.Flags
        },
        ['Address1'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 1 个设备实体标识，如果是相对地址，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Address1
        },
        ['Channel1'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 1 个设备实体通道，如果是相对通道，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Channel1
        },
        ['Entity1Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 1 个设备实体标识',
            ['validator'] = deasdr_class_types.Entity1Id
        },
        ['Entity1Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 1 个设备实体实例',
            ['validator'] = deasdr_class_types.Entity1Instance
        },
        ['Address2'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 2 个设备实体标识，如果是相对地址，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Address2
        },
        ['Channel2'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 2 个设备实体通道，如果是相对通道，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Channel2
        },
        ['Entity2Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 2 个设备实体标识',
            ['validator'] = deasdr_class_types.Entity2Id
        },
        ['Entity2Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 2 个设备实体实例',
            ['validator'] = deasdr_class_types.Entity2Instance
        },
        ['Address3'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 3 个设备实体标识，如果是相对地址，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Address3
        },
        ['Channel3'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 3 个设备实体通道，如果是相对通道，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Channel3
        },
        ['Entity3Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 3 个设备实体标识',
            ['validator'] = deasdr_class_types.Entity3Id
        },
        ['Entity3Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 3 个设备实体实例',
            ['validator'] = deasdr_class_types.Entity3Instance
        },
        ['Address4'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 4 个设备实体标识，如果是相对地址，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Address4
        },
        ['Channel4'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 4 个设备实体通道，如果是相对通道，则直接填写0，默认为0',
            ['validator'] = deasdr_class_types.Channel4
        },
        ['Entity4Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 4 个设备实体标识',
            ['validator'] = deasdr_class_types.Entity4Id
        },
        ['Entity4Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['description'] = '管理设备关联的第 4 个设备实体实例',
            ['validator'] = deasdr_class_types.Entity4Instance
        }
    },
    ['default_props'] = {
        ['EntityId'] = deasdr_class_types.EntityId.default[1],
        ['EntityInstance'] = deasdr_class_types.EntityInstance.default[1],
        ['Address'] = 0,
        ['Channel'] = 0,
        ['Flags'] = deasdr_class_types.Flags.default[1],
        ['Address1'] = 0,
        ['Channel1'] = 0,
        ['Entity1Id'] = deasdr_class_types.Entity1Id.default[1],
        ['Entity1Instance'] = deasdr_class_types.Entity1Instance.default[1],
        ['Address2'] = 0,
        ['Channel2'] = 0,
        ['Entity2Id'] = deasdr_class_types.Entity2Id.default[1],
        ['Entity2Instance'] = deasdr_class_types.Entity2Instance.default[1],
        ['Address3'] = 0,
        ['Channel3'] = 0,
        ['Entity3Id'] = deasdr_class_types.Entity3Id.default[1],
        ['Entity3Instance'] = deasdr_class_types.Entity3Instance.default[1],
        ['Address4'] = 0,
        ['Channel4'] = 0,
        ['Entity4Id'] = deasdr_class_types.Entity4Id.default[1],
        ['Entity4Instance'] = deasdr_class_types.Entity4Instance.default[1]
    }
}

local BMCEnables = {
    ['prop_configs'] = {
        ['RecvMsgIntrptEnabled'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['default'] = 1,
            ['description'] = 'BMC 到 Host 侧消息中断使能',
            ['validator'] = bmc_enables_class_types.RecvMsgIntrptEnabled
        },
        ['EvtMsgBufFullIntrptEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['description'] = 'BMC 消息缓冲区充满中断使能',
            ['validator'] = bmc_enables_class_types.EvtMsgBufFullIntrptEnabled
        },
        ['EvtMsgBufEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['description'] = 'BMC 消息缓冲区使能',
            ['validator'] = bmc_enables_class_types.EvtMsgBufEnabled
        },
        ['SELEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['description'] = 'BMC 记录SEL使能',
            ['validator'] = bmc_enables_class_types.SELEnabled
        },
        ['OEM0Enabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['description'] = 'BMC 自定义厂商0使能',
            ['validator'] = bmc_enables_class_types.OEM0Enabled
        },
        ['OEM1Enabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['description'] = 'BMC 自定义厂商1使能',
            ['validator'] = bmc_enables_class_types.OEM1Enabled
        },
        ['OEM2Enabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['description'] = 'BMC 自定义厂商2使能',
            ['validator'] = bmc_enables_class_types.OEM2Enabled
        }
    },
    ['default_props'] = {
        ['RecvMsgIntrptEnabled'] = 1,
        ['EvtMsgBufFullIntrptEnabled'] = 1,
        ['EvtMsgBufEnabled'] = 1,
        ['SELEnabled'] = 1,
        ['OEM0Enabled'] = 0,
        ['OEM1Enabled'] = 0,
        ['OEM2Enabled'] = 0
    }
}

local BootError = {
    ['table_name'] = 't_boot_error',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['primaryKey'] = true,
            ['usage'] = {'CSR'},
            ['description'] = 'BIOS 上报事件的持久化主键，无实际意义',
            ['validator'] = boot_error_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPMIEvent'] = {
            ['SensorType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = 'IPMI 事件的传感器类型',
                ['usage'] = {'CSR'},
                ['default'] = 30,
                ['validator'] = ipmi_event_intf_types.SensorType
            },
            ['ReadingType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'IPMI 事件的事件读值类型，复位持久化，事件类型来自于HOST侧上报',
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 111,
                ['validator'] = ipmi_event_intf_types.ReadingType
            },
            ['EventData'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = 'IPMI 事件的SEL数据，复位持久化，事件数据来自于HOST侧上报或者HOST上下电状态变化感知',
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 4294967295,
                ['validator'] = ipmi_event_intf_types.EventData
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/EventEntries/BootError'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPMIEvent'] = {
            ['property_defaults'] = {['SensorType'] = 30, ['ReadingType'] = 111, ['EventData'] = 4294967295},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = ipmi_event_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('ThresholdSensor', ThresholdSensor):set_bus(bus)
    class('Sensors', Sensors):set_bus(bus)
    class('DiscreteSensor', DiscreteSensor):set_bus(bus)
    class('Entity', Entity):set_bus(bus)
    class('DiscreteEvent', DiscreteEvent):set_bus(bus)
    class('IpmiSelDesc', IpmiSelDesc):set_bus(bus)
    class('IpmiSelFilter', IpmiSelFilter):set_bus(bus)
    class('IpmiSelList', IpmiSelList):set_bus(bus)
    class('IpmiSelListDump', IpmiSelListDump):set_bus(bus)
    class('SensorSelInfo', SensorSelInfo):set_bus(bus)
    class('IpmiPefConfig', IpmiPefConfig):set_bus(bus)
    class('IpmiPefControl', IpmiPefControl):set_bus(bus)
    class('IpmiPefFilter', IpmiPefFilter):set_bus(bus)
    class('IpmiPefAlertFilter', IpmiPefAlertFilter):set_bus(bus)
    class('IpmiPefAlertString', IpmiPefAlertString):set_bus(bus)
    class('SelMsgList', SelMsgList):set_bus(bus)
    class('PersistProperty', PersistProperty):set_bus(bus)
    class('MCDLSDR', MCDLSDR):set_bus(bus)
    class('DEASDR', DEASDR):set_bus(bus)
    class('BMCEnables', BMCEnables):set_bus(bus)
    class('BootError', BootError):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplThresholdSensorPropertiesGetOptions(cb)
    class('ThresholdSensor')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplThresholdSensorPropertiesGetPropertiesByOptions(cb)
    class('ThresholdSensor')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetThresholdSensorList(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetThresholdSensorList = function(obj, ctx, ...)
        local req = sensors_intf_types.GetThresholdSensorListReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetThresholdSensorListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsMockSensor(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].MockSensor = function(obj, ctx, ...)
        local req = sensors_intf_types.MockSensorReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.MockSensorRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetSensorList(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetSensorList = function(obj, ctx, ...)
        local req = sensors_intf_types.GetSensorListReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetSensorListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsSetSensorStatus(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].SetSensorStatus = function(obj, ctx, ...)
        local req = sensors_intf_types.SetSensorStatusReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.SetSensorStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsExportSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].ExportSel = function(obj, ctx, ...)
        local req = sensors_intf_types.ExportSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.ExportSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetSel = function(obj, ctx, ...)
        local req = sensors_intf_types.GetSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetDiscreteSensorList(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetDiscreteSensorList = function(obj, ctx, ...)
        local req = sensors_intf_types.GetDiscreteSensorListReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetDiscreteSensorListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetReportedSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetReportedSel = function(obj, ctx, ...)
        local req = sensors_intf_types.GetReportedSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetReportedSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsDumpSDR(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].DumpSDR = function(obj, ctx, ...)
        local req = sensors_intf_types.DumpSDRReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.DumpSDRRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsAddOemSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].AddOemSel = function(obj, ctx, ...)
        local req = sensors_intf_types.AddOemSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.AddOemSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsClearSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].ClearSel = function(obj, ctx, ...)
        local req = sensors_intf_types.ClearSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.ClearSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsPropertiesGetOptions(cb)
    class('Sensors')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsPropertiesGetPropertiesByOptions(cb)
    class('Sensors')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiscreteSensorPropertiesGetOptions(cb)
    class('DiscreteSensor')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiscreteSensorPropertiesGetPropertiesByOptions(cb)
    class('DiscreteSensor')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplEntityPropertiesGetOptions(cb)
    class('Entity')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplEntityPropertiesGetPropertiesByOptions(cb)
    class('Entity')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiscreteEventPropertiesGetOptions(cb)
    class('DiscreteEvent')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiscreteEventPropertiesGetPropertiesByOptions(cb)
    class('DiscreteEvent')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorSelInfoPropertiesGetOptions(cb)
    class('SensorSelInfo')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorSelInfoPropertiesGetPropertiesByOptions(cb)
    class('SensorSelInfo')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootErrorPropertiesGetOptions(cb)
    class('BootError')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBootErrorPropertiesGetPropertiesByOptions(cb)
    class('BootError')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
