#! /bin/bash
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
        #  http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
if [ ! -d /dev/shm/dbus ]; then
  mkdir -p /dev/shm/dbus
fi

if [ ! -f /dev/shm/dbus/.dbus ]; then
  if [ ! -f /opt/bmc/dbus.config ]; then
    dbus-launch >/dev/shm/dbus/.dbus
  else
    dbus-launch --config-file /opt/bmc/dbus.config >/dev/shm/dbus/.dbus
  fi
fi

# 避免LD_LIBRARY_PATH为空时环境变量装载空目录，执行命令会优先访问同级目录的动态库
if [ -z $LD_LIBRARY_PATH ];then
    echo "LD_LIBRARY_PATH=/opt/bmc/lib:/lib:/lib64:/usr/lib:/usr/lib64:/usr/local/lib:/usr/local/lib64" >>/dev/shm/dbus/.dbus
else
    echo "LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/opt/bmc/lib:/lib:/lib64:/usr/lib:/usr/lib64:/usr/local/lib:/usr/local/lib64" >>/dev/shm/dbus/.dbus
fi

echo "DBUS_FATAL_WARNINGS=0" >>/dev/shm/dbus/.dbus
export $(cat /dev/shm/dbus/.dbus)
