#!/bin/bash
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
        #  http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

# G_COUNT是函数总数，增加函数需要加一
G_COUNT=2
G_FLAG="/data/var/firstboot.flag"
G_POWEROFF_DB="/data/trust/persistence/per_poweroff.db"
G_RESET_DB="/opt/bmc/pram/persistence/per_reset.db"

function func1()
{
    # 旧版本存在CSR数据未修改被持久化的问题，首次升级新版本时需要对持久化数据进行清理，避免CSR数据更新不生效
    # 直接清理的数据：t_cooling_requirement表的CustomTargetTemperatureCelsius, FailedValue字段; t_pcie_addr_info表的Bus, Device, Function字段
    # 判断等于默认值才清理的数据：配置文件中包含的字段
    DATA_TO_DELETE_INI=/opt/bmc/conf/persistence_data_to_delete.ini
    if [[ -f "${G_POWEROFF_DB}" ]]; then
        /usr/sbin/sqlite3 "${G_POWEROFF_DB}" "DELETE FROM persist_table WHERE table_name='t_cooling_requirement' AND persist_param IN ('CustomTargetTemperatureCelsius', 'FailedValue');"
        if [[ -f "${DATA_TO_DELETE_INI}" ]]; then
            while read table_name persist_param persist_val; do
                if [[ -n "${table_name}" && -n "${persist_param}" && -n "${persist_val}" ]]; then
                    /usr/sbin/sqlite3 "${G_POWEROFF_DB}" "DELETE FROM persist_table WHERE table_name='${table_name}' AND persist_param='${persist_param}' AND persist_val='${persist_val}';"
                fi
            done < "${DATA_TO_DELETE_INI}"
        fi
    fi
    if [[ -f "${G_RESET_DB}" ]]; then
        /usr/sbin/sqlite3 "${G_RESET_DB}" "DELETE FROM persist_table WHERE table_name='t_pcie_addr_info' AND persist_param IN ('Bus', 'Device', 'Function');"
    fi
}

function func2()
{
    # 旧版本存在CSR数据未修改被持久化的问题，首次升级新版本时需要对持久化数据进行清理，避免CSR数据更新不生效
    # 直接清理的数据：
    # t_cooling_requirement表的SmartCoolingTargetTemperature, TargetTemperatureCelsius, MaxAllowedTemperatureCelsius字段
    # t_cooling_policy表的Hysteresis, TemperatureRangeLow, TemperatureRangeHigh, SpeedRangeLow, SpeedRangeHigh字段
    if [[ -f "${G_POWEROFF_DB}" ]]; then
        /usr/sbin/sqlite3 "${G_POWEROFF_DB}" "DELETE FROM persist_table WHERE table_name='t_cooling_requirement' AND persist_param IN ('SmartCoolingTargetTemperature', 'TargetTemperatureCelsius', 'MaxAllowedTemperatureCelsius');"
        /usr/sbin/sqlite3 "${G_POWEROFF_DB}" "DELETE FROM persist_table WHERE table_name='t_cooling_policy' AND persist_param IN ('Hysteresis', 'TemperatureRangeLow', 'TemperatureRangeHigh', 'SpeedRangeLow', 'SpeedRangeHigh');"
    fi
}

function sync_cmd()
{
    if [[ ! -f "${G_FLAG}" ]]; then
        echo 0 > "${G_FLAG}"
    fi
    local flag=$(cat "${G_FLAG}")
    if [[ "${flag}" == "${G_COUNT}" ]]; then
        exit 0
    fi
    while [[ ${flag} -lt ${G_COUNT} ]]; do
        flag=$((flag + 1))
        func${flag}
    done
}

function update_flag()
{
   echo "${G_COUNT}" > "${G_FLAG}" 
}

sync_cmd
update_flag