#!/bin/bash
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
        #  http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

set $1
for i in "$@"; do
    size=$(stat -c %s $i)
    if [ $? -ne 0 ]; then
        continue
    fi
    if [ ${size} -gt 104857600 ]; then
        log_str=$(date "+%Y-%m-%d %H:%M:%S")" ERROR : The $i file is too large and needs to be deleted."
        echo $log_str > $i;
        echo $log_str >> /var/log/maintenance.log;
    fi 2> /dev/null || true
done
