-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local dt_mdb = require 'tree'

local mdb_access = {}

local Object = {}

Object.__index = function(object, prop)
    local obj = dt_mdb.get_instance()
    local ok = obj:get_object(object.path, object.interface)
    if ok[prop] then
        return ok[prop]
    end

    return Object[prop]
end

Object.__newindex = function(object, prop, value)
    local obj = dt_mdb.get_instance()
    obj:change_prop(object.path, object.interface, prop, value)
    return 0
end

function Object:get_properties()
    local obj = dt_mdb.get_instance()
    return obj:get_object(self.path, self.interface)
end

function Object.new(path, interface)
    return setmetatable({
        path = path,
        interface = interface,
        prop_configs = {},
        method_configs = {}
    }, Object)
end

local function get_object(_, path, interface)
    local object = Object.new(path, interface)
    return object
end

mdb_access.get_object = get_object

function mdb_access.get_properties(bus, path, interface, _)
    return get_object(bus, path, interface):get_properties()
end

return mdb_access
