-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local json = require 'cjson'
local message = require 'mc.message'

local utils = {}

local function create_one_extended_info(err)
    local info = json.json_object_new_object()
    info['@odata.type'] = '#Message.v1_0_0.Message'
    local message_version, _ = err.RegistryVersion:match('^(.*)%.([^%.]*)$')
    info.MessageId = err.RegistryPrefix .. '.' .. message_version .. '.' .. err.MessageName
    info.RelatedProperties = json.json_object_from_table(err.RelatedProperties) or json.json_object_new_array()
    info.Message = err.Message
    info.MessageArgs = json.json_object_from_table(err.MessageArgs) or json.json_object_new_array()
    info.Severity = err.Severity
    info.Resolution = err.Resolution
    return info
end

function utils.create_error_message(message_name, related_property, message_args)
    local err_message = message.create_message({name = message_name}, message_args, related_property) or {}
    return create_one_extended_info(err_message)
end

return utils
