-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local init_state, force_reset, pwd_expiration

-- account_id大于等于1000为ldap用户，不涉及initial_state, force_passwd_reset
local account_id = ProcessingFlow[2].Destination.AccountId
if account_id and tonumber(account_id) >= 1000 then
    goto continue
else
    init_state = ProcessingFlow[3].Destination.PasswordChangeRequired
    force_reset = ProcessingFlow[3].Destination.FirstLoginPolicy == 2
    pwd_expiration = ProcessingFlow[3].Destination.PasswordExpiration
end
-- 非首次登录场景直接返回,不校验首次登录总开关
if not init_state and not force_reset then
    goto continue
end
if not ProcessingFlow[4].Destination.InitialPasswordNeedModify then
    -- 首次登录功能未使能
    init_state = false
    force_reset = false
end
::continue::
local insecure_prompt_enabled
if init_state and ProcessingFlow[4].Destination.InitialPasswordPromptEnable then
    insecure_prompt_enabled = 'On'
else
    insecure_prompt_enabled = 'Off'
end
return {
    InitState = init_state,
    ForceReset = force_reset,
    PwdExpiration = pwd_expiration,
    IsecurePromptEnabled = insecure_prompt_enabled
}
