-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local power_state = ProcessingFlow[5].Destination.PowerState
local temperature = ProcessingFlow[2].Destination.TemperatureCelsius
local protocol = ProcessingFlow[2].Destination.Protocol
local media_type = ProcessingFlow[2].Destination.MediaType
-- nvme盘protocol为6、media_type为1
if media_type == 1 and protocol == 6 and power_state ~= 'ON' then
    -- 没有上电时，不显示nvme硬盘温度
    return cjson.null
else
    -- 原有逻辑
    return ((temperature == 255) and cjson.null or (temperature > 127) and (temperature - 256) or temperature)
end