-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local memory = Input
if not cjson.json_object_is_array(memory) then
    return memory
end

local real_memory = cjson.json_object_new_array()
for i = 1, #memory do
    if #memory[i] ~= 0 then
        local general_obj = cjson.json_object_new_object()
        general_obj.General = cjson.json_object_new_object()
        general_obj.General.AllowedSpeedsMHz = memory[i].General.AllowedSpeedsMHz
        general_obj.General.CapacityMiB = memory[i].General.CapacityMiB
        general_obj.General.DeviceLocator = memory[i].General.DeviceLocator
        general_obj.General.DeviceType = memory[i].General.DeviceType
        general_obj.General.Manufacturer = memory[i].General.Manufacturer
        general_obj.General.OperatingSpeedMHz = memory[i].General.OperatingSpeedMHz
        general_obj.General.Position = memory[i].General.Position

        real_memory[#real_memory + 1] = general_obj
    end
end

table.sort(real_memory, function(a , b)
    return (a.General.DeviceLocator or '') < (b.General.DeviceLocator or '')
end)

return real_memory