-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local memory = Input
if not cjson.json_object_is_array(memory) then
    return memory
end

local init_memory = cjson.json_object_new_object()

for i = 1, #memory do
    if #memory[i] ~= 0 then
        local str = string.format('%s%s', memory[i].General.Position, memory[i].General.DeviceLocator)
        if str == Uri.memoryid then
            local general_obj = cjson.json_object_new_object()
            general_obj.General = cjson.json_object_new_object()
            general_obj.General.AllowedSpeedsMHz = memory[i].General.AllowedSpeedsMHz
            general_obj.General.CapacityMiB = memory[i].General.CapacityMiB
            general_obj.General.DataWidthBits = memory[i].General.DataWidthBits
            general_obj.General.DeviceLocator = memory[i].General.DeviceLocator
            general_obj.General.DeviceType = memory[i].General.DeviceType
            general_obj.General.Manufacturer = memory[i].General.Manufacturer
            general_obj.General.ManufacturerID = memory[i].General.ManufacturerID
            general_obj.General.ManufacturingDate = memory[i].General.ManufacturingDate
            general_obj.General.ManufacturingLocation = memory[i].General.ManufacturingLocation
            general_obj.General.MinVoltageMillivolt = memory[i].General.MinVoltageMillivolt
            general_obj.General.OperatingSpeedMHz = memory[i].General.OperatingSpeedMHz
            general_obj.General.PartNumber = memory[i].General.PartNumber
            general_obj.General.Position = memory[i].General.Position
            general_obj.General.RankCount = memory[i].General.RankCount
            general_obj.General.SerialNumber = memory[i].General.SerialNumber
            general_obj.General.TypeDetail = memory[i].General.TypeDetail
            return general_obj
        end
    end
end

return init_memory