-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local results = {}
local senser_list = ProcessingFlow[1].Destination.SensorList
local is_multihost = ProcessingFlow[2].Destination.HostType == 'Multihost'


if not senser_list or #senser_list == 0 then
    return results
end

local sensor_item
local status
for i = 1, #senser_list do
    sensor_item = senser_list[i]
    status = sensor_item.SensorStatus
    results[#results + 1] = {
        Name = sensor_item.SensorName,
        SystemId = is_multihost and (sensor_item.SystemId ~= 0 and sensor_item.SystemId or cjson.null) or 1,
        Status = status == 'na' and 'Disabled' or status
    }
end

return results