-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

---获取固件的版本号
---@param version string 固件的版本号
---@param location string 固件在PCB板上的单元编号，如：U82
---@return string
function m.get_version(version, location)
    if version == nil then
        return nil
    end

    if location ~= nil and location ~= "" then
        version = version .. "(" .. location .. ")"
    end

    return version
end

---获取Bios的固件版本号
function m.get_bios_version(version, location)
    if version == nil or version == "000" then
        return nil
    end

    return m.get_version(version, location)
end

return m
