-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local context = require 'mc.context'
local OBJECT_PROPERTIES_INTERFACE<const> = 'bmc.kepler.Object.Properties'
--FruCtrl所在服务
local FRUCTRL_MDB_SERVICE <const> = "bmc.kepler.fructrl"
--FruCtrl资源树接口
local FRUCTRL_MDB_INTF <const> = "bmc.kepler.Systems.FruCtrl"
--fru 序号
local FRU_POS <const> = 1
local m = {}
 
local function get_sysid(path)
    local sysid = -1
    local err, rsp = bus:pcall(FRUCTRL_MDB_SERVICE, path, OBJECT_PROPERTIES_INTERFACE, 'GetAllWithContext', 'a{ss}s',
        context.get_context() or context.new(), OBJECT_PROPERTIES_INTERFACE)
    if not err then
        local identifier = rsp.ObjectIdentifier and rsp.ObjectIdentifier:value()
        if identifier then
            sysid = identifier[1]
        end
    end
    return tostring(sysid)
end

function m.get_powerstate_list(input)
    local res = {}
    local realpath
    local obj
    local data
    for _, path in ipairs(input) do
        data = {}
        realpath = path[FRU_POS]
        obj = mdb.get_object(bus, realpath, FRUCTRL_MDB_INTF)
        data["SystemId"] = get_sysid(realpath)
        if obj.PowerState=='ON' or obj.PowerState=='OFFING' then
            data["State"] = 'On'
        end
        if obj.PowerState=='OFF' or obj.PowerState=='ONING' then
            data["State"] = 'Off'
        end
        table.insert(res, data)
    end
    return res
end

function m.get_poweroffaftertimeout_list(input)
    local res = {}
    local realpath
    local obj
    local data
    for _, path in ipairs(input) do
        data = {}
        realpath = path[FRU_POS]
        obj = mdb.get_object(bus, realpath, FRUCTRL_MDB_INTF)
        data["SystemId"] = get_sysid(realpath)
        if obj.GracefulShutdownTimeoutEnabled == 1 then
            data["Enabled"] = 'On'
        end
        if obj.GracefulShutdownTimeoutEnabled == 0 then
            data["Enabled"] = 'Off'
        end
        data["TimeoutSeconds"] = obj.GracefulShutdownTimeoutSeconds
        data["DefaultSeconds"] = obj.GracefulShutdownDefaultTimeoutSeconds
        data["MinSeconds"] = obj.GracefulShutdownMinTimeoutSeconds
        data["MaxSeconds"] = obj.GracefulShutdownMaxTimeoutSeconds
        table.insert(res, data)
    end
    return res
end

function m.get_fru_pathlist(input)
    local res = {}
    for _, path in ipairs(input) do
        table.insert(res, path[FRU_POS])
    end
    return res
end

function m.get_systemid(input)
    if not input or input=='' then
        return "1"
    end 
    return input
end

return m