-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}
local cjson = require 'cjson'

function m.get_expand_parameters(is_clear_conf)
    local ret_paras = {}

    if is_clear_conf then
        ret_paras.RestoreFactorySettings = 'true'
    end

    return ret_paras
end

function m.get_upgrade_progress(progress)
    local res = cjson.json_object_new_array()
    local object
    for _, value in pairs(progress) do
        object = cjson.json_object_new_object()
        object['TaskName'] = value.TaskName
        object['Percentage'] = value.Percentage
        object['TaskState'] = value.TaskState
        object['ErrorCode'] = value.ErrorCode
        object['Component'] = value.Firmware
        object['FileName'] = value.FileName
        res[#res + 1] = object
    end
    return res
end

function m.get_pending_list(list)
    local res = cjson.json_object_new_array()
    local object
    for _, value in pairs(list) do
        object = cjson.json_object_new_object()
        object['SystemId'] = value.SystemId
        object['FirmwareType'] = value.Firmware
        object['ActiveStatus'] = value.ActiveStatus
        object['ActiveAction'] = value.ActiveAction
        res[#res + 1] = object
    end
    return res
end

function m.get_packages(path)
    local res = {}
    local package = {path, {}}
    res[#res + 1] = package
    return res
end

function m.get_active_policy(policy)
    if not policy or #policy == 0 then
        return {}
    end
    local res
    -- 如果有重复值也当作一个值处理
    -- 同时传入两个策略则直接取值ResetAC
    for _, value in pairs(policy) do
        if not res then
            res = value
        elseif res ~= policy then
            res = 'ResetAC'
            break
        end
    end

    return {ActivationControl = res}
end

return m
