-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local sensors = ProcessingFlow[1].Destination.SensorList
local res = {}

for _, sensor in ipairs(sensors) do
    table.insert(res, {
        sensorName = sensor.SensorName,
        sensorReading = sensor.SensorReading,
        sensorUpperNonRecoverable = sensor.UpperFatal == 'null' and 'na' or sensor.UpperFatal,
        sensorUpperCritical = sensor.UpperCritical == 'null' and 'na' or sensor.UpperCritical,
        sensorUpperMinor = sensor.UpperNonCritical == 'null' and 'na' or sensor.UpperNonCritical,
        sensorLowerNonRecoverable = sensor.LowerFatal == 'null' and 'na' or sensor.LowerFatal,
        sensorLowerCritical = sensor.LowerCritical == 'null' and 'na' or sensor.LowerCritical,
        sensorLowerMinor = sensor.LowerNonCritical == 'null' and 'na' or sensor.LowerNonCritical,
        sensorStatus = sensor.SensorStatus,
        sensorType = sensor.SensorType,
        sensorPositiveHysteresis = sensor.PosHysteresis == 'null' and
            0 or math.floor(tonumber(sensor.PosHysteresis)),
        sensorNegativeHysteresis = sensor.NegHysteresis == 'null' and
            0 or math.floor(tonumber(sensor.NegHysteresis)),
        sensorPositiveHysteresisString = sensor.PosHysteresis == 'null' and 'na' or sensor.PosHysteresis,
        sensorNegativeHysteresisString = sensor.NegHysteresis == 'null' and 'na' or sensor.NegHysteresis,
        sensorUnit = sensor.BaseUnit,
        sensorEventReadingType = sensor.ReadingType
    })
end

return res