-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

-- 解析fanMode
function m.parse_fan_mode(input)
    local delim = ','
    local comma_pos = string.find(input, delim) -- 查找第一个逗号的位置
    local prop = 'fanMode'
    if not comma_pos then
        if input == '0' then
            return {'Auto', 30}
        end
        if input == '1' then
            return {'Manual', 30}
        end
        if input == '2' then
            return {'Mixed', 30}
        end
        error(base_messages.PropertyValueFormatError(prop, input))
    else
        local mode = string.sub(input, 1, comma_pos - 1) -- 获取逗号前面的字符串
        local timeout = string.sub(input, comma_pos + 1) -- 获取逗号后面的字符串
        timeout = math.tointeger(timeout) -- timeout需要为整数
        if mode == '0' or mode == '2' then -- 数据格式为两段时，第一段只能为1
            error(base_messages.PropertyValueFormatError(prop, input))
        end
        if not timeout then -- 不能转换为整数
            error(base_messages.PropertyValueFormatError(prop, input))
        end
        if timeout < 0 or timeout > 300 then
            error(base_messages.PropertyValueFormatError(prop, input))
        end
        return {'Manual', timeout}
    end
end

function m.check_fan_level(fan_level, level_range)
    if fan_level < level_range[1] or fan_level > 100 then
        error(custom_messages.ValueOutOfRange(fan_level))
    end
    return true
end

return m
