-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local mdb_service = require 'mc.mdb.mdb_service'

local m = {}

function m.get_ps_component_health()
    local health = 0
    local supply_paths = mdb_service.get_sub_paths(bus, "/bmc/kepler/Systems/1/Components", 1,
        { 'bmc.kepler.Systems.Component' }).SubPaths
    for _, supply_path in pairs(supply_paths) do
        local component_obj = mdb.get_object(bus, supply_path, 'bmc.kepler.Systems.Component')
        if component_obj.Name == 'PowerSupply' and component_obj.Health + 1 > health then
            health = component_obj.Health + 1
        end
    end
    if health == 0 then
        -- health值未知记为unknown(6)
        return 6
    end
    return health
end

return m
