-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local HEALTH_STATUS_OK<const> = 1
local HEALTH_STATUS_MINOR<const> = 2
local HEALTH_STATUS_MAJOR<const> = 3
local HEALTH_STATUS_CRITICAL<const> = 4
local HEALTH_STATUS_ABSENCE<const> = 5
local HEALTH_STATUS_UNKNOWN<const> = 6

local m = {}

function m.get_entire_status(input_table, property)
    local entire_status = 0
    for _, v in pairs(input_table) do
        if v[property] > entire_status and v[property] ~= HEALTH_STATUS_ABSENCE then
            entire_status = v[property]
        end
    end
    if entire_status == 0 then
        return HEALTH_STATUS_UNKNOWN
    end
    return entire_status
end

return m
