-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local cjson = require 'cjson'
local utils = require 'mc.utils'

local m = {}

function m.get_extend_elabel_info(input)
    local groups = cjson.json_object_new_array()
    local temp = {}

    for index, _ in ipairs(input) do
        local extend_info = input[index].fruExtendedELabelInfo
        -- 没有扩展信息的frudata不打印回显
        if extend_info == "" then
            goto continue
        end

        -- 记录有多条扩展信息的frudata信息
        local extend_info_table = utils.split(extend_info, ';')
        if #extend_info_table > 1 then
            for i, v in ipairs(extend_info_table) do
                temp[#temp + 1] = index .. ';' .. i .. ';' .. v
            end
            goto continue
        end

        groups[#groups + 1] = input[index]
        ::continue::
    end

    -- 深拷贝json object,并对index赋值
    for _, value in ipairs(temp) do
        local data = utils.split(value, ';')
        groups[#groups + 1] = cjson.json_object_copy(input[tonumber(data[1])])
        groups[#groups].fruExtendedELabelIndex = tonumber(data[2])
        groups[#groups]['@Instance'][2] = tonumber(data[2])
        groups[#groups].fruExtendedELabelInfo = data[3]
    end

    return groups
end

function m.get_snmp_component_list(input)
    local groups = cjson.json_object_new_array()
    for index, _ in ipairs(input) do
        -- 电源不打印
        if input[index].componentType == 4 then
            goto continue
        end

        groups[#groups + 1] = input[index]
        ::continue::
    end
    return groups
end

-- 不需要特殊处理的板卡类型
local component_type_mib_table = {
    [5] = 5,               -- 0x05：硬盘背板
    [6] = 6,               -- 0x06：RAID扣卡
    [36] = 10,             -- 36：CPU Board
    [76] = 76,             -- 0x4C：水平转接板
    [195] = 16             -- 195：SEU riserCard
}

function m.get_snmp_type(input)
    -- V3规范中CpuBoard类型值为36
    -- MIB文件中CpuBoard类型值为10
    -- 需要转换
    if component_type_mib_table[input] then
        return component_type_mib_table[input]
    end

    return input + 1
end

return m
