-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- 提供给账号相关业务的插件代码

local log = require 'mc.logging'
local m = {}

local USER_ID_MIN<const> = 2
local USER_ID_MAX<const> = 17

--@function 过滤用户路径，过滤掉用户id不在2-17的用户
--@param path_table: 资源树上用户的路径列表
--@return 过滤后的列表
function m.filter_user_path(path_table)
    for i=#path_table, 1, -1 do
        local path = path_table[i]
        -- 获取最后一个/后面的数字，表示用户id
        local user_id = tonumber(string.match(path, "^.*/(%d+)$"))
        if user_id < USER_ID_MIN or user_id > USER_ID_MAX  then
            table.remove(path_table, i)
        end
    end
    return path_table
end

return m
