```
            _  _ 
  ___ ___  | || |_
/ '_ ` _ \ | ||   _ \
| | | | | || ||  (_) |
\_| |_| |_||_||_ ___/ 
```
# mib
## 一、mib文件介绍
MIB(Management Information Base)文件是SNMP的核心组成部分，用于定义网络设备中可管理对象的结构、数据类型及层级关系。

## 二、目录层级划分
```
.
└── interface_config
    └── snmp
        └── mib
            ├── HUAWEI-SERVER-iBMC-MIB.mib    #华为专用mib文件
            ├── OPENUBMC-SERVER-MIB.mib       #openUBMC提供的mib文件
            └── README.md                     #mib文件的说明
```

## 三、HUAWEI-SERVER-iBMC-MIB.mib文件讲解
HUAWEI-SERVER-iBMC-MIB.mib文件是华为专用mib文件。

## 四、OPENUBMC-SERVER-MIB.mib文件讲解
OPENUBMC-SERVER-MIB.mib文件作为openUBMC提供的mib文件。

### 1 使用前需要替换占位符中的内容
在使用前，需要将占位符${}中的内容进行替换，其中x是占位符对应的值
${enterprisesOID}-------顶级私有OID，基于enterprises的子节点
${openubmcOID}----------产品线的子节点，openUBMC下第x个子节点
${productsOID}----------服务器的产品类别，Products下的第x个子节点
${serverOID}------------BMC模块Server下第x个子节点

参考配置如下,其中${enterprisesOID}为2011、${openubmcOID}为2、${productsOID}为235、${serverOID}为1：
```
openubmc OBJECT IDENTIFIER ::= { enterprises 2011 }
products OBJECT IDENTIFIER ::= { openubmc 2 }
server OBJECT IDENTIFIER ::= { products 235 }
bmc OBJECT IDENTIFIER ::= { server 1 }
```

### 2、模块标识（MODULE-IDENTITY）中新增相应信息
LAST-UPDATED-------模块最后更新时间（格式YYYYMMDDHHMMSSZ）
ORGANIZATION-------组织名称
CONTACT-INFO-------联系信息（官网、邮编、邮箱）
DESCRIPTION-------模块功能描述（管理服务器的MIB对象）

比如：
```
LAST-UPDATED 	"201110250000Z"  
ORGANIZATION 	"xxx Technologies Co.,Ltd."
CONTACT-INFO
            " http://www.xxx.com
                Zip:518129   E-mail:support@xxx.com "    
DESCRIPTION
            "The OPENUBMC-SERVER-MIB contains objects to Manage the server."
```