-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local vendorid = ProcessingFlow[12].Destination.ProductVendorID
local uniqueid = ProcessingFlow[12].Destination.ProductUniqueID

if string.len(vendorid) ~= 10 or string.len(uniqueid) ~= 10 then
    return
end

if string.upper(vendorid) ~= "0XFFFFFFFF" then
    return string.format("0x%08X%08X", tonumber(string.sub(vendorid, 3), 16), tonumber(string.sub(uniqueid, 3), 16))
else
    return string.format("0x%08X", tonumber(string.sub(uniqueid, 3), 16))
end
