-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

metrics_json = cjson.json_object_new_array()
local CollectionDurationIndex<const> = 1
local CollectionFunctionIndex<const> = 2
local CollectionTimeScopeIndex<const> = 3
local MetricIdIndex<const> = 4
for i, metric in ipairs(Input) do
    metrics_json[i] = cjson.json_object_new_array()
    metrics_json[i][CollectionDurationIndex] = metric.CollectionDuration or ''
    metrics_json[i][CollectionFunctionIndex] = metric.CollectionFunction or ''
    metrics_json[i][CollectionTimeScopeIndex] = metric.CollectionTimeScope or ''
    metrics_json[i][MetricIdIndex] = metric.MetricId or ''
end
return metrics_json