-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local METRIC_DEF_PREFIX<const> = '/redfish/v1/TelemetryService/MetricDefinitions/'
local metric_def
for _, v in ipairs(Input) do
    if not v.MetricId then
        goto continue 
    end
    metric_def = table.concat({METRIC_DEF_PREFIX, v.MetricId})
    v.MetricDefinition = cjson.json_object_new_object()
    v.MetricDefinition['@odata.id'] = metric_def
    ::continue::
end
return Input