-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local system_id = Uri.systemid
local adapter_object_name = string.format('NetworkAdapter_1_%s',
    ProcessingFlow[5].Destination.ObjectIdentifier[4])
local port_object_name = string.format('NetworkPort_%s_%s',
    string.format("%02d", ProcessingFlow[3].Destination.Id), ProcessingFlow[5].Destination.ObjectIdentifier[4])
local port_path =
    string.format( '/bmc/kepler/Systems/%s/NetworkAdapters/%s/Ports/%s',
    system_id, adapter_object_name, port_object_name)
return port_path