-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local id = string.lower(Uri.processorid)
if string.match(id, 'gpu%d+') then
    return 'GPU' .. string.match(id, '%d+')
elseif string.match(id, 'npu%d+') then
    local id = tonumber(string.match(id, '%d+')) - 1
    return string.format('NPU%d-%d', (id // 2) + 1, (id % 2) + 1)
elseif string.match(Uri.processorid, '%d+') then
    return ProcessingFlow[4].Destination.DeviceLocator
end
