-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local systemid = Uri.systemid
local sum = #Input
local skip = Query.Skip or 0
local top = Query.Top or ((sum - skip) > 32 and 32 or (sum - skip))
local DEF_TOP = 32
if sum >= (skip + top + DEF_TOP) then
    return '/redfish/v1/Systems/' .. systemid .. '/Memory' ..
    '?$skip=' .. (skip + top) .. '&$top=32'
elseif sum > (skip + top) then
    return '/redfish/v1/Systems/' .. systemid .. '/Memory' ..
    '?$skip=' .. (skip + top) .. '&$top=' .. (sum - skip - top)
else
    return nil
end